/* mbed Library for FTDI FT800  Enbedded Video Engine "EVE"
 * ported to mbed by Peter Drescher, DC2PD 2014
 * Released under the MIT License: http://mbed.org/license/mit */
 
 /* change this file to adapt other LCD screens */
 
 // https://github.com/RudolphRiedel/FT800-FT813/blob/master/FT8_config.h
 
#ifndef FT_LCD_TYPE_H
#define FT_LCD_TYPE_H

// http://www.ftdichip.com/Products/Modules/EVE2Modules.html

//#define ME800A_HV35R (1)  // 480x320
//#define ME810A_HV35R (1)  // 480x320
//#define EVE2_43G (1)  // 480x272
//#define ME812A_WH50R (1)  // 800x480
//#define ME812AU_WH50R (1)  // 800x480
//#define ME813A_WH50C (1)  // 800x480
//#define ME813AU_WH50C (1)  // 800x480
//#define ME810A_WH70R (1)
//#define ME811A_WH70C (1)
#define EVE_RVT70 (1) //800x480

#define SAMAPP_ENABLE_APIS_SET0
#define SAMAPP_ENABLE_APIS_SET1
#define SAMAPP_ENABLE_APIS_SET2
#define SAMAPP_ENABLE_APIS_SET3
#define SAMAPP_ENABLE_APIS_SET4
#define SAMAPP_ENABLE_APIS_SET5
#define SAMAPP_ENABLE_APIS_SET6
#define SAMAPP_ENABLE_APIS_SET7
#define SAMAPP_ENABLE_APIS_SET8
#define SAMAPP_ENABLE_APIS_SET9

/* Global variables for display resolution to support various display panels */
/* Default is WQVGA - 480x272 */

/* Macros for display panels */

// QVGA 320x240
#define FT_DISPLAY_HSIZE_QVGA_320x240           (320L) // DispWidth  display width
#define FT_DISPLAY_VSIZE_QVGA_320x240           (240L) // DispHeight display height
#define FT_DISPLAY_HCYCLE_QVGA_320x240          (408L) // DispHCycle
#define FT_DISPLAY_HOFFSET_QVGA_320x240         (70L)  // DispHOffset
#define FT_DISPLAY_HSYNC0_QVGA_320x240          (0L)   // DispHSync0
#define FT_DISPLAY_HSYNC1_QVGA_320x240          (10L)  // DispHSync1
#define FT_DISPLAY_VCYCLE_QVGA_320x240          (263L) // DispVCycle
#define FT_DISPLAY_VOFFSET_QVGA_320x240         (13L)  // DispVOffset
#define FT_DISPLAY_VSYNC0_QVGA_320x240          (0L)   // DispVSync0
#define FT_DISPLAY_VSYNC1_QVGA_320x240          (2L)   // DispVSync1
#define FT_DISPLAY_PCLK_QVGA_320x240            (8)    // DispPCLK
#define FT_DISPLAY_SWIZZLE_QVGA_320x240         (2)    // DispSwizzle
#define FT_DISPLAY_PCLKPOL_QVGA_320x240         (0)    // DispPCLKPol
#define FT_DISPLAY_DISPCSPREAD_QVGA_320x240     (1)    // DispCSpread
#define FT_DISPLAY_DISPDITHER_QVGA              (1)    // DispDither

// WQVGA 480x272
#define FT_DISPLAY_HSIZE_WQVGA_480x272          (480L) // DispWidth  display width
#define FT_DISPLAY_VSIZE_WQVGA_480x272          (272L) // DispHeight display height
#define FT_DISPLAY_HCYCLE_WQVGA_480x272         (548L) // DispHCycle
#define FT_DISPLAY_HOFFSET_WQVGA_480x272        (43L)  // DispHOffset
#define FT_DISPLAY_HSYNC0_WQVGA_480x272         (0L)   // DispHSync0
#define FT_DISPLAY_HSYNC1_WQVGA_480x272         (41L)  // DispHSync1
#define FT_DISPLAY_VCYCLE_WQVGA_480x272         (292L) // DispVCycle
#define FT_DISPLAY_VOFFSET_WQVGA_480x272        (12L)  // DispVOffset
#define FT_DISPLAY_VSYNC0_WQVGA_480x272         (0L)   // DispPCLKPol
#define FT_DISPLAY_VSYNC1_WQVGA_480x272         (10L)  // DispVSync1
#define FT_DISPLAY_PCLK_WQVGA_480x272           (5)    // DispPCLK
#define FT_DISPLAY_SWIZZLE_WQVGA_480x272        (0)    // DispSwizzle
#define FT_DISPLAY_PCLKPOL_WQVGA_480x272        (1)    // DispPCLKPol
#define FT_DISPLAY_DISPCSPREAD_WQVGA_480x272    (1)    // DispCSpread
#define FT_DISPLAY_DISPDITHER_WQVGA_480x272     (1)    // DispDither

// HVGA 320x480 Portrait
#define FT_DISPLAY_HSIZE_HVGA_480x320          (320L) // DispWidth  display width
#define FT_DISPLAY_VSIZE_HVGA_480x320          (480L) // DispHeight display height
#define FT_DISPLAY_HCYCLE_HVGA_480x320         (400L) // DispHCycle
#define FT_DISPLAY_HOFFSET_HVGA_480x320        (40L)  // DispHOffset
#define FT_DISPLAY_HSYNC0_HVGA_480x320         (0L)   // DispHSync0
#define FT_DISPLAY_HSYNC1_HVGA_480x320         (10L)  // DispHSync1
#define FT_DISPLAY_VCYCLE_HVGA_480x320         (500L) // DispVCycle
#define FT_DISPLAY_VOFFSET_HVGA_480x320        (10L)  // DispVOffset
#define FT_DISPLAY_VSYNC0_HVGA_480x320         (0L)   // DispPCLKPol
#define FT_DISPLAY_VSYNC1_HVGA_480x320         (5L)   // DispVSync1
#define FT_DISPLAY_PCLK_HVGA_480x320           (4)    // DispPCLK
#define FT_DISPLAY_SWIZZLE_HVGA_480x320        (2)    // DispSwizzle
#define FT_DISPLAY_PCLKPOL_HVGA_480x320        (1)    // DispPCLKPol
#define FT_DISPLAY_DISPCSPREAD_HVGA_480x320    (1)    // DispCSpread
#define FT_DISPLAY_DISPDITHER_HVGA_480x320     (1)    // DispDither

// ME812A-WH50R, ME812AU-WH50R, ME813A_WH50C, ME813AU_WH50C
// WVGA 800x480
#define FT_DISPLAY_HSIZE_WVGA_800x480           (800L) // DispWidth  display width
#define FT_DISPLAY_VSIZE_WVGA_800x480           (480L) // DispHeight display height
#define FT_DISPLAY_HCYCLE_WVGA_800x480          (928L) // DispHCycle
#define FT_DISPLAY_HOFFSET_WVGA_800x480         (88L)  // DispHOffset
#define FT_DISPLAY_HSYNC0_WVGA_800x480          (0L)   // DispHSync0
#define FT_DISPLAY_HSYNC1_WVGA_800x480          (48L)  // DispHSync1
#define FT_DISPLAY_VCYCLE_QVGA_800x480          (525L) // DispVCycle
#define FT_DISPLAY_VOFFSET_WVGA_800x480         (32L)  // DispVOffset
#define FT_DISPLAY_VSYNC0_WVGA_800x480          (0L)   // DispVSync1
#define FT_DISPLAY_VSYNC1_WVGA_800x480          (3L)   // DispVSync1
#define FT_DISPLAY_PCLK_WVGA_800x480            (2)    // DispPCLK
#define FT_DISPLAY_SWIZZLE_WVGA_800x480         (0)    // DispSwizzle
#define FT_DISPLAY_PCLKPOL_WVGA_800x480         (1)    // DispPCLKPol
#define FT_DISPLAY_DISPCSPREAD_WVGA_800x480     (0)    // DispCSpread
#define FT_DISPLAY_DISPDITHER_WVGA_800x480      (1)    // DispDither

#if defined(EVE2_43G)
#define my_DispWidth    FT_DISPLAY_HSIZE_WQVGA_480x272
#define my_DispHeight   FT_DISPLAY_VSIZE_WQVGA_480x272
#define my_DispHCycle   FT_DISPLAY_HCYCLE_WQVGA_480x272
#define my_DispHOffset  FT_DISPLAY_HOFFSET_WQVGA_480x272
#define my_DispHSync0   FT_DISPLAY_HSYNC0_WQVGA_480x272
#define my_DispHSync1   FT_DISPLAY_HSYNC1_WQVGA_480x272
#define my_DispVCycle   FT_DISPLAY_VCYCLE_WQVGA_480x272
#define my_DispVOffset  FT_DISPLAY_VOFFSET_WQVGA_480x272
#define my_DispVSync0   FT_DISPLAY_VSYNC0_WQVGA_480x272
#define my_DispVSync1   FT_DISPLAY_VSYNC1_WQVGA_480x272
#define my_DispPCLK     FT_DISPLAY_PCLK_WQVGA_480x272
#define my_DispSwizzle  FT_DISPLAY_SWIZZLE_WQVGA_480x272
#define my_DispPCLKPol  FT_DISPLAY_PCLKPOL_WQVGA_480x272
#endif

#if defined(ME800A_HV35R) || defined(ME810A_HV35R)
#define my_DispWidth    FT_DISPLAY_HSIZE_WQVGA_480x272
#define my_DispHeight   FT_DISPLAY_VSIZE_WQVGA_480x272
#define my_DispHCycle   FT_DISPLAY_HCYCLE_WQVGA_480x272
#define my_DispHOffset  FT_DISPLAY_HOFFSET_WQVGA_480x272
#define my_DispHSync0   FT_DISPLAY_HSYNC0_WQVGA_480x272
#define my_DispHSync1   FT_DISPLAY_HSYNC1_WQVGA_480x272
#define my_DispVCycle   FT_DISPLAY_VCYCLE_WQVGA_480x272
#define my_DispVOffset  FT_DISPLAY_VOFFSET_WQVGA_480x272
#define my_DispVSync0   FT_DISPLAY_VSYNC0_WQVGA_480x272
#define my_DispVSync1   FT_DISPLAY_VSYNC1_WQVGA_480x272
#define my_DispPCLK     FT_DISPLAY_PCLK_WQVGA_480x272
#define my_DispSwizzle  FT_DISPLAY_SWIZZLE_WQVGA_480x272
#define my_DispPCLKPol  FT_DISPLAY_PCLKPOL_WQVGA_480x272
#endif

#if defined(ME813A_WH50C) || defined(ME813AU_WH50C) || defined(ME812A_WH50R) || defined(ME812AU_WH50R)
#define my_DispWidth    FT_DISPLAY_HSIZE_WVGA_800x480
#define my_DispHeight   FT_DISPLAY_VSIZE_WVGA_800x480
#define my_DispHCycle   FT_DISPLAY_HCYCLE_WVGA_800x480
#define my_DispHOffset  FT_DISPLAY_HOFFSET_WVGA_800x480
#define my_DispHSync0   FT_DISPLAY_HSYNC0_WVGA_800x480
#define my_DispHSync1   FT_DISPLAY_HSYNC1_WVGA_800x480
#define my_DispVCycle   FT_DISPLAY_VCYCLE_QVGA_800x480
#define my_DispVOffset  FT_DISPLAY_VOFFSET_WVGA_800x480
#define my_DispVSync0   FT_DISPLAY_VSYNC0_WVGA_800x480
#define my_DispVSync1   FT_DISPLAY_VSYNC1_WVGA_800x480
#define my_DispPCLK     FT_DISPLAY_PCLK_WVGA_800x480
#define my_DispSwizzle  FT_DISPLAY_SWIZZLE_WVGA_800x480
#define my_DispPCLKPol  FT_DISPLAY_PCLKPOL_WVGA_800x480
#endif

/* RVT70xQFxxxxx 800x480 7.0" Riverdi, various options, FT812/FT813, tested with RVT70UQFNWC0x */
#if defined (EVE_RVT70)
#define my_DispWidth   (800L)  /* Thd Length of visible part of line (in PCLKs) - display width */
#define my_DispHeight   (480L)  /* Tvd Number of visible lines (in lines) - display height */

#define my_DispVSync0  (0L)    /* Tvf Vertical Front Porch */
#define my_DispVSync1  (10L)   /* Tvf + Tvp Vertical Front Porch plus Vsync Pulse width */
#define my_DispVOffset (23L)   /* Tvf + Tvp + Tvb Number of non-visible lines (in lines) */
#define my_DispVCycle  (525L)  /* Tv Total number of lines (visible and non-visible) (in lines) */
#define my_DispHSync0  (0L)    /* Thf Horizontal Front Porch */
#define my_DispHSync1  (10L)   /* Thf + Thp Horizontal Front Porch plus Hsync Pulse width */
#define my_DispHOffset (46L)   /* Thf + Thp + Thb Length of non-visible part of line (in PCLK cycles) */
#define my_DispHCycle  (1056L) /* Th Total length of line (visible and non-visible) (in PCLKs) */
#define my_DispPCLKPol (1L)    /* PCLK polarity (0 = rising edge, 1 = falling edge) */
#define my_DispSwizzle (0L)    /* Defines the arrangement of the RGB pins of the FT800 */
#define my_DispPCLK    (2L)    /* 60MHz / REG_PCLK = PCLK frequency 30 MHz */
#define my_DispCSPREAD (1L)    /* helps with noise, when set to 1 fewer signals are changed simultaneously, reset-default: 1 */
#define EVE_TOUCH_RZTHRESH (1800L)  /* touch-sensitivity */ //1800
#define FT81X_ENABLE
#endif

/* the GLYN display has inverted backlite */
//#define Inv_Backlite    

#endif
