#include "PerifConfig.h"
#include "PGA280.h"
#include "ADS1259.h"
#include "PGA280ADS1259.h"
#include "ad5422_arduino.h"
#include "lm35.h"
#include "LT1446.h"
#include "ads1248.h"
#include "flashwrapper.h"
#include <cmath>
#include "FT_Platform.h"
#include "display.h"

/*тип для хранение настроек ПИДа*/  
#ifndef _PID_T //если ещё нету определения типа то создать
typedef struct{
    float kP,kI,kD,sampleTime;
    uint32_t chkd;
    uint8_t
    enabled:1,
    :7;
    }PID_t;
#endif
//тип для "удобного" хранения настроек калибровки дисплея
typedef struct{
    char  calibration[25];
    }Calibration_t;
    
//"переходник" между "голыми" и "осмысленными" данными
typedef union
{
    struct{
    float temp_u;
    float rashod_u;
    PID_t PID;//пид для нагрева колонки
    PID_t PID_R; //ПИД для расхода
    char calibration[25];
    struct {
        float k,b;
    }ADS1248Calibr;
    };
    //массив слов по 4 байта
    uint32_t w[2*sizeof(float)+2*(sizeof(PID_t)/sizeof(uint32_t))+sizeof(Calibration_t)/sizeof(uint32_t)+2*sizeof(float)];
}Mem_t;
Mem_t Mem;//экземпляр "переходника"

typedef struct{
volatile float Error, dError, last_Error;    //Ошибка и предыдущее значение для ПИД
volatile float Integral;    //Интегральная составляющая ПИД-регулятора    
    }PID_prom_t;  //промежуточные значения ПИД

typedef struct{
        float kp,ki,kd,st;
    }PID_defs_t; //тип для хранения настроек по умолчанию

float inline NormADC(long data);
void ComandCheck();
float PID (PID_t *pidx, PID_prom_t *prom);
void printtemp();
float BufToFloat(unsigned char *buf);
void setPIDdefault(PID_t *pidx,PID_defs_t *defs);
void pressed();