#include "mbed.h"
#include "FT_Platform.h"
#include <string>

#ifndef DISPLAY_H_
#define DISPLAY_H_

#ifndef _PID_T
#define _PID_T //запасное определение типа данных для обеспечения работы ПИДа с дисплем (второй раз в main.h)
typedef struct{
    float kP,kI,kD,sampleTime;
    uint32_t chkd;
    uint8_t
    enabled:1,
    :7;
    }PID_t;    
#endif

/**************************************************************************************************************************
************************** Defines using for drawing **********************************************************************
**************************************************************************************************************************/

// all tracking touch screen areas
typedef enum {
    NONE_PRESS,
    CURR_TEMP_PRESS,
    CURR_HUM_PRESS,
    MENU_PRESS,
    CHROM_TEMP_PRESS,               //проверка кнопки
    CHROM_SET_TEMP_PRESS,           //устаносить температуру
    CHROM_SET_RASHOD_PRESS,         //установить расход
    CHROM_SET_SENSGAIN_PRESS,       //установить коэффициент усиления PGA
    CHROM_ANALIZ_PRESS,             //анализ
    CHROM_PROBA_PRESS,              //пробоотбор
    PID_MENU_PRESS,                 //переход в меню ПИД регуляторов
    BACK_PRESS,
    CANCEL_PRESS,
    APPLY_PRESS,
    SAVE_PRESS,
    PID1SW_PRESS,
    PID2SW_PRESS,        
    SEL_P1,
    SEL_I1,
    SEL_D1,    
    SEL_P2,
    SEL_I2,
    SEL_D2,
} pressValues;

//выбранная ячейка для редактирования
typedef enum{
    EDIT_P1=SEL_P1,
    EDIT_I1=SEL_I1,
    EDIT_D1=SEL_D1,
    
    EDIT_P2=SEL_P2,
    EDIT_I2=SEL_I2,
    EDIT_D2=SEL_D2,
    EDIT_NONE,
}selectedEditor_t;

// all existing screens 
typedef enum {
    MENU_SCREEN,
    CURR_HUM_SCREEN,
    CURR_TEMP_SCREEN,
    TEST_CHROM_SCREEN,              //тестовый экран
    PID_SCREEN,
} screenValues;


/**************************************************************************************************************************
************************** User class for drawing at FT800 ****************************************************************
**************************************************************************************************************************/

class Display
{
public:
    // in Display class we use FT800 TFT (definition is available in main.cpp)
    Display(FT813 *TFT) {
        _TFT = TFT;
    }

    // functions describing all available screens (screens-functions)
    void ChromTest(float temp,float ras,int temp_u,float ras_u); //тестовый экран
    void PidScreen(/*костыль костылей*/float (*btf)(unsigned char*),float temp, float ras,uint16_t power1,uint16_t power2,PID_t* PID1,PID_t* PID2);
    void MainMenu(float humidity, float temperature);   // [display.Draw_MainMenu.cpp]
    void CurrentHumidity(float humidity);               // [display.Draw_CurrentValuesGraphs.cpp]
    void CurrentTemperature(float temperature);         // [display.Draw_CurrentValuesGraphs.cpp]

    // functions using to prepare FT800 re = recalibration
    void Calibration(char * calibration,char re);       // [display.Calibration.cpp]

    // functions for touch screen tracking
    char GetTouch(void);                                // [display.GetTouch.cpp]

    // variables using for navigation between screens
    char pressedButton;
    char activeScreen;
    int16_t TouchX,TouchY;
    
    selectedEditor_t selectedEditor;
    unsigned char str_edit[12];
    uint8_t cursor;
    //доп. функции
    void myWdget_Edit(uint16_t x,uint16_t y,uint16_t w,uint16_t h,uint8_t selected,const char * text);
    void Display::myWdget_NumPad(uint16_t x,uint16_t y);
    void Display::myWdget_Edit_change(char * text);

private:
    FT813 *_TFT;

    void StartDL(void);                                 // [display.DisplayListFunctions.cpp]
    void FinishDL(void);                                // [display.DisplayListFunctions.cpp]
    void MainMenuReference(void);                       // [display.Draw_MainMenuReference.cpp]
    void HorisontalGrid_CurrentTemp(void);              // [display.Draw_Grids.cpp]
    void HorisontalGrid_CurrentHumidity(void);          // [display.Draw_Grids.cpp]
    

    void CreateStringTempHum(char *str, float number, bool isTemp);       // [display.StringsTransforming.cpp]

    char humidityStr[8], temperatureStr[8];
    char currentHumidity_X, currentTemperature_X;
    char currentHumidity_Y[68], currentTemperature_Y[68];
};

#endif /* SCREENS_H_ */