#ifndef PERIFCONFIG_H
#define PERIFCONFIG_H
/*Это перенос с языка Си для PIC32 максимально безболезненно*/
#include "mbed.h"

#ifdef  __cplusplus
extern "C" {
#endif

/*Моё начало*/
#define SYS_FREQ (180000000L)
/*настройки для UART1*/
#define BAUD            115200 //бодрейт
#define MYUBRG          SYS_FREQ/16/BAUD-1
/*Конец*/

/*Переименование выводов SPI*/
#define MOSI1                           mosi1  //MOSI настройка вывода SPI1 на выход (на всякий случай)
#define MISO1                           miso2  //MISO
#define SCK1                            sck1 //SCK      
/*Конец*/

/*Период таймера*/
#define PER 0.04 //с
#define PERREG  SYS_FREQ/8*PER-1 //25 fps
#define PER2 0.00001 //10 мкс
#define PERREG2  SYS_FREQ/8*PER2-1 // fps
/*Конец*/

#ifndef CS
#define CS                              Cs       //чипселект
#endif

#define EN1                             En1      //включить что-то

#define ADR0                            Adr0
#define ADR1                            Adr1
#define ADR2                            Adr2

#define RESET                           Reset
#define CRDYA                           CrdyA       //сигнал готовности с АЦП/ЦАП

#define ADS1259_RESET                   Reset
#define ADS1259_RDYA                    CrdyA
#define MUX_AN10_IZM_RRG1               2
#define MUX_AN10_KLAPAN_RRG1            3

#define ADC_CH0                         0
#define ADC_CH1
#define ADC_CH2

#define PGA280_TED                      4
#define PGA280_RRG1                     5
/*конец*/

/*Переопределение имени пинов*/
extern DigitalOut Cs,
En1,
Adr0,
Adr1,
Adr2,
Reset,
LTC1446_CLK,
LTC1446_DOUT,
LTC1446_CS,
ads1259_pin_Start,
ads1259_pin_CS,
/*для платы СБ-1*/
SB1_SWEN,
SB1_SHDN,PosAw,PosBw;

extern DigitalIn CrdyA,MISO,PosAr,PosBr,ads1259_pin_Drdy;
/*Конец*/
//extern SPI TED2;
extern SPI AD1248_SPI;
extern Serial UART;

//компрессор
extern PwmOut Pressure;

typedef union {
    struct {
        uint8_t
        adr0:1,
             adr1:1,
             adr2:1,
             :5;
    };
    struct {
        uint8_t adr:3;
        uint8_t :5;
    };
} adress_t;
extern adress_t adress;


extern unsigned int counter;
extern unsigned char str[32];
extern unsigned char in; //счетчик буфера прерываний
//RING_buffer_t buf_1;                //буфер данных



void GPIO_Init(void);
void UART_Init(void);
void UART1_Transmit(unsigned char data);
void UDebugTransmit(unsigned char cData);
void DebugString (unsigned char *sData, unsigned char sz);
void UART_gets(char maxcount);
void SPI1_MasterInitMode(char mode);
void SPI1_SlaveInit(void);
void SPI1MasterTransmitString(unsigned char *sData,unsigned int sz); //передать строку размером sz
unsigned char SPI1MasterTransferByte(unsigned char cData);//отправить и считать байт
unsigned char SPI3MasterTransferByte(unsigned char cData);
unsigned char SPI1MasterReadByte(void);
void TIMER32bit_Init(void);

namespace std{};
using namespace std;

#ifdef  __cplusplus
}
#endif

#endif  /* PERIFCONFIG_H */