#include "PerifConfig.h"
#include <stdio.h>

/*Переопределение имени пинов для платы ТЭД2*/
DigitalOut Cs(PE_4);
DigitalOut En1(PE_3);

DigitalOut Adr0(PF_0);
DigitalOut Adr1(PF_1);
DigitalOut Adr2(PF_2);

DigitalOut Reset(PA_7);
DigitalIn CrdyA(PF_10);

//SPI TED2(PE_6,PE_5,PE_2);//MOSI,MISO,SCK 
//Конец

/*Плата СБ-1*/
DigitalOut SB1_SWEN(PB_13);
DigitalIn PosAr(PB_12);
DigitalIn PosBr(PA_15);
DigitalOut SB1_SHDN(PC_6);
DigitalOut PosAw(PB_15); 
DigitalOut PosBw(PC_7); 


DigitalOut ads1259_pin_CS(D10);
DigitalOut ads1259_pin_Start(D9);
DigitalIn ads1259_pin_Drdy(D8);

SPI AD1248_SPI(D11, D12, D13);//MOSI,MISO,SCK
/*Конец*/

//выводы для костыльного SPI для ЦАП
DigitalOut LTC1446_CS(D7);
DigitalOut LTC1446_CLK(D6);
DigitalOut LTC1446_DOUT(D5);
/*Конец*/




Serial UART(SERIAL_TX,SERIAL_RX,9600);
extern PwmOut Pressure(D3);

void UART_gets(char maxcount)
/*Функция получения строки и записи её в глобальную переменную str[]*/
{
    int i=0;    
    do
    {
        while (UART.readable())    //перед точкой с запятой цикл    (убрал)
        str[i++]=UART.getc();        
    }
    while ((str[i-2]!=0x0D)&&(str[i-1]!=0x0A));
    for (i=i;i<maxcount;i++)
    {
        str[i]='\0';
    }   
}



void DebugString (unsigned char *sData,unsigned char sz)
{
    /*
    int i;        
    for (i=0;i<sz;i++)
    {
        if (sData[i]==0x00)     //если пришёл символ конца строки то не отправляем что-либо
        {
            i=sz;
        }
        else UART1_Transmit(sData[i]);        
    }
    */
}

void SPI1_MasterInitMode(char mode)
{   
    AD1248_SPI.format(8,mode);
    AD1248_SPI.frequency(20000000);    
}
/*void SPI3_MasterInitMode(char mode)
{   
    TED2.format(8,mode);
    TED2.frequency(100000);
}*/
void SPI1_SlaveInit()
{
    
}


void SPI1MasterTransmitString(unsigned char *sData,unsigned int sz) //передать строку размером sz
{   
    /*
    int i=0;
    for (i=0;i<sz;i++)
    {
        SPI1MasterTransferByte(sData[i]);        
    }
    */
}

unsigned char SPI1MasterTransferByte(unsigned char cData)//отправить и считать байт
{
    return (unsigned char)AD1248_SPI.write(cData);    
}
/*unsigned char SPI3MasterTransferByte(unsigned char cData)//отправить и считать байт
{
    return (unsigned char)TED2.write(cData);    
}*/

unsigned char SPI1MasterReadByte()
{    
    return (unsigned char)AD1248_SPI.write(0xFF);
}