#ifndef ADS1248_H
#define ADS1248_H
#include "PerifConfig.h"

    #define DS1248_CS                               ads1259_pin_CS
    #define DS1248_START                            ads1259_pin_Start
    #define DS1248_DRDY                             ads1259_pin_Drdy
        
    #define DS1248_WAKEUP_COMMAND                   0x00
    #define DS1248_SLEEP_COMMAND                    0x02
    #define DS1248_SYNC_COMMAND                     0x04
    #define DS1248_RESET_COMMAND                    0x06
    #define DS1248_NOP_COMMAND                      0xFF
    #define DS1248_RDATA_COMMAND                    0x12
    #define DS1248_RDATAC_COMMAND                   0x14
    #define DS1248_SDATAC_COMMAND                   0x16

    #define DS1248_RREG_COMMAND                     0x20
    #define DS1248_WREG_COMMAND                     0x40

    #define DS1248_SYSOCAL_COMMAND                  0x60
    #define DS1248_SYSGCAL_COMMAND                  0x61
    #define DS1248_SELFOCAL_COMMAND                 0x62

    #define DS1248_RESTRICTED_COMMAND               0xF1

    // Регистры
    
    #define DS1248_REGISTER_MUX0                    0x00
    #define DS1248_REGISTER_VBIAS                   0x01
    #define DS1248_REGISTER_MUX1                    0x02
    #define DS1248_REGISTER_SYS0                    0x03
    #define DS1248_REGISTER_OFC0                    0x04
    #define DS1248_REGISTER_OFC1                    0x05
    #define DS1248_REGISTER_OFC2                    0x06
    #define DS1248_REGISTER_FSC0                    0x07
    #define DS1248_REGISTER_FSC1                    0x08
    #define DS1248_REGISTER_FSC2                    0x09
    #define DS1248_REGISTER_IDAC0                   0x0A
    #define DS1248_REGISTER_IDAC1                   0x0B
    #define DS1248_REGISTER_GPIOCFG                 0x0C
    #define DS1248_REGISTER_GPIOCDIR                0x0D
    #define DS1248_REGISTER_GPIODAT                 0x0E

    // Настройки регисторов
    
    #define SET_REGISTER_MUX0                       0x01       
    #define SET_REGISTER_MUX1                       0x30
    #define SET_REGISTER_SYS0                       0x08
    #define SET_REGISTER_IDAC0                      0x04
    #define SET_REGISTER_IDAC1                      0xF9
    #define SET_REGISTER_GPIOCFG                    0x00

#define DR5                 0
#define DR10                1
#define DR20                2
#define DR40                3
#define DR80                4
#define DR160               5
#define DR320               6
#define DR640               7
#define DR1000              8
#define DR2000              9

#define PGA_1               0
#define PGA_2               1
#define PGA_4               2
#define PGA_8               3
#define PGA_16              4
#define PGA_32              5
#define PGA_64              6
#define PGA_128             7


    typedef union{
        struct{
            uint8_t
            MUX_SN:3,
            MUX_SP:3,
            BCS:2;
        };
        struct{

        };
        uint8_t all;
    }MUX0_t;

    typedef union{
        struct{
            uint8_t
            VBIAS0:1,
            VBIAS1:1,
            VBIAS2:1,
            VBIAS3:1,
            VBIAS4:1,
            VBIAS5:1,
            VBIAS6:1,
            VBIAS7:1;
        };
        uint8_t all;
    }VBIAS_t;

    typedef union{
        struct{
            uint8_t
            MUXCAL:3,
            REFSELT:2,
            VREFCON:2,
            CLKSTAT:1;
        };
        struct{
            
        };
        uint8_t all;
    }MUX1_t;

    typedef union{
        struct{
            uint8_t
            DR:4,
            PGA:3,
            :1;
        };
        struct{

        };
        uint8_t all;
    }SYS0_t;

    typedef union{
        struct{
        uint8_t
        OFC0,
        OFC1,
        OFC2;
        };
        uint32_t all;
    }OFC_t;

    typedef union{
        struct{
        uint8_t
        FSC0,
        FSC1,
        FSC2;
        };
        uint32_t all;
    }FSC_t;

    typedef union{
        struct{
            uint8_t
            IMAG:3,
            DRDY_MODE:1,
            ID:4;  
        };
        struct{

        };
        uint8_t all;
    }IDAC0_t;

    typedef union{
        struct{
            uint8_t
            I2DIR:4,
            I1DIR:4;
        };
        struct{

        };
        uint8_t all;
    }IDAC1_t;

    typedef union{
        struct{
            uint8_t
            IOCFG0:1,
            IOCFG1:1,
            IOCFG2:1,
            IOCFG3:1,
            IOCFG4:1,
            IOCFG5:1,
            IOCFG6:1,
            IOCFG7:1;
        };
        uint8_t all;
    }GPIOCFG_t;

    typedef union{
        struct{
            uint8_t
            IODIR0:1,
            IODIR1:1,
            IODIR2:1,
            IODIR3:1,
            IODIR4:1,
            IODIR5:1,
            IODIR6:1,
            IODIR7:1;
        };
        uint8_t all;
    }GPIODIR_t;

    typedef union{
        struct{
            uint8_t
            IODAT0:1,
            IODAT1:1,
            IODAT2:1,
            IODAT3:1,
            IODAT4:1,
            IODAT5:1,
            IODAT6:1,
            IODAT7:1;
        };
        uint8_t all;
    }GPIODAT_t;
    
    //архетип устройства
    typedef struct{
        MUX0_t MUX0;
        VBIAS_t VBIAS;
        MUX1_t MUX1;
        SYS0_t SYS0;
        OFC_t OFC;
        FSC_t FSC;
        IDAC0_t IDAC0;
        IDAC1_t IDAC1;
        GPIOCFG_t GPIOCFG;
        GPIODIR_t GPIODIR;
        GPIODAT_t GPIODAT;
        struct {//хранение настроек калибровки
            float k,b;
        }Calibr;
    }ADS1248_t;
    
    
    
    unsigned char ADS1248SleepCommand( void );
    
    unsigned char ADS1248WakeupCommand( void );
    
    unsigned char ADS1248ReadRegister( unsigned char reg, unsigned char num );
    
    unsigned char ADS1248WriteRegister( unsigned char reg, unsigned char num, unsigned char data );
    
    unsigned char ADS1248StartConversion( void );
    
    unsigned long ADS1248ReadData( ADS1248_t * ads );
    
    unsigned char ADS1248SettingReg ( ADS1248_t * ads );
    
    unsigned long ADS1248ReadCalibratedData(ADS1248_t * ads);
    void ADS1248CalibrateSoft(ADS1248_t * ads, float (*btf)(unsigned char *));

#endif /*ADS1248_H*/

