#include "ads1248.h"

unsigned char ADS1248SleepCommand( void )
{    
    DS1248_CS = 0;    
    SPI1MasterTransferByte(DS1248_SLEEP_COMMAND);
    DS1248_CS=1;
    DS1248_START = 0;
    return 0;                
}

unsigned char ADS1248WakeupCommand( void )
{     
    DS1248_CS = 0;
    DS1248_START = 1;                   
    SPI1MasterTransferByte(DS1248_WAKEUP_COMMAND);
    DS1248_CS = 1;    
    return 0;    
}

unsigned char ADS1248ReadRegister( unsigned char reg, unsigned char num )
{
    char res[num];
    DS1248_CS = 0;
    SPI1MasterTransferByte(DS1248_RREG_COMMAND | ( reg & 0x0F ));
    SPI1MasterTransferByte(num - 1);
    while (num--)
    {
        res[num]=SPI1MasterTransferByte(DS1248_NOP_COMMAND);
    }
    DS1248_CS = 1;
     return res[0];
}

unsigned char ADS1248WriteRegister( unsigned char reg, unsigned char num, uint8_t data)
{
    DS1248_CS = 0;
    SPI1MasterTransferByte(DS1248_WREG_COMMAND | ( reg & 0x0F ));
    SPI1MasterTransferByte(num - 1);    
    SPI1MasterTransferByte(data);
    SPI1MasterTransferByte(DS1248_NOP_COMMAND);
    DS1248_CS = 1;    
    return 0;    
}

unsigned char ADS1248StartConversion( void )
{
    DS1248_START = 1;
    
    //delay_us ( 5 );
    
    DS1248_START = 0;
    return 0;
}

unsigned long ADS1248ReadData( ADS1248_t * ads )
{
    
    union{
        struct{
        uint8_t
        b1,b2,b3;
        };
        uint32_t all;
    }data;
    data.all=0;
    
    DS1248_CS = 0;
    wait_us(1);    
    SPI1MasterTransferByte(DS1248_RDATA_COMMAND);
    data.b3=SPI1MasterTransferByte(DS1248_NOP_COMMAND);
    data.b2=SPI1MasterTransferByte(DS1248_NOP_COMMAND);
    data.b1=SPI1MasterTransferByte(DS1248_NOP_COMMAND);
    wait_us(1);
    DS1248_CS = 1;
        
    return data.all;
}

unsigned char ADS1248SettingReg ( ADS1248_t * ads )
{
    DS1248_START = 1;
    DS1248_CS = 0;
    wait_us(1);
    SPI1MasterTransferByte(DS1248_RESET_COMMAND);
    wait_us(600);
    SPI1MasterTransferByte(DS1248_SDATAC_COMMAND);
    
    ADS1248WriteRegister ( DS1248_REGISTER_MUX0, 1, ads->MUX0.all );    
    ADS1248WriteRegister ( DS1248_REGISTER_VBIAS, 1,ads->VBIAS.all);
    ADS1248WriteRegister ( DS1248_REGISTER_MUX1, 1, ads->MUX1.all );    
    ADS1248WriteRegister ( DS1248_REGISTER_SYS0, 1, ads->SYS0.all );
    ADS1248WriteRegister ( DS1248_REGISTER_IDAC0,1, ads->IDAC0.all);
    ADS1248WriteRegister ( DS1248_REGISTER_IDAC1,1, ads->IDAC1.all);    
    ADS1248WriteRegister ( DS1248_REGISTER_FSC0,1, ads->FSC.FSC0);
    ADS1248WriteRegister ( DS1248_REGISTER_FSC1,1, ads->FSC.FSC1);
    ADS1248WriteRegister ( DS1248_REGISTER_FSC2,1, ads->FSC.FSC2);
    
    DS1248_CS = 0;
    SPI1MasterTransferByte(DS1248_SYNC_COMMAND);
    wait_us(1);
    DS1248_CS = 1;
    return 0;
    
}

//вызывать вместо простого чтения АЦП
unsigned long ADS1248ReadCalibratedData(ADS1248_t * ads)
{
    unsigned long result=0;
    //проверка адекватности коэффициентов (не доделана)
    if ((ads->Calibr.k>0)&&(ads->Calibr.b<0x8000000))
    result = ads->Calibr.k*ADS1248ReadData(ads)+ads->Calibr.b;
    else return (0);
    if (result & 0xFF000000) 
    /*Если результат переполнен из-за коэффициентов то данные испорчены.
    Наверное можно просто отбросить старший байт или лучше приравнять максимальному 0x00FFFFFF*/
    return 0;
}

//программная калибровка через терминал, без использования регистров микросхемы
void ADS1248CalibrateSoft(ADS1248_t * ads, /*костыль костылей*/float (*btf)(unsigned char*))
{
    //тут остановить все управляющие воздействия и считывание. Или перед использованием функции.
    /*
    
    */
    UART.printf("ADS CALIBRATE:\r\n");
    __disable_irq ();
    UART_gets(16);
    UART.printf("%s\r\n",str);
    if(str[0]=='k'){    
    float result = btf(str);    
    UART.printf("%f\r\n",result);
    }
    __enable_irq ();
}
