//Copyright 2021 Nikša Zupčić
//
//Licensed under the Apache License, Version 2.0 (the "License"); 
//you may not use this file except in compliance with the License. 
//
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software distributed 
//under the License is distributed on an "AS IS" BASIS, 
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
//See the License for the specific language governing permissions and 
//limitations under the License.
//

#include "mbed.h"

enum _switch_mode {ON, OFF};

class Light{
    public:
        Light(PinName _ledOut) : ledOut(_ledOut){   
        };
        void switchMode(_switch_mode switch_mode){
            switch(switch_mode){
                case ON:
                    ledOut = 1;
                    break;
                case OFF:
                    ledOut = 0;
                    break;
                default:
                    ledOut = 0;
                    break;
             }   
        };
    private:
        DigitalOut ledOut; 
};

Light led1(LED1);
Light led2(LED2);
Light led3(LED3);
Light led4(LED4);

int main() {
    while(1) {
        led1.switchMode(ON);
        wait_ms(500);
        led1.switchMode(OFF);
        led2.switchMode(ON);
        wait_ms(500);
        led2.switchMode(OFF);
        led3.switchMode(ON);
        wait_ms(500);
        led3.switchMode(OFF);
        led4.switchMode(ON);
        wait_ms(500);
        led4.switchMode(OFF);
    }
}
