#include "mbed.h"
#include "eeprom_pgm.h"
#include "display_modules.h"
#include "touch_modules.h"
#include "main.h"

#define Y_UP_PIN                                PTC0                            //Y touch co-ordinate
#define Y_DOWN_PIN                              PTD2
#define X_LEFT_PIN                              PTC13                           //X touch co-ordinate
#define X_RIGHT_PIN                             PTB0

#define TIMER_5MIN                              300000                           
#define TIMER_1MIN                              60000
#define EEPROM_ADDR_GLC_TEST_TYPE               20
#define DEBUG_TIMER_10MS                        10
#define EEPROM_ADDRTEST_TYPE                    30

 
enum Glc_type{FBS, PP, RAN};
enum Test_type{BG, ECG, BP};
//enum Screens{Home_screen=1, Sys_config_screen, Main_screen, BG_main_screen, ECG_main_screen, BP_main_screen, Retest_BG, Retest_ECG, Retest_BP  };        
InterruptIn Touch_D(Y_DOWN_PIN);
Serial kc(USBTX, USBRX);
Timer screen_timer;

bool touch_detect_flag = false;
uint16_t x_coordinate = 0;                                                      //changed from unsigned int to uint16_t nikita 
uint16_t y_coordinate = 0;                                                      //changed from unsigned int to uint16_t nikita 
uint8_t state=0;                                                                //changed from unsigned char to uint8_t nikita 

void touch1()  //determining the touch co-ordinates
{
    x_coordinate = (X_MAX*readTouchX()/TOTAL1);
    y_coordinate = (Y_MAX*readTouchY()/TOTAL1);
    DisableTouch(); 
    kc.printf("%d\n", x_coordinate); 
    kc.printf("%d\n", y_coordinate); 
}


void detect_touch(uint8_t display_state)   // detect the touch //debounce
{
    kc.printf("display state=%d\n",display_state);
    uint32_t time_ms = 0;
    switch (display_state)
    {
        case 3:    
            time_ms = TIMER_5MIN;      // timer for 5 min 
            touch_func_with_timer(time_ms);   
            break;
        case 6:    
            time_ms = TIMER_1MIN;       // timer for 1 min
            touch_func_with_timer(time_ms);   
            break;
        default :  
            touch_func_without_timer();
            break;       
    }
} 

void touch_func_without_timer()
{
    while(touch_detect_flag == true)
    {
        if(!Touch_D)                                                            //touch detection 
        {
            
            touch_detection();
           
         }
    }
}


void touch_detection()
{
    wait_ms(DEBUG_TIMER_10MS);
    if (!Touch_D)
           {   
            
             Touch_D.fall(&touch1);                                             //determine the touch co-ordinates
     
            }
    }




void no_touch()
{
   x_coordinate = 0;
   y_coordinate = 0;
  
}


uint8_t touch_main()    //determining the touch for home screen
{
    
    
    
    if ( ((x_coordinate >= SYSCFG_HOME_X_MIN) && (x_coordinate <= SYSCFG_HOME_X_MAX)) && ( (y_coordinate >= SYSCFG_HOME_Y_MIN) && (y_coordinate <= SYSCFG_HOME_Y_MAX) ) ) // system configuration
    { 
        state = 2;
    }
    
    else if ( ((x_coordinate >= TEST_HOME_X_MIN) && (x_coordinate <= TEST_HOME_X_MAX)) && ( (y_coordinate >= TEST_HOME_Y_MIN) && (y_coordinate <= TEST_HOME_Y_MAX) ) ) // test
    {
        state = 3;
    }   
    else 
        state = 10;   
    
    return state;     
}
   
   
uint8_t touch_main_1()    //determining the touch for System Configuration screen
{

   
    
    if ( ((x_coordinate >= BT_MAIN_X_MIN) && (x_coordinate <= BT_MAIN_X_MAX)) && ( (y_coordinate >= BT_MAIN_Y_MIN) && (y_coordinate <= BT_MAIN_Y_MAX) ) )                                                   // ble
    {
        state = 12;
    }
    
    else if ( ((x_coordinate >= PATIENT_INFO_MAIN_X_MIN) && (x_coordinate <= PATIENT_INFO_MAIN_X_MAX)) && ( (y_coordinate >= PATIENT_INFO_MAIN_Y_MIN) && (y_coordinate <= PATIENT_INFO_MAIN_Y_MAX) ) )    // file
    {
        state = 11;
    }
    else if ( ((x_coordinate >= HOME_SYS_CONFIG_X_MIN) && (x_coordinate <= HOME_SYS_CONFIG_X_MAX)) && ( (y_coordinate >= HOME_SYS_CONFIG_Y_MIN) && (y_coordinate <= HOME_SYS_CONFIG_Y_MAX) ) ) // home
    {
        state = 1;       
    }
    
    else if ((read_debug_status()== true) && get_timer_debug()<TIMER_ENABLE_DEBUG_MODE)                                                                              // checking for the debug status and timer 
    {
        if ( ((x_coordinate >= DEBUG_MAIN_X_MIN) && (x_coordinate <= DEBUG_MAIN_X_MAX)) && ( (y_coordinate >= DEBUG_MAIN_Y_MIN) && (y_coordinate <= DEBUG_MAIN_Y_MAX) ) )                          // DELETE
        {
            state = 13;
        }
    }
    else 
        state=10; 

    kc.printf("state = %d\n", state);    
    return state;     
}


uint8_t touch_main_2()    //determining the touch for TEST screen
{
   
    
    if ( ((x_coordinate >= BG_MAIN_X_MIN) && (x_coordinate <= BG_MAIN_X_MAX)) && ( (y_coordinate >= BG_MAIN_Y_MIN) && (y_coordinate <= BG_MAIN_Y_MAX) ) ) // GLC
    {
        state = 4;
    }
    
    else if ( ((x_coordinate >= ECG_MAIN_X_MIN) && (x_coordinate <= ECG_MAIN_X_MAX)) && ( (y_coordinate >= ECG_MAIN_Y_MIN) && (y_coordinate <= ECG_MAIN_Y_MAX) ) ) // ECG
    {
        state = 5;
    }
    else if ( ((x_coordinate >= BP_MAIN_X_MIN) && (x_coordinate <= BP_MAIN_X_MAX)) && ( (y_coordinate >= BP_MAIN_Y_MIN) && (y_coordinate <= BP_MAIN_Y_MAX) ) ) // BP
    {
        state = 6;
    }
    else if ( ((x_coordinate >= HOME_MAIN_X_MIN) && (x_coordinate <= HOME_MAIN_X_MAX)) && ( (y_coordinate >= HOME_MAIN_Y_MIN) && (y_coordinate <= HOME_MAIN_Y_MAX) ) ) // Home
    {
        state = 1;
    }
    else if (x_coordinate == 0 && y_coordinate == 0)
    {
        state = 1;
    }                    
    else 
    {
        state = 10;      // default -  goes to wait for a valid touch
    }  
    return state;     
}






uint8_t touch_ecg()     // determining the touch for ecg  main screen
{

   
    
    if ( ((x_coordinate >= START_MAIN_X_MIN) && (x_coordinate <= START_MAIN_X_MAX)) && ( (y_coordinate >= START_MAIN_Y_MIN) && (y_coordinate <= START_MAIN_Y_MAX) ) ) // START
    {
        state = 8;
    }
    
    else if ( ((x_coordinate >= MAIN_X_MIN) && (x_coordinate <= MAIN_X_MAX)) && ( (y_coordinate >= MAIN_Y_MIN) && (y_coordinate <= MAIN_Y_MAX) ) ) // RETURN
    {
        state = 3;
    } 
    else 
        state = 10;   
    
    return state;
}
    

uint8_t touch_ret()     // determining the touch for ecg screen after the test
{
      
    uint8_t test_type_retest = 0;
    test_type_retest = eprom_read_8(EEPROM_ADDRTEST_TYPE);
    kc.printf("testtype = %d\n", test_type_retest);
    if ( ((x_coordinate >= RET_TEST_X_MIN) && (x_coordinate <= RET_TEST_X_MAX)) && ( (y_coordinate >= RET_TEST_Y_MIN) && (y_coordinate <= RET_TEST_Y_MAX) ) ) // RET   //CHANGED 12/06/17// 
    {
        state = 3;
    
    }
    else if ( ((x_coordinate >= RETEST_HOME_X_MIN) && (x_coordinate <= RETEST_HOME_X_MAX)) && ( (y_coordinate >= RETEST_HOME_Y_MIN) && (y_coordinate <= RETEST_HOME_Y_MAX) ) ) // RETEST
    {
        if (test_type_retest == BG)
            state = 7;
        else if (test_type_retest == ECG)
            state = 8;
        else if (test_type_retest == BP)
            state = 9;
    }
    else if (x_coordinate == 0 && y_coordinate == 0)
    {
        state = 3;
    }
    else 
        state = 10;                      
    return state;
}




uint8_t touch_bp()   // //determining the touch for bp main screen
{
    
    if ( ((x_coordinate >= START_MAIN_X_MIN) && (x_coordinate <= START_MAIN_X_MAX)) && ( (y_coordinate >= START_MAIN_Y_MIN) && (y_coordinate <= START_MAIN_Y_MAX) ) ) // START
    {
        state = 9;
    }
    
    else if ( ((x_coordinate >= MAIN_X_MIN) && (x_coordinate <= MAIN_X_MAX)) && ( (y_coordinate >= MAIN_Y_MIN) && (y_coordinate <= MAIN_Y_MAX) ) ) // RETURN
    {
        state = 3;
    } 
    else 
        state = 10;
    
    return state;
}
    
    
    
uint8_t touch_glc()        //determining the touch for GLC screen
{
    
    
    if ( ((x_coordinate >= FPS_MAIN_X_MIN) && (x_coordinate <= FPS_MAIN_X_MAX)) && ( (y_coordinate >= FPS_MAIN_Y_MIN) && (y_coordinate <= FPS_MAIN_Y_MAX) ) ) //fasting     // 12/06/17       newly added
    {
        state = 7;
        eprom_write_16(EEPROM_ADDR_GLC_TEST_TYPE,FBS);  
    }
    
    else if ( ((x_coordinate >= PP_MAIN_X_MIN) && (x_coordinate <= PP_MAIN_X_MAX)) && ( (y_coordinate >= PP_MAIN_Y_MIN) && (y_coordinate <= PP_MAIN_Y_MAX) ) ) // pp
    {
        state = 7;
        eprom_write_16(EEPROM_ADDR_GLC_TEST_TYPE,PP);    
    }
    else if ( ((x_coordinate >= RANDOM_MAIN_X_MIN) && (x_coordinate <= RANDOM_MAIN_X_MAX)) && ( (y_coordinate >= RANDOM_MAIN_Y_MIN) && (y_coordinate <= RANDOM_MAIN_Y_MAX) ) ) // random
    {
        state = 7;
        eprom_write_16(EEPROM_ADDR_GLC_TEST_TYPE,RAN); 
    }
    else if ( ((x_coordinate >=BG_RET_MAIN_X_MIN) && (x_coordinate<=BG_RET_MAIN_X_MAX)) && ( (y_coordinate>=BG_RET_MAIN_Y_MIN) && (y_coordinate<=BG_RET_MAIN_Y_MAX) ) ) // return
    {
        state = 3;       
    }
    else 
        state = 10;
    
    return state;
} 
      
 
 
uint8_t touch_again_ecg()    //determining the touch for Repeat test 
{

    
    
    if ( ((x_coordinate >= YES_MAIN_X_MIN) && (x_coordinate <= YES_MAIN_X_MAX)) && ( (y_coordinate >= YES_MAIN_Y_MIN) && (y_coordinate <= YES_MAIN_Y_MAX) ) ) // YES
    {
        state = 8;
    }
    else if ( ((x_coordinate >= NO_MAIN_X_MIN) && (x_coordinate <= NO_MAIN_X_MAX)) && ( (y_coordinate >= NO_MAIN_Y_MIN) && (y_coordinate <= NO_MAIN_Y_MAX) ) ) // NO
    {
        state = 3;
    }
    else 
        state = 10; 
    return state;     
}
 
 
uint8_t touch_again_glc()    //determining the touch for Repeat test 
{

   
    
    if ( ((x_coordinate >= YES_MAIN_X_MIN) && (x_coordinate <= YES_MAIN_X_MAX)) && ( (y_coordinate >= YES_MAIN_Y_MIN) && (y_coordinate <= YES_MAIN_Y_MAX) ) ) // YES
    {
        state = 7;
    }
    else if ( ((x_coordinate >= NO_MAIN_X_MIN) && (x_coordinate <= NO_MAIN_X_MAX)) && ( (y_coordinate >= NO_MAIN_Y_MIN) && (y_coordinate <= NO_MAIN_Y_MAX) ) ) // NO
    {
        state = 3;
    }
    else 
        state = 10; 
    return state;     
}
    
uint8_t touch_again_bp()    //determining the touch for Repeat test 
{
    
    
    if ( ((x_coordinate >= YES_MAIN_X_MIN) && (x_coordinate <= YES_MAIN_X_MAX)) && ( (y_coordinate >= YES_MAIN_Y_MIN) && (y_coordinate <= YES_MAIN_Y_MAX) ) ) // YES
    {
     state = 9;
    }
    else if ( ((x_coordinate >= NO_MAIN_X_MIN) && (x_coordinate <= NO_MAIN_X_MAX)) && ( (y_coordinate >= NO_MAIN_Y_MIN) && (y_coordinate <= NO_MAIN_Y_MAX) ) ) // NO
    {
        state = 3;
    }
    else 
        state = 10; 
    return state;     
} 
 
uint8_t BT_return()   // //determining the touch for bp main screen
{
  
    
    if ( ((x_coordinate >= MAIN_X_MIN) && (x_coordinate <= MAIN_X_MAX)) && ( (y_coordinate >= MAIN_Y_MIN) && (y_coordinate <= MAIN_Y_MAX) ) ) // RETURN
        state = 1;
    else 
        state = 10;
    
    return state;
}

uint8_t touch_debug()
{
   
    
    
    if ( ((x_coordinate >= SD_DEL_X_MIN) && (x_coordinate <= SD_DEL_X_MAX)) && ( (y_coordinate >= SD_DEL_Y_MIN) && (y_coordinate <= SD_DEL_Y_MAX) ) ) 
    {
        state = 14 ; 
    }
    else if ( ((x_coordinate >= SD_READ_X_MIN) && (x_coordinate <= SD_READ_X_MAX)) && ( (y_coordinate >= SD_READ_Y_MIN) && (y_coordinate <= SD_READ_Y_MAX) ) ) 
    {
        state = 15;
    }
    else if ( ((x_coordinate >= Z_X_MIN) && (x_coordinate <= Z_X_MAX)) && ( (y_coordinate >= Z_Y_MIN) && (y_coordinate <= Z_Y_MAX) ) ) 
    {
        //state = ;
    }
    else if ( ((x_coordinate >= DEBUG_BACK_X_MIN) && (x_coordinate <= DEBUG_BACK_X_MAX)) && ( (y_coordinate >= DEBUG_BACK_Y_MIN) && (y_coordinate <= DEBUG_BACK_Y_MAX) ) ) 
    {
        state = 2 ;         
    }
    
    else 
        state = 10;
    
    return state;
    
} 
 

 //TOUCH Functionalities for new display// 
 
uint16_t readTouchY(void)                                                        // read the Y co-ordinate// changed the return type int to uint16_t nikita 
{      
    DigitalOut Y_down(Y_DOWN_PIN);
    DigitalIn X_left(X_LEFT_PIN );
    DigitalOut Y_up(Y_UP_PIN);
    Y_up = 1;
    Y_down = 0;
    AnalogIn X_right(X_RIGHT_PIN);
    X_left.mode(PullNone);
    return X_right.read_u16();
}
    
    
uint16_t readTouchX(void)                                                       // uint16_t// read the X co-ordinate//// changed the return type int to uint16_t nikita
{
    DigitalOut X_right(X_RIGHT_PIN);
    DigitalIn Y_down(Y_DOWN_PIN);
    DigitalOut X_left(X_LEFT_PIN );
    
    X_right = 1;
    X_left = 0;
    AnalogIn Y_up(Y_UP_PIN);
    Y_down.mode(PullNone);
    return Y_up.read_u16();
}

void EnableTouch(void)       // Enable touch 
{
    DigitalIn Y_down(Y_DOWN_PIN);
    DigitalOut X_left(X_LEFT_PIN );
    DigitalIn Y_up(Y_UP_PIN);
    DigitalIn X_right(X_RIGHT_PIN);
    X_left = 0;
    Y_down.mode(PullUp);
    Y_up.mode(PullNone);
    X_right.mode(PullNone);
    touch_detect_flag = true;
    Touch_D.fall(&touch1);
    Touch_D.enable_irq();
}

void DisableTouch (void)    // Disable touch 
{
    Touch_D.disable_irq();
    touch_detect_flag = false;
    DigitalOut Y_down(Y_DOWN_PIN);
    DigitalOut X_left(X_LEFT_PIN );
    DigitalOut Y_up(Y_UP_PIN);
    DigitalOut X_right(X_RIGHT_PIN);
}

uint32_t get_timer()
{
    kc.printf("time=%d",screen_timer.read_ms());
    return  screen_timer.read_ms(); 
}    
 
 
 
void touch_func_with_timer(uint32_t time_ms)
{
    screen_timer.reset();
    while(touch_detect_flag == true)
    {
        screen_timer.start(); 
        if (get_timer()<time_ms)
        {
            if(!Touch_D)                                                  //touch detection 
            {
               touch_detection();
                    }
               }
          else 
             {
                screen_timer.stop();
                screen_timer.reset();
                DisableTouch();
                no_touch();
                break;
               
             }
         
            }
}