// Code Modified with Bluetooth Structure Nidhin 2/6/17
///
#include "mbed.h"
#include "glc.h"
#include "i2c_dec.h"
#include "display_modules.h"
#include "rtc.h"
#include "sdcard.h"
#include "eeprom_pgm.h"  
#include "main.h"
#include "struct.h" 

#define TEST_STRIP_PIN              PTA12
#define ADC_PIN_1                   PTC1
#define ADC_PIN_2                   PTE29
#define DAC_PIN                     PTE30

#define GLC_LENGTH_IN_BYTES         30
#define GLC_SAMPLES                 2
#define EEPROM_ADDR_GLC_TST_TYP     20

#define THRESHOLD                   9000
#define SAMPLE_TIME                 8
#define COMPUTE_TIME                2250
#define VREF                        3.3
#define TOTAL                       65535
#define NUMB1                       929.3
#define NUMB2                       381.5
#define ALPHA                       0.99
#define BETA                        0.01

#define MAX_GLC_THRESHOLD           600
#define MIN_GLC_THRESHOLD           10

DigitalIn test_strip(TEST_STRIP_PIN);
AnalogIn Ain(ADC_PIN_1);                                                        //Electrode one
AnalogIn Ain2(ADC_PIN_2 );                                                      // Electrode two
AnalogOut DAC_signal(DAC_PIN);
Serial gtc(USBTX, USBRX);
Ticker flipper;
Ticker flipper1;


void sample();
void Compute();
void i2c_spec();


bool GLC_START = false;                                                         //changed from uint16_t to bool nikita
static uint16_t mgdl = 0;
//static uint16_t mgdll = 0;                                                    //commented nikita
uint16_t  daata1= 0;
uint16_t  data2 = 0;

uint16_t  data1n = 0;                                                           //changed the static to nonstatic nikita
uint16_t  data2n = 0;
uint16_t  datafinal1 = 0;
uint16_t  datafinal2 = 0;
bool err = false;                                                               //changed from uint16_t to bool nikita

uint32_t glcraw[2] = {0};
uint8_t chk_glc_data = 0;
uint16_t glc_testtype = 0;

void sample()
{
    data1n = Ain.read_u16();
    data2n = Ain2.read_u16();
    daata1 = BETA * daata1 + ALPHA * data1n;
    data2 = BETA * data2 + ALPHA * data2n;
    
    if( ((daata1 - data2) >= (data2/10) && (daata1 > data2)) || ((data2 - daata1) >= (data2 / 10) && (data2 > daata1)) )
    {
        err = true;     
    }
    else
    {
        err = false;
    //gtc.printf("\n", data1n, data2n); 
    }
     
}

void Compute()
{
   
   flipper.detach();                                                            // ticker for sampling is disabled
   datafinal1 = (uint16_t ) NUMB1 * (data2 * VREF / (TOTAL))- NUMB2;
   datafinal2 = (uint16_t ) NUMB1 * (daata1 * VREF / (TOTAL)) - NUMB2;
   mgdl = (uint16_t) NUMB1 * (((daata1 + data2) / 2) * VREF / (TOTAL)) - NUMB2;  
   GLC_START = false;
   flipper1.detach();                                                           // ticker for computation is disabled
}


void  glc(uint32_t pid)
{
   
    bool t_s_d = false;                                                         // changed to bool nikita
    uint8_t err_no_teststip = 0; 
    i2c_spec();                                                                 // programming the i2c expander 
    sd_open_GLCfilee(pid);                                                      
    
    // Bluetooth Structure created globally
    BLEMsg_info *ptr_BLEMsg_info_glc, BLEMsg_info_glc;                          // A copy of master strcuture [ "BLEMsg_info" ] by name "BLEMsg_info_bp" is created
    ptr_BLEMsg_info_glc = &BLEMsg_info_glc;                                     // *ptr_BLEMsg_info_bp is the pointer to local copy;
                                               
    
    // Declaration of Date Structure
    DateTime_info DateTime_info_glc;                                            // A copy of Master Structure "DateTime_info" created, //commented pointer nikita
   // ptr_DateTime_info_glc = &DateTime_info_glc;                                 // Structure pointer points to that copy.
    
    
      
    // RTC operations
    time_t epoch_time_glc;                                                      //A copy of time_t by name  epoch_time_bp is created 
    epoch_time_glc = rtc_read();                                                // time is got from get epoch function.  
    
    struct tm * ptr_time_info_glc;                                              // Sturucture copy of tm is created//commented nikita  time_info_glc;   
    ptr_time_info_glc = localtime(&epoch_time_glc);                             // Structure accepts the time in local format from "time_t" type.
    /*  
    //BELOW LINE IS TO CHECK Date and TIME 
    gtc.printf("Time is - %d:%d:%d\n", (*ptr_time_info_glc).tm_hour, (*ptr_time_info_glc).tm_min, (*ptr_time_info_glc).tm_sec);
    gtc.printf("Date is - %d:%d:%d\n", (*ptr_time_info_glc).tm_mday, (*ptr_time_info_glc).tm_mon+1, (*ptr_time_info_glc).tm_year-100);
    */
    //Copying from one structure to the other using variables
    DateTime_info_glc.hour = (uint8_t)(*ptr_time_info_glc).tm_hour;
    DateTime_info_glc.mins = (uint8_t)(*ptr_time_info_glc).tm_min;
    DateTime_info_glc.sec =  (uint8_t)(*ptr_time_info_glc).tm_sec;
    
    DateTime_info_glc.date = (uint8_t) (*ptr_time_info_glc).tm_mday;
    DateTime_info_glc.month =(uint8_t)(*ptr_time_info_glc).tm_mon+1;
    DateTime_info_glc.year = (uint8_t)(*ptr_time_info_glc).tm_year-100;
    
    // Copying Time to Main structure
    BLEMsg_info_glc.date_time.hour = DateTime_info_glc.hour;
    BLEMsg_info_glc.date_time.mins = DateTime_info_glc.mins;
    BLEMsg_info_glc.date_time.sec = DateTime_info_glc.sec;
    
    BLEMsg_info_glc.date_time.date = DateTime_info_glc.date ;
    BLEMsg_info_glc.date_time.month = DateTime_info_glc.month ;
    BLEMsg_info_glc.date_time.year =  DateTime_info_glc.year ;
    
    /*
    //Checking if the structure has these values    
    gtc.printf("\nTime 2 is - %d:%d:%d\n", DateTime_info_glc.hour, DateTime_info_glc.mins, DateTime_info_glc.sec);
    gtc.printf("\nDate 2 is - %d:%d:%d\n",DateTime_info_glc.date, DateTime_info_glc.month, DateTime_info_glc.year);
    */
    
    //Loading values to of Test type
    test_type_info test_type_info_glc;                                          // copy of " test_type_info" created  
    test_type_info_glc = BG_Test;                                               // Loaded value 01 to the test type 
    
    BLEMsg_info_glc.test_type = test_type_info_glc;
   
    gtc.printf("\nTest Type for BG = %d\n", test_type_info_glc);
    
    
    // Loading values of Length ,  PID, DID, sampling frequency, number of samples, calculated data.
    BLEMsg_info_glc.device_id = get_did();                     // Device ID fixed  // change on 11/8/17 nikita
    gtc.printf("device id read ecg = %d\n", BLEMsg_info_glc.device_id);
    BLEMsg_info_glc.patient_id = (uint16_t)pid;      // Patient ID
    BLEMsg_info_glc.sampling_freq = 0;              // sampling frrquency
    BLEMsg_info_glc.length = GLC_LENGTH_IN_BYTES;                   //Total length of data in bytes  22 B+10752 B
    
    BLEMsg_info_glc.num_samples.num_sample_ecg_OTtyp = GLC_SAMPLES ;
    BLEMsg_info_glc.num_samples.num_sample_ppg_dummy =  0;
       
     
            
    GLC_START = true;
    
    if(GLC_START == true)
    {
        glc_1();                                                                // displaying messages to insert the test strip
        err = false;
        data1n = 0;
        data2n = 0;
        daata1 = 0;
        data2 = 0;

        while((test_strip));
    
        if (!test_strip)                                                        // checks for the presence of test strip
        { 
            flipper.attach(&sample, 0.8);    
            t_s_d = false;
            glc_2();                                                            // displaying message to insert blood
             
            while((t_s_d == false) && (!test_strip))
            {
                                
                if ((daata1 >= THRESHOLD) || (data2 >= THRESHOLD)) 
                { 
                    t_s_d = true;
                    flipper1.attach(&Compute, 2.25);                            //computing the glucose level
                    glc_3();
                }
                else
                {
                                                                                //wait for insertion of blood;
                }
            }
            if(test_strip)     
            {
                err_no_teststip = 1;
            }   
            wait_ms(800);          
        }
                    
        //gtc.printf("mgdl is - %d\n", mgdll);
    } 
    wait(2.25);
    //gtc.printf("error = %d\n", err);   
    if ((err==false) && (err_no_teststip == 0) && ( mgdl < MAX_GLC_THRESHOLD) && ( mgdl > MIN_GLC_THRESHOLD))
    {     
        glc_4(mgdl);
        //gtc.printf("DATA1 is - %d\n", data1n); 
        //gtc.printf("DATA2 is - %d\n", data2n);  
        //gtc.printf("mgdl is - %d\n", mgdl);   
        
        glcraw[0] = (uint32_t)data1n;
        glcraw[1] = (uint32_t)data2n;
        
        sd_glcwrite(glcraw, pid);                                               //Writes the raw data into GLC file 
 
        //Results Stored to Bluetooth structure
        glc_testtype = eprom_read_16(EEPROM_ADDR_GLC_TST_TYP);                  // Reads the test type (before meal = 0 / after meal = 1 OR Random = 2 from location 2 of the EEPROM) Nidhin 12/6/17
        BLEMsg_info_glc.cal_data.cal_sbp_dummy = (uint16_t) glc_testtype;       // Data stored into structure
        BLEMsg_info_glc.cal_data.cal_dbp_OTtyp = (uint16_t) mgdl;               //To be checked for reliable results           
        
        structure_file(ptr_BLEMsg_info_glc, pid);                               // Copy the structure into the GLC file 
        glcfile_mainfile(pid);
        if(get_filecreated_status() == false)                                   //if file is in write mode 
        {   
            set_filecreated_status();                    
            increment_filepid (); 
        }    
    }
    else                                                                        // added threshold to check value out of range   
    {  
        if(err_no_teststip == 1)                                                // to separately detect what is the parameter failed while testing 
        {
            glc_error_test_strip_removed();
        }
        
        else if(err == true || mgdl > MAX_GLC_THRESHOLD || mgdl < MIN_GLC_THRESHOLD)
        {   
            //gtc.printf("replace teststip"); 
            glc_error();                                                        //disaply for showing error
        }
            
        delete_subfiles(pid); 
    }  


}