/** ECG ADS1291 Test program.
ADS1291 is a single channel ECG chip
with a 24 bit Sigma-Delta ADC
 */
 
#include "mbed.h"
#include <string.h>
#include <stdio.h>
#include "ds3231.h"
#include "SDFileSystem.h"
#include "ecg_dec.h"
#include "rtc.h"
#include "sdcard.h"
#include "ec_bp.h"
#include "eeprom_pgm.h"
#include "struct.h" 
#include "main.h"


#define ECG_LENGTH_IN_BYTES         8022
#define R_FALL_DIFF                 4000
#define SKIP_SAMPLES                120
#define SKIP_SAMPLES_PTR            480
#define SAMPLE_PTR                  4
#define SAMPL_10_OFFSET             28
#define SECONDS_60                  60

#define MAX_HR_THRESHOLD            205
#define MIN_HR_THRESHOLD            25

void low_pass_filter(uint32_t pid);
void swap(uint32_t *ptr);
Serial pc(USBTX,USBRX);
char buffer[32] = {0};                                                          //buffer declared as file scope nikita        

uint16_t ecg(uint32_t pid) 
{
    FILE *fpeecg1;
    //pc.baud(SERIAL_BAUD_RATE);
    uint8_t lead_reg=0;                                                         //to check lead -off   
    uint32_t concatenate_value2 = 0;     
    uint16_t count = 0; 
    uint32_t *ecg_ptr;                   
    ecg_ptr = &concatenate_value2;                                              // Pointer to pass for ECG write into SD card 
    
    /********** Declaration for Peak value detection ***************/

    int32_t ecg_samp1[1] = {0};                                                    
    int32_t ecg_samp2[1] = {0};                                                       
    int32_t ecg_samp3[1] = {0};                                                 // to Stores sample 1, 2 & 10th sample 
    
    int32_t pk_val[20] = {0};                                                        
    uint16_t pk_pos[20] = {0};                                                  // Variable to hold pointer positio
    int32_t hi_val = 0;                                                      
    
    int32_t hi_dif = 0;                                                         //diff between high value and it's consecutive value
    uint8_t peak_count = 0;                                                     // int count1 = N_ECG/fs, a_dif=0, fs1 = fs ,h=0;
    uint32_t peak_detect_offset = 400; 
  
    // ------------------------- Declaration for Heart Rate calculation --------------------------
    uint8_t no_of_peaks = 0;
    uint16_t pos_dif = 0.0;                                                            
    float HR[10] = {0.0};
    //float HR1 = 0.0;                                                          //commented as not in  use nikita
    float t_pos_dif = 0.0;
    float HR_sum = 0.0;
    float HR_avg = 0.0;
    
    //----------------------- Structure for Bluetooth  Added Nidhin 1/6/2017-------------------//
    
    //BLUETOOTH STRUCTURE
    
    BLEMsg_info *ptr_BLEMsg_info_ecg, BLEMsg_info_ecg;                          // A copy of master strcuture [ "BLEMsg_info" ] by name "BLEMsg_info_ecg" is created
    ptr_BLEMsg_info_ecg = &BLEMsg_info_ecg;                                     // *ptr_BLEMsg_info_bp is the pointer to local copy;
    
    // Declaration of Date Structure
    DateTime_info DateTime_info_ecg;                                            // A copy of Master Structure "DateTime_info" created,    
    
    // RTC operations
    time_t epoch_time_ecg;                                                      //A copy of time_t by name  epoch_time_bp is created 
    epoch_time_ecg = rtc_read();                                                // time is got from get epoch function.  
    
    struct tm * ptr_time_info_ecg;                                              // Sturucture copy of tm is created
    ptr_time_info_ecg = localtime(&epoch_time_ecg);                             // Structure accepts the time in local format from "time_t" type.

    
    //Copying from one structure to the other using variables
    DateTime_info_ecg.hour = (uint8_t)(*ptr_time_info_ecg).tm_hour;
    DateTime_info_ecg.mins = (uint8_t)(*ptr_time_info_ecg).tm_min;
    DateTime_info_ecg.sec =  (uint8_t)(*ptr_time_info_ecg).tm_sec;
    
    DateTime_info_ecg.date = (uint8_t) (*ptr_time_info_ecg).tm_mday;
    DateTime_info_ecg.month =(uint8_t)(*ptr_time_info_ecg).tm_mon+1;
    DateTime_info_ecg.year = (uint8_t)(*ptr_time_info_ecg).tm_year-100;
    
    // Copying Time to Main structure
    BLEMsg_info_ecg.date_time.hour = DateTime_info_ecg.hour;
    BLEMsg_info_ecg.date_time.mins = DateTime_info_ecg.mins;
    BLEMsg_info_ecg.date_time.sec = DateTime_info_ecg.sec;
    
    BLEMsg_info_ecg.date_time.date = DateTime_info_ecg.date ;
    BLEMsg_info_ecg.date_time.month = DateTime_info_ecg.month ;
    BLEMsg_info_ecg.date_time.year =  DateTime_info_ecg.year ;
    
    
    //Checking if the structure has these values    
    //pc.printf("Time 2 is %d:%d:%d\n", DateTime_info_ecg.hour, DateTime_info_ecg.mins, DateTime_info_ecg.sec);
    //pc.printf("\t Date is %d:%d:%d\n",DateTime_info_ecg.date, DateTime_info_ecg.month, DateTime_info_ecg.year);
    
    
    //Loading values to of Test type
    test_type_info test_type_info_ecg;                                          // copy of " test_type_info" created  
    test_type_info_ecg = ECG_Test;                                              // Loaded value 02 to the test type 
    
    BLEMsg_info_ecg.test_type = test_type_info_ecg;
   
    pc.printf("Test Type is : %d\n", test_type_info_ecg);
    
    
    // Loading values of Length ,  PID, DID, sampling frequency, number of samples, calculated data.
    BLEMsg_info_ecg.device_id =  get_did();                                     // Device ID fixed // reading the device id // 
    pc.printf("device id read ecg = %d\n", BLEMsg_info_ecg.device_id); 
    BLEMsg_info_ecg.patient_id = pid;                                 // Patient ID
    BLEMsg_info_ecg.sampling_freq = ECG_SAMPLING_FREQUENCY;                                        // sampling frrquency
    BLEMsg_info_ecg.length = ECG_LENGTH_IN_BYTES;                                              //Total length of data in bytes  22 B+ 4000 data
    

    BLEMsg_info_ecg.num_samples.num_sample_ppg_dummy =  0 ;// PPG  number of samples copied to master struct 
    BLEMsg_info_ecg.num_samples.num_sample_ecg_OTtyp =  N_ECG ; // ECG  number of samples copied to master struct
    
    //----------------------------------------END Structure for Bluetooth - Added Nidhin 1/6/2017-------

    freqset();                                                                  // setting the frequency
    setupfunc();
    lead_reg = ecgsetupfunc();
    

    if (lead_reg == LEADS_DETECTED)
    {                                                                           // checking for proper lead contact
    
        sd_open_ECGfilee(pid);                                                  //open temporary ecg.csv file to write 2000 samples of data
        pc.printf( "Raw data is = \n");
        
        for(uint16_t i=0; i < N_ECG; i++)                                       // changed from int to uint16_t nikita 
        {
            concatenate_value2 = readvalue();
            pc.printf( "%d\n", concatenate_value2);                            
            
            sd_ecgwrite(ecg_ptr);                                               //writing data to temporary file ECG.csv
        }
        sd_close_ecg();                                                         // closing the ECG file REPLACED Nidhin 1/6/2017 Nidhin
        low_pass_filter(pid);                                                   // low pass filter calculation function
        
    
 //----------------------------- PEAK DETECTION AND HEART RATE CALCULATION ---------------------------------------------------
 
                                                                                // PEAK DETECTION 
     sprintf(buffer, "/sd/%d_ECG_lpf.csv", pid);                               // For opening a specific file    
     fpeecg1 = fopen(buffer, "r");
     
    for(uint16_t i = 100;i<((N_ECG-4)-10);i++)
    {
        count++;
        rewind(fpeecg1);                                                        // Go to start of file each time
        fseek(fpeecg1, peak_detect_offset, SEEK_CUR);                           // Update the count value according to move pointer //// after every calc. the pointer moves to 0th position, as we have used fseek, hence to make it jump to the respective position by "m" bytes this command is used
        fread(ecg_samp1, sizeof(int32_t), 1, fpeecg1);                          // Read sample 1
        fread(ecg_samp2, sizeof(int32_t), 1, fpeecg1);                          // Read Sample 2
        fseek(fpeecg1, SAMPL_10_OFFSET, SEEK_CUR);                              // Moving to tenth sample
        fread(ecg_samp3, sizeof(int32_t), 1, fpeecg1);                          // Read 3rd sample
    
        if(ecg_samp1[0]>ecg_samp2[0])
        {
            hi_val = ecg_samp1[0];                                              //To find the high value
            hi_dif = hi_val-ecg_samp3[0];
    
                                                                                // If hi_val is greater than next ten input values, then compare the hi_val with the tenth input value. 
                                                                                // If the diff is greater than 4000, then it is a valid peak (pls chk the below condition)
            if(hi_dif > R_FALL_DIFF)
            {
                 pk_val[peak_count] = hi_val;                                   //if condition satisfied, put the "pk" value into "pk_val" buffer
                 pc.printf("peak value= %d\n",pk_val[peak_count]);
                 pk_pos[peak_count]=i; // also save the peak's position
                 pc.printf("peak position is = %d\n",pk_pos[peak_count]);
                 i = i+ SKIP_SAMPLES;                                           // once confirmed that this is the necessary peak, skip the next 120 input values
                 no_of_peaks = peak_count;                                      // where n is the number of peaks detected
                 peak_count = peak_count+1;
                 peak_detect_offset = peak_detect_offset + SKIP_SAMPLES_PTR;    //similar reason to considering 28, but to skip 120 samples. this cond. is satisfied only when we hit a peak - suhasini_26thjune17
            }
         
            else
            {
                peak_detect_offset = peak_detect_offset+SAMPLE_PTR;             // this is when we do not hit a peak and have to continue searching thru, hence move to the next sample and not skip 120 samples- - suhasini_26thjune17
            }
        }
        else
        {
            peak_detect_offset = peak_detect_offset + SAMPLE_PTR;
        }
    //pc.printf("i=%d",i);
    }
    no_of_peaks = no_of_peaks +1;
    pc.printf("no_of_peaks=%d\n",no_of_peaks);
    
    pc.printf("to enter HR loop\n");
                                                                                //  HEART RATE LOGIC --------------------------- 
     for(uint16_t i = 0;i < no_of_peaks-1;i++)
     {
          pos_dif = pk_pos[i+1] - pk_pos[i];                                    // difference between two consequtive peaks
          pc.printf("peak position diff is = %d\n",pos_dif);
          t_pos_dif = (float)pos_dif/ECG_SAMPLING_FREQUENCY;                           // sample difference between peak positions divided by sampling frequency gives the difference value in terms of actual time
          pc.printf("time in seconds is = %f\n",t_pos_dif);
          HR[i] = SECONDS_60/t_pos_dif;                                         //HR calculation
          pc.printf("Heart Rate is = %f\n",HR[i]);
         // HR1 = HR[0];
     }
                                                                                //To average individual HRs for higher number of samples -----------------------
     for(uint16_t i = 0;i < no_of_peaks-1;i++)
     {
        HR_sum = HR[i] + HR_sum; 
     }
     HR_avg = (HR_sum / (no_of_peaks-1));                                       // To find average of all the individual HRs calculated
     printf("Heart Rate sum is = %f\n",HR_sum);
     printf("Heart Rate avg is = %f\n",HR_avg);
     
     fclose(fpeecg1);
     pc.printf("temporary file closed\n"); 
 
    if(HR_avg > MAX_HR_THRESHOLD || HR_avg < MIN_HR_THRESHOLD) 
    {
        delete_subfiles(pid);   
        return 1;                                                               // out of range condition returning 1 
    }
    else 
    {
        BLEMsg_info_ecg.cal_data.cal_sbp_dummy = 0;
        BLEMsg_info_ecg.cal_data.cal_dbp_OTtyp = HR_avg;                        //To be modified after HR code is added. 
        
        structure_file(ptr_BLEMsg_info_ecg, pid);                               //copy the ECG structure to Main file 
        ecgfile_mainfile(pid);                                                  // copy raw data to the main file and ECG file is cleared.
        if(get_filecreated_status() == false)                                   //if file is in write mode 
        {   
            set_filecreated_status();                    
            increment_filepid (); 
        } 
        pc.printf("Closed the main file\n");
        return HR_avg; 
    }
    }          
    else 
    {
        pc.printf("improper lead connection");
        return 0;
    } 
//    pc.printf("closing temporary file\n");
    
}   // End of main function

/************************* LOW PASS FILTER FUNCTION **************************/

void low_pass_filter(uint32_t pid)
{
    FILE *fpecg1;                                                               // FILE pointer to read raw data ECG file  added by Suhasini 5-8-17
    FILE *fpeecg_lpf;                                                           // FILE pointer to read and write into LPF output file   added by Suhasini 5-8-17
    uint32_t ecg_raw[5] = {0} ;                                                 // Buff of 5 samples created to Stores input samples for LPF  added by Suhasini - 5-8-17
    uint32_t lpf_op[5] = {0};                                                   // for LPF output   added by Suhasini - 5-8-17 // changed from double to int32_t- 16-8-17

   // uint32_t lpf_4samp = 0;                                                   // Variable to move 16 samples back from current in input file - changed by Suhasini- 5-8-17
    //char buffer3[32];
   // char buffer4[32];                                                           // Added by Suhasini - 5-8-17
    const float b[5]= {0.0000624,0.0002495,0.0003743,0.0002495,0.0000624};      //Numerator co-efficients of low-pass butter-worth filter of order=4
    const float a[5]= {1.0000,-3.5078,4.6409,-2.7427,0.6105};                   //Denominator co-efficients of low-pass butter-worth filter of order=4



    sprintf(buffer, "/sd/%d_ECG.csv", pid);                                    // opening raw data file to read
    fpecg1 = fopen(buffer, "r");                                               // to read data from the above opened temp file
    pc.printf("entered raw data file\n");
    
    sprintf(buffer, "/sd/%d_ECG_lpf.csv", pid);                                // opening empty file to write lpf data
    fpeecg_lpf = fopen(buffer, "a");                                           // to read data from and write data into the above opened file // changed from "a+" to "a"
    pc.printf("entered LPF data file\n");
    
    fwrite(&lpf_op, sizeof(int32_t), 4, fpeecg_lpf);
    pc.printf("first 4 LPF data %d\n %d\n %d\n %d\n", lpf_op[0],lpf_op[1],lpf_op[2],lpf_op[3]);

    pc.printf("low pass filter output is= %d\n",lpf_op[4]);                     //message to display LPF output
    
    fread(&ecg_raw, sizeof(uint32_t), 5, fpecg1);
   // pc.printf("first 4 RAW data %d\n %d\n %d\n %d\n %d\n", ecg_raw[0],ecg_raw[1],ecg_raw[2],ecg_raw[3],ecg_raw[4]);

    for (uint16_t i = 1; i <= (N_ECG-4); i++)                                   // reduced loop length to check i/p and o/p timing
    {                                 
    
        (lpf_op[4]) = (int32_t)(b[0]*((ecg_raw[4]))) + (int32_t)(b[1]*((ecg_raw[3]))) + (int32_t)(b[2]*((ecg_raw[2]))) + (int32_t)(b[3]*((ecg_raw[1]))) + (int32_t)(b[4]*((ecg_raw[0]))) - (int32_t)(a[1]*lpf_op[3]) - (int32_t)(a[2]*lpf_op[2]) - (int32_t)(a[3]*lpf_op[1]) - (int32_t)(a[4]*lpf_op[0]);
        
        fwrite(&lpf_op[4], sizeof(int32_t), 1, fpeecg_lpf);
        
        //pc.printf("pointer to output value is= %ld\n",ftell(fpeecg_lpf));
        pc.printf("%d\n",lpf_op[4]);                                            // to print LPF output on hyperterminal
        swap(lpf_op);
        swap(ecg_raw);                                                          // 8 changed to 4, because datatype has been changed from double to int32_t- suhasini- 16/8/17  /// commented by nikita 5/09/17 // not used anywhere//
        fread(&ecg_raw[4], sizeof(uint32_t), 1, fpecg1);
        //pc.printf("5th samples: %d\n",ecg_raw[4]);
        
    }

    fclose(fpecg1);
    fclose(fpeecg_lpf);
    pc.printf("temporary file closed after LPF\n");

}

void swap(uint32_t *ptr)
{
    uint8_t i;
    for(i=0;i<4;i++)
        ptr[i] = ptr[i+1];   
}