#ifndef EC_BP_H_
#define EC_BP_H_

#define PIN_MOSI        PTA16
#define PIN_MISO        PTA17 
#define PIN_SCLK        PTD1 
#define MA4_SIZE        4 // DO NOT CHANGE

#define CMD_WAKEUP      0x02
#define CMD_STANDBY     0x04
#define CMD_RESET       0x06
#define CMD_START       0x08
#define CMD_STOP        0x0A
#define CMD_OFFSET_CAL  0x1A
#define CMD_RDATAC      0x10
#define CMD_SDATAC      0x11
#define CMD_RDATA       0x12
#define CMD_WREG        0x02
#define CMD_RREG        0x01

//SPI registers addresses, 5 bits width
#define REG_ID          0x00
#define REG_CONFIG1     0x01
#define REG_CONFIG2     0x02
#define REG_LOFF        0x03
#define REG_CH1SET      0x04
#define REG_CH2SET      0x05
#define REG_RLD_SENS    0x06
#define REG_LOFF_SENS   0x07
#define REG_LOFF_STAT   0x08
#define REG_MISC1       0x09
#define REG_MISC2       0x0A
#define REG_GIPO        0x0B

//Register bit configurations in ADS1291

#define SPS500          0x02                                                    //SPS500 - 500 Samples Per Second mode, CONFIG1 REG bits 010 
#define sps125          0x00                                                    //CONFIG1 REG bits 000 //Ask sir
#define sps1k           0x03                                                    //CONFIG1 REG bits 011 //Ask sir
#define NO_MODE         0xA8                                                    //CONFIG2 REG set to zero for device check
#define TEST_MODE       0xA3                                                    //CONFIG2 REG bits set to test mode, to generate a square wave
#define DEFAULT_MODE    0xE0                                                    //CONFIG2 REG bits set to default mode, to generate ECG signal from an external input
#define LEAD_OFF_CONFG  0xF0                                                    //LOFF register bits set to F0 to configure LOFF reg for leadoff detection
#define OFFSET_MEASURE  0x01                                                    //CH1SET REG set to Gain = 6 and offset measurement
#define TEST_INPUT      0x05                                                    //CH1SET REG set to Gain = 6 and generate test signal
#define ELECTRODE_INPUT 0x00                                                    //CH1SET REG set to Gain = 6 and take in electrode input
#define RLD_SENSE_SIG   0x23                                                    //Right Leg Drive Sense Signal
#define LOFF_SENSE_SIG  0x03                                                    //Lead-OFF Sense Signal 
#define MISC1_INPUT     0x02
#define MISC2_INPUT     0x03

#define LSHIFT_8        8    //left shift the obtained 8bit data by 8 values
#define LSHIFT_16       16  ////left shift the obtained 8bit data by 16 values
#define N_ERR           100
#define N_TEST          500
#define N_ECG           2000


//SPI SETTINGS

#define ECG_SPI_FREQUENCY   1000000
#define ECG_SPI_BITS            8 
#define ECG_SPI_MODE            1 
#define ECG_SPI_LOOP            1000000 

//PPG DECLARATION
#define MAX_BRIGHTNESS  255 // BP ADD

//ECG AND PPG SETTINGS

#define ECG_SAMPLING_FREQUENCY              500                                 
#define LEADS_DETECTED                      0

typedef void (*func_ptr)(void) ; /*creates typedef to function pointer, does not take any arguement and returns void*/

void doHelp(void) ;
void doStatus(void) ;
void doFreq(void) ;
void doMode(void) ;
void doBit(void) ;
void doWrite(void) ;
void doWrite2(void) ;
void doRead(void) ;
void doLoop(void) ;
void setup(void);
void testsetup(void);
void ecgsetup();
void regWrite(uint8_t,uint8_t);
void cmdWrite(uint8_t);
void regRead(uint8_t);
void freqset();
void ecgtestsetupfunc();

void setupfunc();
uint8_t ecgsetupfunc();
uint32_t readvalue();

#endif