#include "mbed.h"
#include "display_modules.h"
#include "touch_modules.h"
#include "rtc.h"
#include "main.h"
#include "ILI9341.h"
#include "Arial12x12.h"
#include "Arial24x23.h"


#define LCD_CS          PTB0
#define LCD_RST         PTB9
#define LCD_DC          PTC0
#define LCD_WR          PTB8
#define LCD_RD          PTE31

#define DATA_PIN1       PTD2
#define DATA_PIN2       PTC13
#define DATA_PIN3       PTB10
#define DATA_PIN4       PTC9
#define DATA_PIN5       PTD4
#define DATA_PIN6       PTD5
#define DATA_PIN7       PTD6
#define DATA_PIN8       PTD7


PinName buspins[8]={DATA_PIN1, DATA_PIN2, DATA_PIN3, DATA_PIN4, DATA_PIN5, DATA_PIN6, DATA_PIN7, DATA_PIN8 };          //new_display ili9341 
ILI9341 TFT(BUS_8, buspins, LCD_CS, LCD_RST, LCD_DC, LCD_WR, LCD_RD,"SPFD5408_2.4") ;
DigitalOut backlight(DATA_PIN4) ;

void init_screen()                                                              // initializing the screen
{                                                                               //Configure the display driver    
    TFT.FastWindow(true) ;
    TFT.background(Black);
    TFT.foreground(White);
    wait(0.01) ;
    TFT.cls();
}

void screen_main()                                                              //main screen
{
    char buffer[32] = {0};
    time_t epoch_time;
    epoch_time=rtc_read();                                                      // read the time from rtc module
    strftime(buffer, 32, "%d-%m-%Y           %H:%M",localtime(&epoch_time));
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.cls() ;
    wait(0.1) ;
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.foreground(Red);
    TFT.locate(20,100) ;
    TFT.printf(buffer);
    TFT.set_font((unsigned char*) Arial24x23);  
    TFT.foreground(Black);
    TFT.locate(35,30) ;
    TFT.printf("SENSESEMI") ;
    TFT.locate(45,60) ;
    TFT.printf("Sense POC") ;
    TFT.background(Olive) ;
    TFT.fillrect( 60,130,180,200,Olive);
    TFT.locate(100,140) ;
    TFT.printf("SYS") ;    
    TFT.locate(65,170) ;
    TFT.printf("CONFIG") ;    
    TFT.fillrect( 60,230,180,300,Olive);
    TFT.locate(88,252) ;                
    TFT.printf("TEST") ;          
    TFT.BusEnable(false) ;
    backlight = 1 ;
}
     
    
    
void screen_main_2(int32_t pid)                                                 // test main screen
{
    char buffer[10] = {0};     
    backlight = 0 ;
    
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    sprintf(buffer ,"%d", pid);
    TFT.fillrect(5,20,250,150,White ); 
    TFT.fillrect(5,20,250,250,White );              
    TFT.fillrect(60,130,180,200,White );  
    TFT.fillrect(60,230,180,300,White );      
    TFT.fillrect(5,230,240,320,White );      
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.foreground(Black);
    TFT.locate(10,50) ;
    TFT.printf("PATIENTID") ;
    TFT.locate(180,50) ;
    TFT.printf(buffer) ;
    TFT.background(Orange) ;
    TFT.foreground(Black);
    TFT.fillrect( 10,130,100,200,Orange);
    TFT.locate(40,160) ;
    TFT.printf("BG") ;      
    TFT.fillrect( 130,130,220,200,Orange);
    TFT.locate(145,160) ;
    TFT.printf("ECG") ;    
    TFT.fillrect( 10,215,100,285,Orange);
    TFT.locate(40,245) ;        
    TFT.printf("BP") ;    
    TFT.fillrect(130,215,220,285,Orange);
    TFT.locate(130,245) ;        
    TFT.printf("HOME") ;    
    TFT.BusEnable(false) ;
    backlight = 1 ;
}         
                         
void screen_main_1()                                                            // System Configuration main screen
{
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(GreenYellow) ;
    TFT.fillrect(5,127,230,320,White );  
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.foreground(Black);
    TFT.fillrect( 10,130,100,200,GreenYellow);
    TFT.locate(38,160) ;                                                             
    TFT.printf("BT") ; 
    TFT.fillrect( 130,130,220,200,GreenYellow); 
    TFT.locate(140,160) ;                             
    TFT.printf("P-Inf") ; 
    TFT.fillrect( 10,215,100,285,GreenYellow);
    TFT.locate(10,245) ;                                         
    TFT.printf("HOME") ;   
    
    if ((read_debug_status()== true) && get_timer_debug()<TIMER_ENABLE_DEBUG_MODE)     // checking for the debug status and timer 
    {
         TFT.fillrect(130,215,220,285,GreenYellow);
        TFT.locate(150,230) ;        
        TFT.printf("DE-") ; 
        TFT.locate(145,260) ;        
        TFT.printf("BUG") ;                                                        
    }    
   
    TFT.BusEnable(false) ;
    backlight = 1 ;
 }                  
       
                
void screen_ecg()                                                               //ECG screen 1
{
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.fillrect(10,130,100,200,White);
    TFT.fillrect(130,130,220,200,White);
    TFT.fillrect(130,215,220,285,White);
    TFT.fillrect(10,215,100,285,White);
    TFT.fillrect(60,130,180,200,White);
    TFT.fillrect(5,5,115,20,White);
    TFT.background(Green) ;
    TFT.foreground(Black) ;  
    TFT.fillrect( 60,130,180,200,Green);
    TFT.locate(80,150) ;
    TFT.printf("START") ;    
    TFT.fillrect( 60,230,180,300,Green);
    TFT.locate(85,250) ;        
    TFT.printf("MAIN") ;          
    TFT.BusEnable(false) ;
    backlight = 1 ;       
} 
      
      
                
void screen_ecg_2(uint16_t heart_rate)                                          // ECG screen 2
{
    char buf[5] = {0};
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Green) ;
    sprintf (buf, "%d bpm",heart_rate);
    TFT.fillrect(5,90,230,150,White);  
    TFT.locate(3,100) ;  
    TFT.printf(" ECG Tst Done  ") ;   
    TFT.locate(3,150) ;  
    TFT.printf("   HeartRate   ") ;        
    TFT.locate(50,180);                             
    TFT.printf(buf) ; 
    TFT.set_font((unsigned char*) Arial12x12);   
    TFT.locate(5,291) ; 
    TFT.foreground(Navy) ;
    TFT.printf("Study Readings: Not for medical") ;          
    TFT.locate(35,300) ;
    TFT.printf("diagnosis and treatment") ;
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.BusEnable(false) ;
    backlight = 1 ;
}
    
void screen_ecg_lead()                                                          // ECG screen for displaying no lead proper lead contact
{
     backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Red) ;
    TFT.fillrect(5,90,230,200,White);
    TFT.locate(50,100) ;  
    TFT.printf("Re-check") ;   
    TFT.locate(3,130) ;  
    TFT.printf("Lead Connection") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ;
}
 
 
void screen_ecg_lead_bp_fingerdetect()                                          // ECG screen for displaying no lead proper lead contact
{
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Red) ;
    TFT.fillrect(5,90,230,200,White);    
    TFT.locate(20,100) ;  
    TFT.printf("Re-check Leads") ;   
    TFT.locate(50,130) ;  
    TFT.printf("& finger ") ; 
    TFT.locate(45,160) ;  
    TFT.printf("placement") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ;
}
 
void screen_ecg_bp()            
{ 
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(Green) ;
    TFT.fillrect(10,215,230,290,White);   
    TFT.foreground(Black) ;
    TFT.fillrect( 10,215,100,285,Green);
    TFT.locate(20,245) ;                   
    TFT.printf("MAIN") ;    
    TFT.fillrect(130,215,220,285,Green);
    TFT.locate(155,235) ;          
    TFT.printf("RE-") ;  
    TFT.locate(140,255) ;              
    TFT.printf("TEST") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ;
    
}                
             
void screen_bp()                                                                // BP main screen
{
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(Green) ;
    TFT.foreground(Black) ;
    TFT.fillrect(10,130,100,200,White);   
    TFT.fillrect(130,130,220,200,White);  
    TFT.fillrect(10,215,100,285,White);  
    TFT.fillrect(130,215,220,285,White);
    TFT.fillrect(5,5,115,20,White);  
    TFT.fillrect( 60,130,180,200,Green);
    TFT.locate(80,150) ;
    TFT.printf("START") ;    
    TFT.fillrect( 60,230,180,300,Green);
    TFT.locate(90,250) ;        
    TFT.printf("MAIN") ;          
    TFT.BusEnable(false) ;
    backlight = 1 ;     
 
}
    

void screen_bp1(float SBP, float DBP)                                           // BP  screen 2
{
    char buf[10] = {0}; 
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Green) ;
     
    TFT.fillrect(3,130,200,200,White);
    TFT.fillrect(60,230,180,300,White);
    TFT.fillrect(60,110,180,250,White);
    
    TFT.locate(3,100) ;  
    TFT.printf(" BP Tst Done  ") ; 
    sprintf (buf, "SBP: %d   ",(uint32_t)SBP);              
    TFT.locate(5,140) ;                        
    TFT.printf(buf) ; 
    
    sprintf (buf, "DBP: %d",(uint32_t)DBP);               
    TFT.locate(5,170) ;                      
    TFT.printf(buf) ;
    
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.foreground(Navy) ;
    TFT.locate(5,291) ; 
    TFT.printf("Study Readings: Not for medical") ;              
    TFT.locate(35,300) ;
    TFT.printf("diagnosis and treatment") ;
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.BusEnable(false) ;
    backlight = 1 ; 
}   

void screen_glc()                                                               // glc main screen
{   
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(Green) ;
    TFT.foreground(Black) ;
    TFT.fillrect(10,130,100,200,White);
    TFT.fillrect(130,130,220,200,White);
    TFT.fillrect(10,215,100,285,White);
    TFT.fillrect(130,215,220,285,White);
     TFT.fillrect(5,5,115,20,White);
     
    TFT.fillrect( 10,130,100,200,Green);
    TFT.locate(30,160) ;                          
    TFT.printf("FBS") ;  
        
    TFT.fillrect( 130,130,220,200,Green);
    TFT.locate(155,160) ;
    TFT.printf("PP") ;  
       
    TFT.fillrect( 10,215,100,285,Green);
    TFT.locate(23,245) ;                      
    TFT.printf("RAN") ;  
     
    TFT.fillrect(130,215,220,285,Green); 
    TFT.locate(145,245);                    
    TFT.printf("MAIN") ;  
          
    TFT.BusEnable(false) ;
    backlight = 1 ; 
        
}              
               
void ecg_countdown()                                                            // ECG measurement countdown 
{    
    char timer_buff[1] = {0};                                                            //changed the timer buffer nikita from array
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Green) ;
    
    TFT.fillrect(3,80,240,300,White);   
    TFT.fillrect(60,230,180,300,White);
    TFT.fillrect(5,215,230,290,White);
    TFT.fillrect(5,230,240,320,White );  
    TFT.locate(25,100) ;        
    TFT.printf("ECG starts in") ; 
    for(int i=5;i>=0;i--)
    {
        wait(1);
        sprintf (timer_buff, "%d",i);
        TFT.locate(120,120) ;        
        TFT.printf(timer_buff) ; 
    }
    TFT.fillrect(5,80,240,200,White);    
    TFT.locate(35,110) ;        
    TFT.printf("ECG Tst in") ;                
    TFT.locate(50,140) ;        
    TFT.printf("progress") ;      
    TFT.BusEnable(false) ;
    backlight = 1 ; 
        
      
  }                   
  
void bp_countdown()                                                             // ECG measurement countdown 
{    
    char timer_buff[1] = {0};                                                            //changed from array nikita
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Green) ;
    
    
    TFT.fillrect(3,130,200,200,White);
    TFT.fillrect(60,230,180,300,White);
    TFT.fillrect(1,80,240,290,White);           
    TFT.fillrect(5,230,240,320,White );   
    
    TFT.locate(25,100) ;        
    TFT.printf("BP starts in") ; 
    for(int i=5;i>=0;i--)
    {
        wait(1);
        sprintf (timer_buff, "%d",i);
        TFT.locate(120,120) ;        
        TFT.printf(timer_buff) ; 
    }
    TFT.fillrect(5,80,240,200,White);
    TFT.locate(35,110) ;        
    TFT.printf("BP Tst in") ;                        
    TFT.locate(50,140) ;        
    TFT.printf("progress") ;   
            
    TFT.BusEnable(false) ;
    backlight = 1 ; 
} 
  
void screen_again()                                                             // screen to press 'yes' or 'no' to repeat the test 
{ 
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Black) ;
    TFT.fillrect(5,127,230,200,White);
    
    TFT.locate(50,130) ; 
    TFT.printf("Take test") ;
    
    TFT.locate(75,160) ; 
    TFT.printf("again?") ;
    
    TFT.background(Orange) ;
    
    TFT.locate(30,245) ;  
    TFT.printf("YES") ;
    
    TFT.locate(135,245) ;  
    TFT.printf(" NO ") ;
    
    backlight = 1 ; 
    TFT.BusEnable(false) ;
   
}
  
  
void screen_glc_2()                                                             // GLC screen 3 after test 
{
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Black) ;
    TFT.fillrect(10,215,230,290,White); 
    TFT.background(Green); 
     
    TFT.fillrect( 10,215,100,285,Green);
    TFT.locate(25,245) ;             
    TFT.printf("MAIN") ;
        
    TFT.fillrect(130,215,220,285,Green);
    
    TFT.locate(155,235) ;         
    TFT.printf("RE-") ; 
     
    TFT.locate(140,255) ;           
    TFT.printf("TEST") ;
     
    backlight = 1 ; 
    TFT.BusEnable(false) ;

}  
  
  
void glc_1()                                                                    // GLC screen 
{ 
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Magenta ) ;
    TFT.fillrect(3,130,200,200,White);
    TFT.fillrect(60,230,180,300,White);
    TFT.fillrect(5,215,230,290,White);
    TFT.fillrect( 130,130,220,200,White);
    TFT.fillrect( 5,95,220,200,White);   
    TFT.fillrect(5,230,240,320,White );  
    TFT.locate(5,130) ;  
    TFT.printf("Blood Glucose") ; 
    TFT.locate(5,160) ;  
    TFT.printf("Insert strip") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ; 
}

void glc_2()                                                                    // GLC screen 
{
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.locate(5,160) ;  
    TFT.printf("Strip Detected") ; 
    TFT.locate(5,190) ;  
    TFT.printf("Insert Blood") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ; 
}
   
 
void glc_3()                                                                    // GLC screen 
{
    backlight = 0 ;
    TFT.BusEnable(true) ; 
    TFT.locate(5,190) ;  
    TFT.printf("Blood Detected") ; 
    TFT.locate( 5,220) ;  
    TFT.printf("computing") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ; 
}
   
  
void glc_4(uint16_t mgdl)                                                       // GLC screen to display blood glucose level on the LCD
{ 
    char buf[10] = {0};
    sprintf (buf, " BG %d mg/dl",mgdl);
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.fillrect(5,127,230,320,White);
    TFT.locate(3,100) ;  
    TFT.printf(" BG Tst Done  ") ;
    TFT.locate(5,130) ;  
    TFT.printf(buf) ; 
    TFT.locate(5,160) ;  
    TFT.printf("(Range 70-120 mg/dl)") ;  
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.foreground(Navy) ;
    TFT.locate(5,291) ; 
    TFT.printf("Study Readings: Not for medical") ;                     
    TFT.locate(35,300) ;
    TFT.printf("diagnosis and treatment") ;
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.BusEnable(false) ;
    backlight = 1 ; 
}
  

void battery_screen_nocharge()
{
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(Red) ;
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.foreground(White);
     TFT.fillrect(5,5,115,20,White);
    TFT.fillrect(5,5,95,20,Red);   
    TFT.locate(10,8) ;
    TFT.printf("No Charge") ;
    TFT.set_font((unsigned char*) Arial24x23);  
    TFT.BusEnable(false) ;
    backlight = 1 ;
}

void battery_screen_charge()
{
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(Green) ;
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.foreground(Black);
    TFT.fillrect(5,5,115,20,White);
    TFT.fillrect(5,5,115,20,Green);   
    TFT.locate(10,8) ;
    TFT.printf("Battery Charged") ;
    TFT.set_font((unsigned char*) Arial24x23);  
    TFT.BusEnable(false) ;
    backlight = 1 ;   

}     
 
 
     
void battery_critically_low_charge()
{
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(Red) ;
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.foreground(White);
    TFT.fillrect(5,5,115,20,White);
    TFT.fillrect(5,5,95,20,Red);   
    TFT.locate(10,8) ;
    TFT.printf("Critically Low") ;
    TFT.set_font((unsigned char*) Arial24x23);  
    TFT.BusEnable(false) ;
    backlight = 1 ;  
}     
   
void battery_low_charge()
{
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(Green) ;
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.foreground(Black);
    TFT.fillrect(5,5,115,20,White);
    TFT.fillrect(5,5,95,20,Green);   
    TFT.locate(10,8) ;
    TFT.printf("Low Battery") ;
    TFT.set_font((unsigned char*) Arial24x23);  
    TFT.BusEnable(false) ;
    backlight = 1 ;  
} 
         
void screen_ecg_error()
{  
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Red) ;
    TFT.fillrect(5,90,230,200,White); 
    TFT.locate(50,100) ;  
    TFT.printf("ERROR!") ;   
    TFT.locate(20,130) ;  
    TFT.printf("Take ReTest") ; 

    TFT.BusEnable(false) ;
    backlight = 1 ;    
} 

void screen_bp_error()
{  
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Red) ;
    TFT.fillrect(5,90,230,150,White);
    TFT.locate(50,100) ;  
    TFT.printf("ERROR!") ;   
    TFT.locate(20,130) ;  
    TFT.printf("Take ReTest") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ;    
}  
  
  
void glc_error()                                                                //glc replace test strip
{  
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Red) ;
    TFT.fillrect(5,90,230,300,White);
    TFT.locate(60,100) ;                
    TFT.printf("Replace") ;   
    TFT.locate(40,130) ;                
    TFT.printf("Test Strip") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ;    
}  
  
  
void BT_connection()
 {  
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Blue) ;
    TFT.fillrect(5,90,230,300,White); 
    TFT.fillrect(5,5,115,20,White); 
    TFT.locate(40,140) ;  
    TFT.printf("Connected") ;   
    TFT.locate(20,170) ;  
    TFT.printf("Sending Files") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ;    
} 
  
void BT_no_connection()
{  
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Blue) ;
    TFT.fillrect(5,90,230,300,White); 
    TFT.fillrect(5,5,115,20,White); 
    TFT.locate(80,140) ;  
    TFT.printf("Not") ;   
    TFT.locate(40,160) ;  
    TFT.printf("Connected") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ;    
}   
  
void BT_finished()
{ 
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Blue) ;
    TFT.fillrect(5,90,230,300,White);  
    
    TFT.locate(20,140) ;  
    TFT.printf("Files Tranfer") ;   
    TFT.locate(40,170) ;  
    TFT.printf("Completed") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ;    
}
  
  
void screen_BT_return()                                                         // BT main screen
{
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(Green) ;
    TFT.foreground(Black) ;    
    TFT.fillrect( 60,230,180,300,Green);
    TFT.locate(80,250) ;        
    TFT.printf("MAIN") ;          
    TFT.BusEnable(false) ;
    backlight = 1 ;     
}  
    
    
void screen_patient_info(uint32_t current_test_pid,uint32_t  bt_file_sent_pid)
{
    char buf[10] = {0};
    sprintf (buf, "Test pid:%d",current_test_pid);      
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White);
    TFT.foreground(Blue);   
    TFT.fillrect(5,90,230,300,White);
    TFT.fillrect(5,5,115,20,White);
    TFT.locate(15,140) ;                                 
    TFT.printf(buf) ; 
    sprintf (buf,"BT pid :%d",bt_file_sent_pid);
    TFT.locate(15,170) ;                               
    TFT.printf(buf) ;     
    TFT.background(Green) ;
    TFT.foreground(Black) ; 
    TFT.fillrect( 60,230,180,300,Green);
    TFT.locate(80,250) ;        
    TFT.printf("MAIN") ;           
    TFT.BusEnable(false) ;
    backlight = 1 ;   
    
}
void glc_error_test_strip_removed()                                             //glc test strip REMOVED
{  
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Red) ;
    TFT.fillrect(5,90,230,300,White);  
    TFT.locate(50,130);            
    TFT.printf("Test Strip") ;   
    TFT.locate(50,160) ;                
    TFT.printf("Removed") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ;    
}

void screen_debug()
{
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(GreenYellow) ;
    TFT.fillrect(5,127,230,320,White );  
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.foreground(Black);
    TFT.fillrect( 10,130,100,200,GreenYellow);
    TFT.locate(45,140) ;                                
    TFT.printf("SD") ;                                 
    TFT.locate(30,170) ;                                
    TFT.printf("DEL") ;
    TFT.fillrect( 130,130,220,200,GreenYellow);
    TFT.locate(150,140) ;                               
    TFT.printf("SD") ;    
    TFT.locate(140,170) ;                              
    TFT.printf("READ") ;                             
    TFT.fillrect( 10,215,100,285,GreenYellow);
    TFT.locate(22,245) ;                                
    TFT.printf("*") ;    
    TFT.fillrect(130,215,220,285,GreenYellow);
    TFT.locate(130,245) ;        
    TFT.printf("BACK") ;    
    TFT.BusEnable(false) ;
    backlight = 1 ;
    
    
} 

void screen_sdcard_delete(void)
{
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.fillrect(10,130,100,200,White);   
    TFT.fillrect(130,130,220,200,White);  
    TFT.fillrect(10,215,100,285,White);  
    TFT.fillrect(130,215,220,285,White);
    TFT.fillrect(5,5,115,20,White); 
    TFT.background(White) ;  
    TFT.foreground(Red);
    TFT.locate(15,140) ;
    TFT.printf("SD card erased"); 
    TFT.fillrect( 60,230,180,300,Green);
    TFT.background(Green) ;
    TFT.foreground(Black) ;
    TFT.locate(80,250) ;        
    TFT.printf("MAIN") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ; 
}   

void screen_sdcard_read(void)
{
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.fillrect(10,130,100,200,White);   
    TFT.fillrect(130,130,220,200,White);  
    TFT.fillrect(10,215,100,285,White);  
    TFT.fillrect(130,215,220,285,White);
    TFT.fillrect(5,5,115,20,White); 
    TFT.background(White) ;  
    TFT.foreground(Red);
    TFT.locate(15,140) ;
    TFT.printf("SD file read"); 
    TFT.fillrect( 60,230,180,300,Green);
    TFT.background(Green) ;
    TFT.foreground(Black) ;
    TFT.locate(80,250) ;        
    TFT.printf("MAIN") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ; 
}   

void database_error(void)                                                        // database eerror display
{
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.fillrect(5,127,230,320,White );  
    //TFT.fillrect(5,5,115,20,White); 
    TFT.background(White) ;  
    TFT.foreground(Red);
    TFT.locate(15,140) ;
    TFT.printf("Database-Error"); 
    TFT.BusEnable(false) ;
    backlight = 1 ; 
}   