#include "mbed.h"
#include "MAX30102.h"
#include <string.h>
#include <stdio.h>
#include "eeprom_pgm.h"
#include <time.h>
#include "ds3231.h"
#include "SDFileSystem.h"
#include "rtc.h"
#include "sdcard.h"
#include "ec_bp.h"
#include "bp.h"
#include "display_modules.h"
#include "struct.h"
#include "main.h"

#define INTERRUPT_PIN                       PTC7

#define MAX_SBP_THRESHOLD                   300
#define MAX_DBP_THRESHOLD                   300
#define MIN_SBP_THRESHOLD                   40
#define MIN_DBP_THRESHOLD                   40

#define BP_LENGTH_IN_BYTES                  10774                               //Total bp_data length = ((1024+1664)*4)+ 22
#define BP_ECG_SAMPLES                      1024                                //Total ECG samples captured
#define BP_PPG_SAMPLES                      1664                                //Total PPG samples captured
#define DUMMY_CAPTURE                       500                                 //Samples to check finger detection and signal to stabilize
#define PPG_MAX_MIN_DIFF                    300                                 //Difference value to check finger detection
#define ECG_PPG_SAMPLES                     1024                                //ECG and PPG Capture loop count
#define PPG_SAMPLES                         640                                 //PPG Capture loop count
#define BLOOD_VELOCITY_DIVISOR              210000                              //Distance from tip of finger to wrist pulse
#define SBP_MAIN_FACTOR                     (float)0.0508955                    //Used for SBP calculation
#define SBP_CORRECTION_FACTOR               (float)62.559                       //Correction factor for SBP
#define DBP_MAIN_FACTOR                     (float)0.0494                       //Used for DBP calculation
#define DBP_CORRECTION_FACTOR_1             (float)17.480                       //Correction factor for DBP
#define DBP_CORRECTION_FACTOR_2             10                                  //Correction factor for DBP
#define PEAK_DETECT_RANGE_PPG               350                                 // Peak detect range for PPG samples


uint16_t sd_BP_ECGMAX(uint32_t pid);                        
uint16_t sd_BP_PPGMAX(uint32_t pid); 


Serial serial_bp(USBTX,USBRX);
DigitalIn INTERRUPT_PPG(INTERRUPT_PIN);

uint16_t ecgloc = 0;                                                            //ECG maximum location 
uint16_t ppgloc = 0;                                                            //PPG maximum location                                                            
uint16_t ebp = 0;                                                               // variable for LOOP operation to read value from F
uint16_t pbp = 0;  
FILE *fpppg1;

void bp(uint32_t pid) 
{
    uint8_t uch_dummy;
    uint32_t ppgdata; 
    uint8_t lead_reg=0;
    uint32_t concatenate_value2 = 0;    
    //uint8_t chk = 1;                                                          //commented nikita                   
    uint32_t un_max = 0;                                                        // Declare two VARIABLE FOR MAX AND MIN
    uint32_t un_min = 0x3FFF;
    
    uint16_t eloc = 0;  
    uint16_t ploc = 0; 

    float PWV = 0;
    uint16_t delta_t = 0;   
    float SBP = 0;
    float DBP = 0;
    
    FILE *ecg = NULL;
    FILE *ppg = NULL;
  
    //Declaration of  Master structure
    
    BLEMsg_info *ptr_BLEMsg_info_bp, BLEMsg_info_bp;                            // A copy of master strcuture [ "BLEMsg_info" ] by name "BLEMsg_info_bp" is created
    ptr_BLEMsg_info_bp = &BLEMsg_info_bp;                                       // *ptr_BLEMsg_info_bp is the pointer to local copy;
    
    // Declaration of Date Structure
    DateTime_info DateTime_info_bp;                                             // A copy of Master Structure "DateTime_info" created, //commented nikita  
   // ptr_DateTime_info_bp = &DateTime_info_bp;                                  // Structure pointer points to that copy.
    
    
    // RTC operations
    time_t epoch_time_bp;                                                       //A copy of time_t by name  epoch_time_bp is created 
    epoch_time_bp = rtc_read();                                                 // time is got from get epoch function.  
    
    struct tm * ptr_time_info_bp;                                               // Sturucture copy of tm is created//removed //time_info_bp; //nikita
    ptr_time_info_bp = localtime(&epoch_time_bp);                               // Structure accepts the time in local format from "time_t" type.
      
    //BELOW LINE IS TO CHECK Date and TIME 
    serial_bp.printf("Time is %d: %d: %d\n", (*ptr_time_info_bp).tm_hour, (*ptr_time_info_bp).tm_min, (*ptr_time_info_bp).tm_sec);
    serial_bp.printf("Date is %d:%d:%d\n", (*ptr_time_info_bp).tm_mday, (*ptr_time_info_bp).tm_mon+1, (*ptr_time_info_bp).tm_year-100);
    
    //Copying from one structure to the other using variables
    DateTime_info_bp.hour = (uint8_t)(*ptr_time_info_bp).tm_hour;
    DateTime_info_bp.mins = (uint8_t)(*ptr_time_info_bp).tm_min;
    DateTime_info_bp.sec =  (uint8_t)(*ptr_time_info_bp).tm_sec;
    
    DateTime_info_bp.date = (uint8_t) (*ptr_time_info_bp).tm_mday;
    DateTime_info_bp.month =(uint8_t)(*ptr_time_info_bp).tm_mon+1;
    DateTime_info_bp.year = (uint8_t)(*ptr_time_info_bp).tm_year-100;
    
    // Copying Time to Main structure
    BLEMsg_info_bp.date_time.hour = DateTime_info_bp.hour;
    BLEMsg_info_bp.date_time.mins = DateTime_info_bp.mins;
    BLEMsg_info_bp.date_time.sec = DateTime_info_bp.sec;
    
    BLEMsg_info_bp.date_time.date = DateTime_info_bp.date ;
    BLEMsg_info_bp.date_time.month = DateTime_info_bp.month ;
    BLEMsg_info_bp.date_time.year =  DateTime_info_bp.year ;
    
    
    //Checking if the structure has these values    
    serial_bp.printf("Time 2 is %d:%d:%d\n", DateTime_info_bp.hour, DateTime_info_bp.mins, DateTime_info_bp.sec);
    serial_bp.printf("\t Date is %d:%d:%d\n",DateTime_info_bp.date, DateTime_info_bp.month, DateTime_info_bp.year);
    
    
    //Loading values to of Test type
    test_type_info test_type_info_bp;                                           // copy of " test_type_info" created  
    test_type_info_bp = BP_Test;                                                // Loaded value 00 to the test type 
    
    BLEMsg_info_bp.test_type = test_type_info_bp;
    
    serial_bp.printf("Test Type is : %d\n", test_type_info_bp);
    
    
    // Loading values of Length ,  PID, DID, sampling frequency, number of samples, calculated data.
    BLEMsg_info_bp.device_id = get_did();                   // Device ID fixed  // changed on 11/8/17 nikita
    serial_bp.printf("device id read ecg = %d\n", BLEMsg_info_bp.device_id); 
    BLEMsg_info_bp.patient_id = pid;       // Patient ID
    BLEMsg_info_bp.sampling_freq = ECG_SAMPLING_FREQUENCY;                      // sampling frrquency
    BLEMsg_info_bp.length = BP_LENGTH_IN_BYTES;                                 //Total length of data in bytes  22 B+10752 B
    
    BLEMsg_info_bp.num_samples.num_sample_ppg_dummy =  BP_PPG_SAMPLES ;         // PPG  number of samples copied to master struct 
    BLEMsg_info_bp.num_samples.num_sample_ecg_OTtyp =  BP_ECG_SAMPLES ;         // ECG  number of samples copied to master struct
    
    //serial_bp.baud(SERIAL_BAUD_RATE);

    freqset();                                                                   // setting the frequency
    setupfunc();              
    lead_reg = ecgsetupfunc();                                                    // lead contact // 14/06
        
    maxim_max30102_reset();                                                     // PPG reset
    wait_ms(20);
    maxim_max30102_init();
        
    //chk = 1;                                                                  //commented nikita  
        
    for(uint16_t i = 0; i < DUMMY_CAPTURE; i++)
    {
        concatenate_value2= readvalue();
        maxim_max30102_read_reg(0,&uch_dummy);
        while(INTERRUPT_PPG.read()==1); 
        maxim_max30102_read_fifo(&ppgdata); 
    }     
       
    for(uint16_t i=0; i < DUMMY_CAPTURE; i++)                                   // READS 500 SAMPLES TO SEE MAX AND MIN VAL DIFFERENCE
    {        
        maxim_max30102_read_reg(0,&uch_dummy);
        while(INTERRUPT_PPG.read()==1); 
        maxim_max30102_read_fifo(&ppgdata); 
        serial_bp.printf("%d\n",ppgdata);
        if(un_min>ppgdata)
        un_min=ppgdata;    //update signal min
        if(un_max<ppgdata)
        un_max=ppgdata; 
    }  

    serial_bp.printf("The max is %d\n", un_max); //
    serial_bp.printf("The min is %d\n", un_min);
    if (((un_max -un_min) > PPG_MAX_MIN_DIFF) && (lead_reg == LEADS_DETECTED))  // Checking for threshold 300 Added Nidhin 16/6/17
    { 
        sd_open_BPfilee(pid);
        sd_open_BP_ECGfile(pid) ;                                               //   sd_open_BP_ECGfile(123) draft file for testing
        sd_open_BP_PPGfile(pid) ;                                               // sd_open_BP_PPGfile(123) draft file for testing
        
        for(uint16_t i=0; i < ECG_PPG_SAMPLES; i++)                       
        {
            concatenate_value2 = readvalue();
            ecg = sd_BP_ecgwrite(&concatenate_value2);
            
            maxim_max30102_read_reg(0,&uch_dummy);
            while(INTERRUPT_PPG.read()==1); 
            maxim_max30102_read_fifo(&ppgdata); 
            ppg = sd_BP_ppgwrite(&ppgdata); 
        }
                
        for(uint16_t i=0; i< PPG_SAMPLES; i++) 
        {
            maxim_max30102_read_reg(0,&uch_dummy);
            while(INTERRUPT_PPG.read()==1); 
            maxim_max30102_read_fifo(&ppgdata); 
            ppg = sd_BP_ppgwrite (&ppgdata);         
        }
        
        fclose(ecg);
        fclose(ppg);
     
        maxim_max30102_reset();
    
        eloc = sd_BP_ECGMAX(pid); 
        ploc = sd_BP_PPGMAX(pid); 
        serial_bp.printf("eloc: %d ploc: %d\n",eloc,ploc);
        
        delta_t  = (2*(ploc - eloc));
        PWV = BLOOD_VELOCITY_DIVISOR /  delta_t;
   
        SBP = SBP_MAIN_FACTOR * PWV + SBP_CORRECTION_FACTOR;
        DBP = (DBP_MAIN_FACTOR * PWV + DBP_CORRECTION_FACTOR_1) + DBP_CORRECTION_FACTOR_2;
        serial_bp.printf("sbp: %d dbp: %d\n",(uint16_t)SBP,(uint16_t)DBP);
        
        BLEMsg_info_bp.cal_data.cal_sbp_dummy = (uint16_t) SBP;
        BLEMsg_info_bp.cal_data.cal_dbp_OTtyp = (uint16_t) DBP;

        if((SBP > MAX_SBP_THRESHOLD || SBP < MIN_SBP_THRESHOLD)  && (DBP > MAX_DBP_THRESHOLD || DBP < MIN_SBP_THRESHOLD))              // checking for range below and above and then displaying error
        {
            screen_bp_error();                                                  // checking for error out of range
            del_ppg_ecg_BPfile(pid);                                             // Copy ECG and PPG data to BP file
            delete_subfiles(pid);     
        } 
    
        else 
        { 
            create_single_BPfile(pid);                                          // Copy ECG and PPG data to BP file
            structure_file(ptr_BLEMsg_info_bp, pid);                            // Copy BP structure to main file
            bpfile_mainfile(pid);
            screen_bp1(SBP,DBP);
            if(get_filecreated_status() == false)                               //if file is in write mode 
            {   
                set_filecreated_status();                    
                increment_filepid (); 
            } 
        }
    }    
  
    else   
    {      
        maxim_max30102_reset();
        serial_bp.printf("no finger detect\n");
        screen_ecg_lead_bp_fingerdetect();
    }  
    screen_ecg_bp() ; 
} 

uint16_t sd_BP_ECGMAX(uint32_t pid)         
{
    uint32_t ecgmax = 0;     
    uint32_t ecg_buffer[1] = {0};                                               // a changed to ecg buffer
    uint16_t samplesecg = 0;    
    char buffer1[32];
    FILE *fpecg_bp;                                                             // file pointer in place of fpecg- Suhasini- 21/7/17
   
    sprintf(buffer1,"/sd/%d_BP_ECG.csv",pid);
    fpecg_bp = fopen(buffer1,"r"); 
    if(fpecg_bp == NULL)
    {
        exit(1);
    }
  
    else
    {
        for(ebp=0; ebp < BP_ECG_SAMPLES; ebp++)
        {

    
            fread(ecg_buffer,sizeof(uint32_t), 1,fpecg_bp);                      // a changed to ecg buffer
            if(ecg_buffer[0] > ecgmax)                                           // a changed to ecg buffer
            {
                ecgmax = ecg_buffer[0];
                ecgloc = ebp +1;
            }
            else
                samplesecg = ebp+1;
        }
    }
   fclose (fpecg_bp);
   return ecgloc; 
 } 
 
 // Function to calculate PPG MAx and location
 
uint16_t sd_BP_PPGMAX(uint32_t pid)      
{
    uint32_t ppgmax = 0;          
    uint32_t ppg_buffer[1] ={0};                                                 //b changed to ppg_buffer         
    uint16_t samplesppg = 0;                                                 
    char buffer1[32];
   
    sprintf(buffer1,"/sd/%d_BP_PPG.csv",pid);
    fpppg1 = fopen(buffer1,"r"); 
    if(fpppg1 == NULL)
    {
        exit(1);
    }
  
    else
    {
        for(pbp=0; pbp < BP_PPG_SAMPLES; pbp++)
        {
            fread(ppg_buffer, sizeof(uint32_t),1, fpppg1);                      //b changed to ppg_buffer 
                             
            if((pbp>ecgloc) && (pbp< (ecgloc + PEAK_DETECT_RANGE_PPG)))
            {
                if(ppg_buffer[0] > ppgmax)
                {
                    ppgmax = ppg_buffer[0];                                     //b changed to ppg_buffer 
                    ppgloc= pbp+1;
                }
                else
                    samplesppg =pbp+1;
            }
            else 
                samplesppg = pbp+1;
        }
    }        
    fclose (fpppg1);
    return ppgloc;
} 