 
#include "mbed.h"
#include <stdio.h>
#include "SDFileSystem.h"
#include "sdcard.h"
#include "rtc.h"
#include "struct.h"
#include "main.h"
#include "eeprom_pgm.h"
  
  Serial snd(USBTX,USBRX);



FILE *fpecg;                                                                    // PPG and ECG File pointers for BP
FILE *fpppg;                                                                    //""          ""

FILE *fpmain;                                                                   // FILE pointer for main file

FILE *fpbg;                                                                     // FILE pointer to BG file
FILE *fpeecg;                                                                   // FILE pointer to ECG file
FILE *fpbp;                                                                     // FILE pointer to BP file

FILE *fp;                                                                       // FILE pointer for random use
  
  


 
void sd_open_GLCfilee(uint32_t pid)                                             // only opening the glc file after entering TEST screen
{
    char buffer1[32];
    sprintf(buffer1,"/sd/%d_GLC.csv",pid);
    fpbg = fopen(buffer1,"a"); 
    fclose(fpbg);
} 
 
 
void sd_open_ECGfilee(uint32_t pid)                                             // only opening the ECG file after entering TEST screen
{
    char buffer1[32];
    sprintf(buffer1,"/sd/%d_ECG.csv",pid);
    fpeecg = fopen(buffer1,"a"); 
} 
 
 
void sd_open_BPfilee(uint32_t pid)                                              // only opening the BP file after entering TEST screen
{
    char buffer1[32];
    sprintf(buffer1,"/sd/%d_BP.csv",pid);
    fpbp = fopen(buffer1,"a"); 
    fclose(fpbp);
} 
  

 
uint8_t sd_open_read_bt(uint32_t pid)                                            // opening the file for read //name changed nikita  
{
    char buffer1[32] = {};
    sprintf(buffer1,"/sd/%d.csv",pid);
    fp = fopen(buffer1,"r"); 
    if (fp==NULL)
    {
        snd.printf("no");
        return 0;
    }
    else 
    {
        snd.printf("yes");
        return 1;
    }
}
 
void sd_read_bt(uint32_t  *v1, uint16_t size)                                    //reading the data from the openend file// nikita changed name
{
    fread(v1,sizeof(v1),size,fp);
}


void setpos_file(uint32_t position)                                        //changed the name nikita
{
    fseek ( fp , position, SEEK_SET );  
}


uint32_t file_size_init()                                                       //changed the name nikita// defines the size of the file    
{
    uint32_t file_length = 0;
    
    fseek (fp, 0, SEEK_END);
    file_length = ftell(fp);
    file_length = sizeof(char)*file_length;
    rewind(fp);
    return file_length;
}  
     
     
uint32_t file_size_sent()                                                       //changed the name // defines the file size sent on bluetooth   
{
    uint32_t file_length;
    
    file_length=ftell(fp);
    return   file_length;
}  

void sd_read_struct(BLEMsg_info &f)                                             //changed the function name nikita
{
    fread(&f,sizeof(BLEMsg_info),1,fp);
}
 
  
FILE *sd_BP_ecgwrite (uint32_t *fp_bp_ecg)                                       // writing data into the file NIDHIN //pointer name changed nikita 
{
    fwrite(fp_bp_ecg,sizeof(uint32_t),1, fpecg);                                 // Direct writing to SD card.
    return fpecg;
}

FILE* sd_BP_ppgwrite (uint32_t *fp_bp_ppg)                                       // Direct writing to SD card.// pointer name changed nikita
{
    fwrite(fp_bp_ppg,sizeof(uint32_t),1, fpppg);                                 //Direct writing to SD card.
    return fpppg;
}
  


void sd_open_BP_ECGfile(uint32_t pid)         
{
    char buffer1[32];

    sprintf(buffer1,"/sd/%d_BP_ECG.csv",pid);
    fpecg = fopen(buffer1,"a"); 
    if (fpecg == NULL)
    {
        exit(1);
    }   
} 
 
  
void sd_open_BP_PPGfile(uint32_t pid)         
{
    char buffer1[32];
    
    sprintf(buffer1,"/sd/%d_BP_PPG.csv",pid);
    fpppg = fopen(buffer1,"a"); 
    if(fpppg == NULL)
    {
        exit(1);
    }

} 
  
//FUNCTIONS TO CLOSE FILES

void sd_close()                                                                 //close the file with fp
{
    fclose(fp);
}
   
void sd_close_ecg()                                                             // Closes ECG file pinted by fpeecg
{
    fclose(fpeecg);
}


 
//------- FUNCTION TO CREATE SINGLE BP FILE -----------------//
void create_single_BPfile(uint32_t pid)
{  
    char buffer3[32];
    uint8_t bp_loop = 0;
    sprintf(buffer3, "/sd/%d_BP.csv", pid);
    fpbp = fopen(buffer3, "a");                                                 // Opens BP file with FILE pointer fpbp in APPEND mode
    
    sprintf(buffer3, "/sd/%d_BP_ECG.csv", pid);   
    fpecg = fopen(buffer3, "r");                                                // Opens ECG file of BP with FILE pointer fpecg in READ mode

    sprintf(buffer3, "/sd/%d_BP_PPG.csv", pid);
    fpppg = fopen(buffer3, "r");                                                // Opens PPG file of BP with FILE pointer fpppg in READ mode

    for(bp_loop=0; bp_loop<16; bp_loop++)
    {
        uint32_t ecgbuf[64] = {0} ;                                             //changed from int to uint32_t//nikita
        fread(ecgbuf, sizeof(uint32_t), 64, fpecg);
        fwrite(ecgbuf, sizeof(uint32_t), 64, fpbp);                             // Copy ECG data of BP into BP file
    }

    for(bp_loop=0; bp_loop<26; bp_loop++)                                             //changed from int to uint32_t//nikita
    {
        uint32_t ppgbuf[64] = {0} ;
        fread(ppgbuf, sizeof(uint32_t), 64, fpppg);
        fwrite(ppgbuf, sizeof(uint32_t), 64, fpbp);                             // Copy PPG data of BP into BP file
    }

    fclose(fpecg);                                                              // Closes the ECG file of BP
    fclose(fpppg);                                                              // Closes the PPG file of BP
    fclose(fpbp);                                                               // Closes the BP file

    int status = 1 ;
    sprintf(buffer3, "/sd/%d_BP_ECG.csv", pid);
    status = remove(buffer3);                                                   //Removes ECG file of BP and updates status with 0 if successful
    
    
    if( status == 0 )
        snd.printf("\nECG file delete : Successful");                           // Checks for SUCCESS
    else 
        snd.printf("\nECG file delete : UnSuccessful");
   
    status = 1 ;
    sprintf(buffer3, "/sd/%d_BP_PPG.csv", pid);
    status = remove(buffer3);                                                   //Removes PPG file of BP and updates status with 0 if successful
    
    if( status == 0 )
        snd.printf("\nPPG file delete : Successful");                           // Checks for SUCCESS
    else 
        snd.printf("\nPPG file delete : UnSuccessful");
       
}

//Creating strcuture file Common to All Functions
void structure_file(BLEMsg_info *ptr, uint32_t pid)
{
    char buffer3[32];
    sprintf(buffer3, "/sd/%d.csv", pid);                                        //Printing file path to the buffer
    if(get_filecreated_status() == true)                                        //if file created open in append mode
    {
        fpmain = fopen(buffer3, "a");                                           // open the file PID.csv with FILE pointer fpmain
        snd.printf("\n Append mode\n");
    }
    else                                                                        //if file not created, open in write mode
    {
        fpmain = fopen(buffer3, "w");                                           // open the file PID.csv with FILE pointer fpmain 
        snd.printf("\n Write mode\n"); 
    }    
        
    fwrite(ptr, sizeof(uint8_t),26, fpmain );                                   // writing the Structure into the file
    fclose(fpmain);                                                             // Close File
}



void bpfile_mainfile(uint32_t pid)                                              //Copy data of bp file to main
{
    char buffer3[32];
    uint8_t bp_loop = 0;
    int success;
    sprintf(buffer3, "/sd/%d.csv", pid);
    fpmain = fopen(buffer3, "a");                                               // Opens Main file with FILE pointer "fpmain" in APPEND mode
    
    sprintf(buffer3, "/sd/%d_BP.csv", pid);
    fpbp = fopen(buffer3, "r");                                                 // Opens BP file with FILE pointer "fpbp" in READ mode
    
    
    for(bp_loop=0; bp_loop<21; bp_loop++)                                             //changed from int to uint32_t//nikita
    {
        uint32_t bigbuf[128] = {0} ;
        fread(bigbuf, sizeof(uint32_t), 128, fpbp);
        fwrite(bigbuf, sizeof(uint32_t), 128, fpmain);                          // Copy BP raw data into main file 
    }
    fclose(fpbp);                                                               // Close BP file
    fclose(fpmain);                                                             // Close Main File
    
   
    sprintf(buffer3, "/sd/%d_BP.csv", pid);
    success = remove(buffer3);                                                  // Should return zero on success
    snd.printf("DELETE STATUS = %d\n", success); 
}

void sd_ecgwrite(uint32_t *ecg_ptr)                                             //function to print ECG data to Sd card using fwrite                                     
{
   fwrite(ecg_ptr, sizeof(int), 1, fpeecg); 
}

void ecgfile_mainfile(uint32_t pid)                                             //Function to write ECG data to main file
{
    char buffer3[32];
    int success;
    uint8_t ecg_loop = 0;                                                       //loop name changed nikita
    sprintf(buffer3, "/sd/%d.csv", pid);       
    fpmain = fopen(buffer3, "a");                                               // Main File is opened in Append mode
    snd.printf("opening main file\n");
    
    sprintf(buffer3, "/sd/%d_ECG.csv", pid);                                    // ECG file is opened in read mode
    fpeecg = fopen(buffer3, "r");
    snd.printf("opening temp file\n");
    
    for(ecg_loop=0; ecg_loop<20; ecg_loop++)                                                     //the loop runs as 20 times of 100 i.e., 2k
    {
        uint32_t bigbuf[100] = {0} ;                                            //changed from int to uint32_t//nikita
        fread(bigbuf, sizeof(uint32_t),100 , fpeecg);
        fwrite(bigbuf, sizeof(uint32_t), 100, fpmain);
    }
    snd.printf("to close temp file\n");
    fclose(fpeecg);                                                             // Both files are Closed
    
    snd.printf("to come out of main file\n");
    fclose(fpmain);
    
    snd.printf("COPY complete Files Closed\n"); 
    
    sprintf(buffer3, "/sd/%d_ECG.csv", pid);                                    // ECG file is opened in write mode to empty the file
    fpeecg = fopen(buffer3, "r");
    fclose(fpeecg);                                                             // File is closed
    
    
    sprintf(buffer3, "/sd/%d_ECG.csv", pid);
    success = remove(buffer3); 
    snd.printf("DELETE STATUS = %d\n", success); 
    
    success = 1;
    
    sprintf(buffer3, "/sd/%d_ECG_lpf.csv", pid);
    success = remove(buffer3); 
    snd.printf("DELETE STATUS = %d\n", success);
}

void sd_glcwrite(uint32_t *glc_ptr, uint32_t pid)                               // Function to write GLC data to GLC file
{
    char buffer3[32];
    
    sprintf(buffer3, "/sd/%d_GLC.csv", pid);       
    fpbg = fopen(buffer3, "a");  
    fwrite(glc_ptr, sizeof(uint32_t), 2, fpbg);
    fclose(fpbg);
   
}

void glcfile_mainfile(uint32_t pid)                                             //Fuinction to write GLC data to Main file
{
    char buffer3[32];
    int bigbuf[2] = {0} ;
    int success;
    
    sprintf(buffer3, "/sd/%d.csv", pid);       
    fpmain = fopen(buffer3, "a");                                               // Main File is opened in Append mode
    
    sprintf(buffer3, "/sd/%d_GLC.csv", pid);                                    // BG file is opened in read mode
    fpbg = fopen(buffer3, "r");
    
    for(int i=0; i<1; i++)
    {
        fread(bigbuf, sizeof(int),2 , fpbg);      
        fwrite(bigbuf, sizeof(int), 2, fpmain);
    }
    fclose(fpbg);                                                               // Both files are Closed
    fclose(fpmain);
    
    sprintf(buffer3, "/sd/%d_GLC.csv", pid);  
    success = remove(buffer3);                                                  // GLC file is deleted
    snd.printf("DELETE STATUS = %d\n", success);
}


void delete_subfiles(uint32_t pid)
{
    char buffer3[32];  
    int success1 , success2, success3;
    
    success1 = 1 ;
    sprintf(buffer3, "/sd/%d_BP.csv", pid);
    success1 = remove(buffer3);                                                 //Removes PPG file of BP and updates status with 0 if successful
    if( success1 == 0 )
        snd.printf("\nBP file delete : Successful");                            // Checks for SUCCESS
    else 
        snd.printf("\nBP file delete : UnSuccessful");

    success2 = 1 ;
    sprintf(buffer3, "/sd/%d_GLC.csv", pid);
    success2 = remove(buffer3);                                                 //Removes GLC file and updates status with 0 if successful
    
    if( success2 == 0 )
        snd.printf("\nGLC file delete : Successful");                           // Checks for SUCCESS
    else 
        snd.printf("\nGLC file delete : UnSuccessful");

    success3 = 1 ;
    sprintf(buffer3, "/sd/%d_ECG.csv", pid);
    success3 = remove(buffer3);                                                 //Removes ECG file and updates status with 0 if successful
    
    if( success3 == 0 )
        snd.printf("\nECG file delete : Successful");                           // Checks for SUCCESS
    else 
        snd.printf("\nECG file delete : UnSuccessful");
        
    success3 = 1;
    sprintf(buffer3, "/sd/%d_ECG_lpf.csv", pid);
    success3 = remove(buffer3); 
    snd.printf("DELETE STATUS = %d\n", success3);
    
    if( success3 == 0 )
        snd.printf("\nECG_lpf file delete : Successful");                       // Checks for SUCCESS
    else 
        snd.printf("\nECG_lpf file delete : UnSuccessful");

}


void del_ppg_ecg_BPfile(uint32_t pid)
{
    int status = 1 ;
    char buffer3[32];
    sprintf(buffer3, "/sd/%d_BP_ECG.csv", pid);
    status = remove(buffer3);                                                   //Removes ECG file of BP and updates status with 0 if successful
        
    if( status == 0 )
        snd.printf("\n temp ECG file delete for error condition: Successful");  // Checks for SUCCESS
    else 
        snd.printf("\n temp ECG file delete for error condition: UnSuccessful");
   
    status = 1 ;
    sprintf(buffer3, "/sd/%d_BP_PPG.csv", pid);
    status = remove(buffer3);                                                   //Removes PPG file of BP and updates status with 0 if successful
    
    if( status == 0 )
        snd.printf("\n temp PPG file delete for error condition: Successful");  // Checks for SUCCESS
    else 
        snd.printf("\n temp PPG file delete for error condition: UnSuccessful");
       
}

void sd_read(uint32_t  *pid_btpid)                                              //reading the data from the openend file
{
    uint32_t pid[2]={0,0};
 //   int success;
    FILE *fp;
    
    fp= fopen("/sd/pid_info.txt","r");
     if (fp==NULL)
    {
       fp= fopen("/sd/pid_info.txt","w");
       fwrite(&pid, sizeof(uint32_t),2,fp);
       fclose(fp);
       fp= fopen("/sd/pid_info.txt","r");
    }
     
     fread(pid_btpid,sizeof(pid_btpid),2,fp);
     fclose(fp);
     
}
 
 
void sd_write_pid(uint32_t  *pid_btpid)                                             //reading the data from the openend file
{
     FILE *fp;
     fp= fopen("/sd/pid_info.txt","w");
     fwrite(pid_btpid,sizeof(pid_btpid),2,fp);
     fclose(fp);
     
}

void delete_sdcard(void)
{
    FILE *fp;
    uint32_t pid[2] = {0,0};
    fp= fopen("/sd/pid_info.txt","w");
    fwrite(&pid, sizeof(uint32_t),2,fp);
    fclose(fp);
        
}

void read_sdcard_file()
{      
    char buffer[32];
    uint32_t pid = 0;
    FILE *fp_read_sdcard_file ;                                                 // PPG and ECG File pointers for BP
    snd.scanf("%d", &pid);
    snd.printf("%d\n",pid);
    
    sprintf(buffer,"/sd/%d.csv",pid);
    fp_read_sdcard_file = fopen(buffer, "rb");
    
    if(fp_read_sdcard_file == NULL)
    {
        snd.printf("No FILE Found .... !!\n");
    }    
    
    else
    {
        read_structure(fp_read_sdcard_file);
        snd.printf("Finished Reading File Content....!!\n");
        fclose(fp_read_sdcard_file);
    }                                                                           //end of else loop 
     
 }  
   
void read_structure(FILE * fp_read_sdcard_file)
 
 {
   BLEMsg_info pid_file;     
   uint32_t buf[1] = {0};                                                             // buffer to read the raw data
   uint16_t sample = 0;                                                         // variable to hold the no of samples

    fread(&pid_file,sizeof(BLEMsg_info),1,fp_read_sdcard_file);                 // reading the structure data
    while (!feof(fp_read_sdcard_file))
    {       
        snd.printf("length = %d\n",pid_file.length); 
        snd.printf("device_id = %d\n",pid_file.device_id); 
        snd.printf("patient_id = %d\n",pid_file.patient_id);    
        snd.printf("date = %d\n",pid_file.date_time.date);     
        snd.printf("month = %d\n",pid_file.date_time.month);  
        snd.printf("year = %d\n",pid_file.date_time.year);  
        snd.printf("hour = %d\n",pid_file.date_time.hour);      
        snd.printf("mins = %d\n",pid_file.date_time.mins);  
        snd.printf("sec = %d\n",pid_file.date_time.sec);  
        snd.printf("test_type = %d\n",pid_file.test_type);   
        snd.printf("sampling_freq = %d\n",pid_file.sampling_freq); 
        snd.printf("sample1 = %d\n",pid_file.num_samples.num_sample_ppg_dummy); 
        snd.printf("samples2 = %d\n",pid_file.num_samples.num_sample_ecg_OTtyp); 
        sample=(pid_file.num_samples.num_sample_ppg_dummy + pid_file.num_samples.num_sample_ecg_OTtyp);
        snd.printf("caldata1 = %d\n",pid_file.cal_data.cal_sbp_dummy);   
        snd.printf("caldata2  = %d\n",pid_file.cal_data.cal_dbp_OTtyp); 
        snd.printf("sample=%d\n", sample);
        for(uint16_t file_start=0;file_start<sample;file_start++)                                //reading the raw data
        {     
            fread(buf,sizeof(uint32_t),1,fp_read_sdcard_file);
            snd.printf("%d\n", buf[0]);                                                         //changed to %d nikita
        }
        fread(&pid_file,sizeof(BLEMsg_info),1,fp_read_sdcard_file);
           
    }    
 
 }
 
 
uint8_t dummy_file_create_delete()                                              // create dummy file , write , read and delete    
{
    uint8_t dummy_write[5] = {0};
    uint8_t dummy_read[5] = {0};
    uint8_t i = 0;
    for(i=0; i<5; i++)
    {
        dummy_write[i] = i+i;
    }
    fp = fopen("/sd/dummy_file.txt","w");
    fwrite(&dummy_write, sizeof(uint8_t),5,fp);
    fclose(fp); 
    fp = fopen("/sd/dummy_file.txt","r");
    rewind(fp);
    fread(&dummy_read,sizeof(uint8_t),5,fp);
  for(i=0; i<5; i++)
    {
  
        if (dummy_read[i] != dummy_write[i])
        {
            fclose(fp); 
            remove("/sd/dummy_file.txt");
            return 1;
        }           
          
    }
    
    
    
    fclose(fp); 
    remove("/sd/dummy_file.txt");
    return 0;  
}     
              
      
    