#include "mbed.h"
#include "display_modules.h"
#include "touch_modules.h"
#include "ecg_dec.h"
#include "touch_modules.h"
#include "glc.h"
#include "bp.h"
#include "sdcard.h"
#include "eeprom_pgm.h"
#include "struct.h"
#include "battery.h" 
#include "main.h"
#include "SDFileSystem.h"

#define TIMER_RXACK_BTCONNECTION                10000
#define BATTERY_TIMER_VALUE                     600000
#define BATTERY_SCREEN_NO_CHARGE_CONDITION      3
#define TIMER_ENTER_DEBUG_MODE                  10000
#define WAIT_300MS                              300


SDFileSystem sd(PTE1, PTE3, PTE2, PTE4, "sd");

DigitalIn q1(PTB11);
DigitalIn q(PTC5);
DigitalIn q3(PTC12);
DigitalIn BT(PTA5);   


Serial serial_output(USBTX, USBRX);                                             //  serial port declaration for debug statements
Serial blue1(PTC4,PTC3);                                                        //  serial port declaration for bluetooth
Timer timer_bt;                                                                 // timer declaration for bluetooth 
Timer timer_battery;                                                            // timer declaration for battery
Timer timer_debug;                                                              // timer declaration for entering the debug mode 

static void battery_status_monitoring(void);                                    //  function to get battery status condition
uint32_t get_timer_bluetooth(void);                                             //  function to get time for bluetooth connection
uint8_t touch(uint8_t state);                                                   //  function for touch state
uint8_t display(uint8_t state1);                                                //  function for display state
void debug_status_monitoring(void);                                             //  function to monitor debug status
void sd_card_status(void); 

                                                
static bool file_created_status = false;                                        //  to get status of file creation false => file not created , true => file created
static uint32_t filepid_btpid[2] = {0};
                                                              // timer for entering the debug mode   
static bool debug_mode=false;                                                   // holds the status of the debug mode "1" indicates the device is in debug mode 
char debug_message_rx[6] = {0};                                                       // buffer to receive the debug message data
char debug_message[6]={"debug"};                                                //debug message to be received
                                                  // debug status monitoring
static uint32_t pid = 0;                                                        // patient ID    
static uint8_t device_id = 0;                                                   //static variable to store device id
bool device_error = false;                                                      // device error is true when there is database error

int main()
{
    static uint8_t main_state=1;
    static uint8_t state_display = 0;
    static uint8_t state_touch = 1;
    uint8_t state_t = 1;                                                        // state to transmit to bluetooth
    uint8_t state_r = 0;                                                        // state to receive from bluetooth
    
    DisableTouch();
    serial_output.baud(SERIAL_BAUD_RATE);
    blue1.baud(SERIAL_BAUD_RATE);
    init_screen();                                                              //initialize lcd 
    screen_main();                                                              // display of main screen
    sd.disk_initialize();                                                       //initialize sd card
    sd_card_status();                                                           //check for sd card initialization                                                                                                                     
    battery_monitor();                                                          // monitor battery at the start only
    battery_status_display();                                                   // display of main screen
    timer_battery.start();
    timer_debug.start();
    serial_output.printf("enter message to go into debug mode\n");
    read_device_id();                                                           // read the device id
    pid = get_filepid() + 1;                                                    // read patient id  
   while(1)
   {
    
        if (read_debug_status() == false)                                            // checking the debug_mode status
        {   
            if(timer_debug.read_ms()<TIMER_ENTER_DEBUG_MODE)
            {
                debug_status_monitoring();
            }
        }   
      
        
        battery_status_monitoring();                                            // to  monitior battery status after every 10 min. 

        if ((get_battery_status() == BATTERY_SCREEN_NO_CHARGE_CONDITION) || (device_error == true))         // to check battery status and take action // checking also for error
        {        
                 DisableTouch();
        }
        else
        {

            EnableTouch();
             
            switch(main_state)                                                  // main state machine
             {
                case 1:  
                         state_display = touch(state_touch);                    // touch state 
                         if(state_display == 12)
                         {
                            main_state = 3;
                         }
                          else if (state_display == 10)                         //  touch detection state for failed condition
                         {
                            main_state = 1;
                         }
                        else 
                         {
                            main_state = 2;
                         }
                        break;
    
                case 2:    
                         state_touch = display(state_display);                      //display state
                         main_state = 1;
                        break;
                
                
                case 3: 
                        DisableTouch();                                             // bluetooth send 
                        timer_bt.start();
                         if(get_timer_bluetooth()<TIMER_RXACK_BTCONNECTION)                           // bluetooth connection timer 15 sec
                         {
                        
                            if(BT==1)                                                    // checking for bluetooth connection
                            {
                    
                               timer_bt.stop();                                        // stop the timer once connected to app
                               timer_bt.reset(); 
                               BT_connection() ;                                // displaying connection on bluetooth 
                               state_r=bt_send(state_t);
                               timer_bt.start();
                                //gc.printf(" state_t = %d\n", state_t);
                                // gc.printf(" state_r = %d\n", state_r);   
                                if (state_r==0)                                  // if the state received is zero, then there is no new file to send
                                    {
                                        timer_bt.stop();                           // stop the timer once connected to app
                                        timer_bt.reset();
                                        BT_finished();                         // screen to display communication finished
                                        screen_BT_return();                    //screen to return back
                                        EnableTouch();
                                        main_state=1;
                                        state_touch=12;
                                        break;
                                     }
                                   
                                else 
                                    {
                                        main_state = 4;                         // move to receving stste of bluetooth
                                    }
                          
                            }  
                  
                            else   
                            {
                             BT_no_connection();                                // display screen to show that there is no connection
                            }
                         }

                        else
                        {                                   
                             BT_no_connection();                                // display screen to show that there is no connection
                            serial_output.printf("stopped");
                            screen_BT_return();                                 // button to return
                            EnableTouch();
                            main_state=1;
                            state_touch=12; 
                            timer_bt.stop();
                            timer_bt.reset();
                        }
                        break;
                 
                case 4: 
                        DisableTouch();  
            
                        if(get_timer_bluetooth()<TIMER_RXACK_BTCONNECTION)
                        {
                            if (blue1.readable())                               // if there is data to receive enter the loop
                            {
                               
                                state_t=bt_receive(state_r);
                               //  serial_output.printf(" state_t = %d\n", state_t);
                                // serial_output.printf(" state_r = %d\n", state_r);
                                timer_bt.stop();
                                timer_bt.reset();
                                if(state_t ==0)                                 // if state_t is zero, there is no other file to send
                                {
                                  
                                    BT_finished();
                                    screen_BT_return();  
                                    EnableTouch();
                                    main_state=1;
                                    state_touch=12;                             // jumping to touch case 12
                                    break;
                                } 
                                else                                            // move to bluetooth transmit if the states are 1,2,3,4
                                {
                                    main_state=3;
                                }  
                            }
                        }                 
                        else 
                        {    
                            DisableTouch();
                            BT_no_connection();                                 // display screen to show that there is no connection
                            serial_output.printf("stopped");
                            screen_BT_return();                                 // button to return
                            EnableTouch();
                            main_state=1;
                            state_touch=12;
                            state_t = 1;                                        // state to transmit to bluetooth
                            state_r = 0;                                        // state to receive from bluetooth
                            sd_close();                                         //close the opened file which was used for bluetooth
                            timer_bt.stop();
                            timer_bt.reset();
                        }
                        break;      
             }         
        }        
   } 

}
uint8_t touch(uint8_t state)
{
   static  uint8_t state1=0;
   detect_touch(state);                                                         // determine the touch points
    
    switch(state)                                                               // state for touch
    {
      case 1:   
                state1=touch_main();                                            // determining the touch for main screen 
                state=0;
               // nstate1=state1;
                break;
               
      case 2: 
                state1=touch_main_1();                                          // determining the touch for SYSTEM CONFIGURATION screen 
                state=0;
                //nstate1=state1;
                break;
                
      case 3:  
                state1=touch_main_2();                                          // determining the touch for TEST screen                 
                state=0;
                //nstate1=state1;
                break;
        
      case 4: 
                state1=touch_glc();                                             // determining the touch for GLC screen 
                state=0;
                ///nstate1=state1;
                break;       
        
      case 5: 
                state1=touch_ecg();                                             // determining the touch for ECG screen 
                state=0;
                //nstate1=state1;
                 break;   
     case 6: 
                state1=touch_ret();                                             // determining the touch for returning back to the main screen      
                state=0;
                //nstate1=state1;
                break;
                
     case 7: 
                state1=touch_again_ecg();                                       // determining the touch when readings are taken more than once screen 
                state=0;
                //nstate1=state1;
                break;
                
     case 8:    
                state1=touch_bp();                                              // determining the touch for BP screen 
                state=0;
                //nstate1=state1;
                break;           
                
     case 9:    
                state1=touch_again_glc();  
                state=0;
                //nstate1=state1;
                break;            
                
     case 10 :  
                DisableTouch();
                wait_ms(WAIT_300MS);
                EnableTouch();
                //state=nstate;
                break;
                  
                  
      case 11:   
                state1=touch_again_bp();            
                state=0;
                //nstate1=state1;
                break;
      
      case 12:   
                state1=BT_return();            
                state=0;
                //nstate1=state1;
                break;
         
      case 13:  
                state1 = touch_debug();                                         //touch state for debug
                //state=0;
               // nstate1=state1;
                break;  
     default :  
                DisableTouch();
                wait_ms(WAIT_300MS);
                EnableTouch();
               // state=nstate;
                break;          
                          
    }         
     
    return state1;
}
  
  
uint8_t display(uint8_t state1)
{
    static uint8_t state=0;
    static uint8_t ecg_flag=0;                                                  // ecg_flag to indicate the ecg test is already done for the same pid
    static uint8_t glc_flag=0;                                                  // glc_flag to indicate the glc test is already done for the same pid
    uint16_t heart_rate=0; 
    
    switch(state1)                                                              // state for display screens
    {

      
      case 1: 
                DisableTouch();
                screen_main();                                                  //  main screen 
                state1=0;
                state=1;
                //nstate=state;
                ecg_flag=0;                                                     // ecg, glc flag to determine whether the readings are taken more than once
                glc_flag=0;
                clear_filecreated_status();
                battery_status_display();                                       //Display battery status on LCD
                pid = get_filepid() + 1;
                EnableTouch();
                break;
      
      case 2: 
                DisableTouch();
                screen_main_1();                                                // System configration screen 
                state1=0;
                state=2;
                //nstate=state;
                battery_status_display();                                       //Display battery status on LCD
                EnableTouch();
                break;
               
      case 3: 
                DisableTouch();
                serial_output.printf("pidinit=%d",pid);
                screen_main_2(pid);     
                state1=0;
                state=3;
                //nstate=state;
                battery_status_display(); 
                EnableTouch();
                break;
                
      case 4: 
                DisableTouch();
                if (glc_flag==1)                                                // glc_flag=1 when already the reading has been taken 
                {
                    screen_again();    
                    state1=0;
                    state=9;
                  //  nstate=state;
                }
                else
                { 
                    screen_glc();                                               // glc screen
                    state1=0;
                    state=4;
                    //nstate=state;
                }
                EnableTouch();
                
                break;
     
     
     case 5:     
                DisableTouch();
                if (ecg_flag==1)
                {
                    screen_again();
                    state1=0;
                    state=7;
                    //nstate=state;
                }
                
                else
                {   
                    screen_ecg();                                               //ecg main screen 
                    state1=0;
                    state=5;
                   // nstate=state;
                }
                EnableTouch();
                break;
     
     case 6:   
                DisableTouch();
                screen_bp();                                                    // bp main screen
                state1=0;
                state=8;
               // nstate=state;         
                EnableTouch();        
                break;
     
     case 7:    
                DisableTouch();     
                glc(pid);                                                       // glc measurement
                glc_flag=1;
                state1=0;
                screen_glc_2();
                state=6;
                eprom_write_8(30,0);
               // nstate=state;        
                EnableTouch();
                break;
    
    case 8:     DisableTouch();
                ecg_countdown();                                                // countdown before ecg capture
                heart_rate = ecg(pid);                                          // capturing ecg
                state1 = 0;
                if (heart_rate == 0)
                {
                    screen_ecg_lead();  
                }
                else if(heart_rate == 1)                                          // if heart rate goes above or below range display error // 10/7/17 nikita
                {
                    screen_ecg_error();
                }      
                else 
                {
                    screen_ecg_2(heart_rate);
                    ecg_flag = 1;
                }                            
                state = 6;
                eprom_write_8(30,1);
               // nstate = state;
                screen_ecg_bp();
                EnableTouch();
                break;
             
      case 9: 
                DisableTouch();
                //screen_bp2();                                                 // bp main screen
                bp_countdown();                                                 // countdown for bp 
                bp(pid);                                                        // measuring bp   earlier bp() changed to bp(pid) 28/4/2017
                state1=0;
                state=6;
                eprom_write_8(30,2);
               // nstate=state;
                EnableTouch();
                break;
 
                          
      case 10 :  
                DisableTouch();
                wait_ms(WAIT_300MS);
                EnableTouch();
               // state=nstate;
                break;        
                  
      case 11 :    
                DisableTouch();
                screen_patient_info(get_filepid(), get_btpid());
                state1=0;
                state=12;
                EnableTouch();
                break;  
                         
      case 13 :                                                                 //display screen for debug
                DisableTouch();
                screen_debug();
                state1=0;
                state=13;
                //nstate=state;
                EnableTouch();
                break; 
                   
      case 14 :    
                DisableTouch();                                                 //state to delete SD card
                delete_sdcard();
                screen_sdcard_delete();
                state1=0;
                state= 12;
               // nstate=state;
                EnableTouch();
                break;   
                
        case 15 :    
                DisableTouch();
                serial_output.printf("Total Patients' data available : %d\n",get_filepid());                                        //state to read SD card
                serial_output.printf("Enter the PID number");
                read_sdcard_file();
                screen_sdcard_read();
                state1=0;
                state= 12;
                //nstate=state;
                EnableTouch();
                break;                            
       
        default :  
                  
                  //state1=nstate1;
                   break;          
                            
            
    }                      
    return state;       
                
}


bool get_filecreated_status(void)                                               //function to get file created status
{
    return file_created_status;
}

void set_filecreated_status(void)                                               //function to set file created status
{
    file_created_status = true;
}


void clear_filecreated_status(void)                                             //function to clear file created status
{
    file_created_status = false;
}

void increment_filepid (void)                                                   //increment pid if a test is completed
{
    sd_read(filepid_btpid);                                                     //read pid from sd card
    filepid_btpid[0] = filepid_btpid[0] + 1;                                    //increment it by 1
    sd_write_pid(filepid_btpid);                                                    //write it back to sd card
    
} 

void increment_btpid (void)                                                     //increment pid if a test is completed
{
    sd_read(filepid_btpid);                                                     //read pid from sd card
    filepid_btpid[1] = filepid_btpid[1] + 1;                                    //increment it by 1
    sd_write_pid(filepid_btpid);                                                    //write it back to sd card
    
} 

uint32_t get_filepid(void)
{ 
    uint32_t filepid = 0;    
    
    sd_read(filepid_btpid);                                                     //read pid from sd card
    filepid = filepid_btpid[0];                                  
    return filepid; 
    
}   

void store_filepid(uint32_t pid)
{ 
    sd_read(filepid_btpid);                                                     //read pid from sd card
    filepid_btpid[0] = pid;                                              
    sd_write_pid(filepid_btpid);                                                    //write it back to sd card
                                                        
} 

uint32_t get_btpid(void)
{
   
    uint32_t btpid = 0;    
    
    sd_read(filepid_btpid);                                                     //read pid from sd card
    btpid = filepid_btpid[1];                                  
    return btpid; 
    
}   

void store_btpid(uint32_t bt_pid)
{  
    sd_read(filepid_btpid);                                                     //read pid from sd card
    filepid_btpid[1] = bt_pid;                                              
    sd_write_pid(filepid_btpid);                                                    //write it back to sd card
                                                        
} 


uint32_t get_timer_bluetooth()
{
  return  timer_bt.read_ms(); 
} 

void battery_status_monitoring()
{
    if(timer_battery.read_ms() > BATTERY_TIMER_VALUE ) 
    {
        battery_monitor();
        timer_battery.reset();
    }
}

bool read_debug_status()
{
   // serial_output.printf("debug_mode=%d\n",debug_mode); 
    return debug_mode;
}

void debug_status_monitoring()
{
    if (serial_output.readable())                                               // check for the user input
    {   
        while (serial_output.readable()!= '\n')                                 // read till the newline
        { 
            serial_output.scanf("%s", debug_message_rx);                        // store the message typed in buffer
            serial_output.printf("%s", debug_message_rx);
            break;
        }         
        if (strcmp(debug_message_rx, debug_message) == 0)                       // compare the message with the required one
        {
            debug_mode = true;                                                  // enable the debug mode status
            serial_output.printf("entered into debug mode\n");
            timer_debug.reset();
            timer_debug.start();                                                // timer is started in orede
        } 
    }          
}  
    
uint32_t get_timer_debug()                                                      // timer for enabling debug option
{
    if(timer_debug.read_ms()>TIMER_ENABLE_DEBUG_MODE)
    {
        timer_debug.stop();
    }
    return  timer_debug.read_ms(); 
}


void read_device_id()                                                           // reading device id from eeprom
{
    
    device_id =  eprom_read_8(12);                                              // reading from eeprom location 
    serial_output.printf("device_id = %d\n", device_id);                                                      //read did from eeprom
    if((get_Error()!= 0) || (device_id == 0xFF))                                // checking for error                               
    {
            device_id = eprom_read_8(12) ; 
         if(get_Error()!= 0  || (device_id == 0xFF))  
            {
                serial_output.printf("database error!\n");                                 // database error
                database_error();
                device_error = true;
            }
    }
     
}

uint8_t get_did()                                                               //reading the device id
{
    return  device_id;
}


void sd_card_status()                                                           // checking the status of the sd card initialization
{
 uint8_t error_disk_status = 0;
 uint8_t error_disk_init = 0;
 error_disk_init  = sd.disk_status();                                           //check for initialization bit
 
 if(error_disk_init == 0)
 {
      
    error_disk_status  = dummy_file_create_delete();                             // creating the dummy file

     if( error_disk_status  == 1)                                                // if error = 1 // error in opening file 
    {
       error_disk_status  = dummy_file_create_delete(); 
        if( error_disk_status  == 1)
            {
                serial_output.printf("database error!\n");                                 // dispaly data base error
                database_error();
                device_error = true;
              
            }
    }
 }  
 
 else
 {
    serial_output.printf("database error!\n");                                             // dispaly data base error
    database_error();
    device_error = true;
    
  }  
 
} 
 