#include "mbed.h"
#include "ec_bp.h"

SPI mySpi(PIN_MOSI, PIN_MISO, PIN_SCLK) ;
DigitalIn DRDY_BAR(PTC8);
 
DigitalOut CHIPSEL_BAR(PTD0);
DigitalOut ADS_START(PTC16);
DigitalOut RESET_BAR(PTC17);
DigitalOut myled(LED1);
PwmOut led(PTB18);

 uint8_t value = 0;                                                             // datatype changed from float to uint8_t nikita 
 uint8_t value1 = 0;
 uint8_t value2 = 0;
 uint8_t value3 = 0;
 uint8_t value4 = 0;
 uint8_t value5 = 0;
 uint8_t value6 = 0;
 uint8_t data1 = 0;

 /* SPI is the spi function written in mbed and mySpi is the instance name*/

typedef void (*func_ptr)(void) ; /*creates typedef to function pointer, does not take any arguement and returns void*/


typedef struct _cmd_func 
{
    char *name ;
    func_ptr func ;
} cmd_func_type ;

cmd_func_type cmd_list[] = {   /*"cmd_func_type cmd_list[]" is same as "struct cmd_list[]"*/
    {"help", doHelp},
    {"status", doStatus},
    {"freq", doFreq},
    {"mode", doMode},
    {"bit",  doBit},
    {"write", doWrite},
    {"read",  doRead},
    {"loop", doLoop},
    { 0, 0 }
} ;

func_ptr getFunc(char *cmd)  /*here "func_ptr is same as void*/
{
    uint8_t i = 0 ;                                                              // datatype changed from int to uint8_t nikita 
    while(cmd_list[i].name != 0) 
    {
        if (strcmp(cmd, cmd_list[i].name) == 0)
        {
            return(cmd_list[i].func) ; ;
        }
        i++ ;
    }
    return(0) ;
}

void doHello()
{
    printf("=== spi test program ===\n\r") ;
    printf("please set your terminal program\n\r") ;
    printf("local echo on\n\r") ;
    printf("\n\r") ; 
}


void setup()
{
   //initially make all inputs low until power is up and stabilized
    CHIPSEL_BAR = 0;
    ADS_START = 0;
    RESET_BAR = 0;
    //wait for oscillator to wake up
    wait(1);     
    
    CHIPSEL_BAR = 1;
    RESET_BAR = 1; //wait for tpor time
    //wait for power on reset
    wait(1);
    RESET_BAR = 0; // send a reset pulse and wait for t_reset amount of time
    wait(1);
    RESET_BAR = 1;//release the reset
    //Wait for 18 tclks = 36 us
    wait_us(36);
    
    //Device wakes up in RDATAC mode so send SDATAC command to write to registers
    cmdWrite(CMD_SDATAC) ;
//    printf("Device is in SDATAC mode\n");
    
    regRead(REG_ID);
    printf("DEVICE ID register read from ADS is= 0x%X\n",data1);  
    wait(1);
    
    //Since we are using internal 2.42V reference and enable clock on the CLK PIN
    //Write 0xA8 to CONFIG2 register
    regWrite(REG_CONFIG2,NO_MODE);
       
    //Set continuous sampling mode, 500 SPS
    regWrite(REG_CONFIG1,SPS500);
        
    //PGA Gain = 6, inputs shorted for noise measurements
    regWrite(REG_CH1SET, OFFSET_MEASURE);
    
    //read data from CONFIG2 register
    regRead(REG_CONFIG2);
//    printf("REG_CONFIG2 register read from ADS for initial setup is= 0x%X\n",data1);
    
    //read data from CONFIG1 register
    regRead(REG_CONFIG1);
//    printf("REG_CONFIG1 register read from ADS for initial setup is= 0x%X\n",data1);
    
    //read data from CONFIG1 register
    regRead(REG_CH1SET);
//    printf("REG_CH1SET register read from ADS for initial setup is= 0x%X\n",data1);
}   

void testsetup()
{
 //Send SDATAC command to write to registers to set test signals 
    cmdWrite(CMD_SDATAC) ;
    printf("Device is in SDATAC mode\n");
            
    //Since we are using internal 2.42V reference and enable clock on the CLK PIN
    //Write 0xA3 to CONFIG2 register to set test signal and its freq = 1Hz
    regWrite(REG_CONFIG2,TEST_MODE);
       
    //PGA Gain = 6, test signal selected
    regWrite(REG_CH1SET, TEST_INPUT);
    
    //read data from CONFIG2 register
    regRead(REG_CONFIG2);
    printf("REG_CONFIG2 register read from ADS for test signal setup is= 0x%X\n",data1);
    
    //read data from CONFIG1 register
    regRead(REG_CH1SET);
    printf("REG_CH1SET register read from ADS for test signal setup is= 0x%X\n",data1);  
}

void ecgsetup()
{
    cmdWrite(CMD_SDATAC) ; //Set to SDATAC mode to set CH1SET register
    
    regWrite(REG_CONFIG1,SPS500);
    regWrite(REG_CONFIG2, DEFAULT_MODE);//put INT_TEST and TEST_FREQ bits to default mode(set those bits to '0')
    regWrite(REG_LOFF, LEAD_OFF_CONFG);
    regWrite(REG_CH1SET, ELECTRODE_INPUT);// Set to read normal electrode input
    regWrite(REG_RLD_SENS, RLD_SENSE_SIG);//Set RLD_SENS
    regWrite(REG_LOFF_SENS, LOFF_SENSE_SIG);//Set LOFF_SENS
    regWrite(REG_MISC1, MISC1_INPUT );//Set RESP1
    regWrite(REG_MISC2, MISC2_INPUT );//Set RESP2
    //printf("connect ECG leads\n");
    wait(0.5);
    regRead(REG_LOFF_STAT);//Read LOFF_STAT register
    printf("REG_LOFF_STAT register read from ADS for ecg setup is= 0x%X\n",data1); 

}

void doHelp(void) 
{
    printf("=== spi test ===\n\r") ;
    printf("commands available\n\r") ;
    printf("help\n\r") ;
    printf("status\n\r") ;
    printf("freq freq_in_hz\n\r") ;
    printf("mode (0 | 1 | 2 | 3)\n\r") ;
    printf("bit (4 - 16)\n\r") ;
    printf("write value\n\r") ;
    printf("read\n\r") ;
    printf("loop number (set repeat number for read/write)\n\r") ;
}

void doStatus(void)
{
    printf("=== Status Report ===\n\r") ;
    printf("bits: %d\n\r", ECG_SPI_BITS) ;
    printf("mode: %d\n\r", ECG_SPI_MODE) ;
    printf("SPI_FREQUENCY: %d Hz\n\r", ECG_SPI_FREQUENCY) ;
    printf("loop: %d\n\r", ECG_SPI_LOOP) ;
}

void doFreq(void)
{
    printf("setting frequency to %d\n\r", ECG_SPI_FREQUENCY) ;
    mySpi.frequency(ECG_SPI_FREQUENCY) ;
}

void doMode(void)
{
    printf("setting format(%d, %d)\n\r",ECG_SPI_BITS, ECG_SPI_MODE) ;
    mySpi.format(ECG_SPI_BITS, ECG_SPI_MODE) ;       
}

void doBit(void) 
{
    printf("setting format(%d, %d)\n\r",ECG_SPI_BITS, ECG_SPI_MODE) ;
    mySpi.format(ECG_SPI_BITS, ECG_SPI_MODE) ;
}

void doWrite(void) 
{    
    CHIPSEL_BAR = 0;
    value1 =  mySpi.write(0x00);
    value2 =  mySpi.write(0x00);
    value3 =  mySpi.write(0x00);
    value4 =  mySpi.write(0x00);
    value5 =  mySpi.write(0x00);
    value6 =  mySpi.write(0x00);
    
    CHIPSEL_BAR = 0;    
}

void doRead(void) 
{
    uint8_t dummy = 0 ;                                                          // datatype changed from int to uint8_t nikita 
    
    while(!DRDY_BAR)
        ADS_START = 0;
    
    value = mySpi.write(dummy) ;
         
}

void doLoop(void)
{
   
    printf("repeat number has been set to %d\n\r", ECG_SPI_LOOP) ;
}

void cmdWrite(uint8_t data)                                                     // datatype changed from int to uint8_t nikita  
{
    CHIPSEL_BAR = 0;
    mySpi.write(data) ;
    wait_ms(1);
    CHIPSEL_BAR = 1;  
}

void regWrite(uint8_t address, uint8_t data)                                    // datatype changed from int to uint8_t nikita  
{
    uint8_t data_to_send = CMD_WREG << 5;                                       // datatype changed from int to uint8_t nikita 
    data_to_send = data_to_send | address;
    CHIPSEL_BAR = 0;
    mySpi.write(data_to_send);
    wait_ms(1);
    mySpi.write(0x00) ;
    wait_ms(1);
    mySpi.write(data) ;
    wait_ms(1);
    CHIPSEL_BAR = 1;  
}

void regRead(uint8_t address)                                                   // datatype changed from int to uint8_t nikita 
{
    uint8_t data_to_receive = CMD_RREG << 5;                                    // datatype changed from int to uint8_t nikita 
    data_to_receive = data_to_receive | address;
    CHIPSEL_BAR = 0;
    mySpi.write(data_to_receive);
    wait_ms(1);
    mySpi.write(0x00) ;
    wait_ms(1);
    data1 = mySpi.write(0x00) ;
    CHIPSEL_BAR = 1;       
}

void freqset()
{
    mySpi.frequency(ECG_SPI_FREQUENCY) ;
    mySpi.format(ECG_SPI_BITS, ECG_SPI_MODE) ; 
}
    
void setupfunc()
{   
    setup() ;  
    cmdWrite(CMD_RDATAC) ;
    ADS_START = 1;
} 
  
uint8_t ecgsetupfunc()
{ 
    ecgsetup();   // To set the ADS1291 registers for ECG signal generation
    cmdWrite(CMD_RDATAC) ;
    ADS_START = 1; 
    return data1;            // returns lead off reg value // 14/06
}
  
void ecgtestsetupfunc()
{ 
    testsetup();   // To set the ADS1291 registers for ECG signal generation
    cmdWrite(CMD_RDATAC) ;
    ADS_START = 1; 
  
} 
uint32_t readvalue()
{
    uint32_t concatenate_value = 0;
    while(DRDY_BAR);
    doWrite() ;
    concatenate_value = ((value4<< 16)|(value5 <<8) |(value6));
    
    return  concatenate_value;
}
  