#include "mbed.h"
#include "ec_bp.h"
//#include "ecg_dec.h"

//PIN DECLARATIONS
//Serial pc(USBTX,USBRX);
SPI mySpi(PIN_MOSI, PIN_MISO, PIN_SCLK) ;
DigitalIn DRDY_BAR(PTC8);
 
DigitalOut CHIPSEL_BAR(PTD0);
DigitalOut ADS_START(PTC16);
DigitalOut RESET_BAR(PTC17);
DigitalOut myled(LED1);
PwmOut led(PTB18);
 float value = 0;
 unsigned int value1;
 unsigned int value2;
 unsigned int value3;
 unsigned int value4;
 unsigned int value5;
 unsigned int value6;
 uint8_t data1;
 unsigned int count;

//unsigned char chk2= 0;
//float value = 0;
/*unsigned int value1 = 0;
unsigned int value2 = 0;
unsigned int value3 = 0;
unsigned int value4 = 0;
unsigned int value5 = 0;
unsigned int value6 = 0;
unsigned int data1 = 0;
unsigned int count = 0;*/

//static int32_t ecg_x[500];
 /* SPI is the spi function written in mbed and mySpi is the instance name*/

typedef void (*func_ptr)(void) ; /*creates typedef to function pointer, does not take any arguement and returns void*/


void lpf_coef(void);
float lpf( float coeff[5], float);
void drdy_int(void);
/*FILE *sd_openfile(char *buf);
void sd_write (FILE *n,int value);
void sd_close(FILE *n);
time_t rtc_read();*/

typedef struct _cmd_func {
    char *name ;
    func_ptr func ;
} cmd_func_type ;

cmd_func_type cmd_list[] = {   /*"cmd_func_type cmd_list[]" is same as "struct cmd_list[]"*/
    {"help", doHelp},
    {"status", doStatus},
    {"freq", doFreq},
    {"mode", doMode},
    {"bit",  doBit},
    {"write", doWrite},
    {"read",  doRead},
    {"loop", doLoop},
    { 0, 0 }
} ;

func_ptr getFunc(char *cmd)  /*here "func_ptr is same as void*/
{
    int i = 0 ;
    while(cmd_list[i].name != 0) {
        if (strcmp(cmd, cmd_list[i].name) == 0) {
            return(cmd_list[i].func) ; ;
        }
        i++ ;
    }
    return(0) ;
}

void doHello()
{
    printf("=== spi test program ===\n\r") ;
    printf("please set your terminal program\n\r") ;
    printf("local echo on\n\r") ;
    printf("\n\r") ; 
}


void setup()
{
   //initially make all inputs low until power is up and stabilized
    CHIPSEL_BAR = 0;
    ADS_START = 0;
    RESET_BAR = 0;
    //wait for oscillator to wake up
    wait(1);     
    
    CHIPSEL_BAR = 1;
    RESET_BAR = 1; //wait for tpor time
    //wait for power on reset
    wait(1);
    RESET_BAR = 0; // send a reset pulse and wait for t_reset amount of time
    wait(1);
    RESET_BAR = 1;//release the reset
    //Wait for 18 tclks = 36 us
    wait_us(36);
    
    //Device wakes up in RDATAC mode so send SDATAC command to write to registers
    cmdWrite(CMD_SDATAC) ;
//    printf("Device is in SDATAC mode\n");
    
    regRead(REG_ID);
    printf("DEVICE ID register read from ADS is= 0x%X\n",data1);  
    wait(1);
    
    //Since we are using internal 2.42V reference and enable clock on the CLK PIN
    //Write 0xA8 to CONFIG2 register
    regWrite(REG_CONFIG2,no_mode);
       
    //Set continuous sampling mode, 500 SPS
    regWrite(REG_CONFIG1,sps500);
        
    //PGA Gain = 6, inputs shorted for noise measurements
    regWrite(REG_CH1SET, offset_meas);
    
    //read data from CONFIG2 register
    regRead(REG_CONFIG2);
//    printf("REG_CONFIG2 register read from ADS for initial setup is= 0x%X\n",data1);
    
    //read data from CONFIG1 register
    regRead(REG_CONFIG1);
//    printf("REG_CONFIG1 register read from ADS for initial setup is= 0x%X\n",data1);
    
    //read data from CONFIG1 register
    regRead(REG_CH1SET);
//    printf("REG_CH1SET register read from ADS for initial setup is= 0x%X\n",data1);
}   

void testsetup()
{
 //Send SDATAC command to write to registers to set test signals 
    cmdWrite(CMD_SDATAC) ;
    printf("Device is in SDATAC mode\n");
            
    //Since we are using internal 2.42V reference and enable clock on the CLK PIN
    //Write 0xA3 to CONFIG2 register to set test signal and its freq = 1Hz
    regWrite(REG_CONFIG2,test_mode);
       
    //PGA Gain = 6, test signal selected
    regWrite(REG_CH1SET, test_inp);
    
    //read data from CONFIG2 register
    regRead(REG_CONFIG2);
   printf("REG_CONFIG2 register read from ADS for test signal setup is= 0x%X\n",data1);
    
    //read data from CONFIG1 register
    regRead(REG_CH1SET);
   printf("REG_CH1SET register read from ADS for test signal setup is= 0x%X\n",data1);  
}

void ecgsetup()
{
cmdWrite(CMD_SDATAC) ; //Set to SDATAC mode to set CH1SET register

regWrite(REG_CONFIG1,sps500);
regWrite(REG_CONFIG2, default_mode);//put INT_TEST and TEST_FREQ bits to default mode(set those bits to '0')
regWrite(REG_LOFF, loff_conf);
regWrite(REG_CH1SET, elec_inp);// Set to read normal electrode input
regWrite(REG_RLD_SENS, rld_sens_sig);//Set RLD_SENS
regWrite(REG_LOFF_SENS, loff_sens_sig);//Set LOFF_SENS
regWrite(REG_MISC1, misc1_inp );//Set RESP1
regWrite(REG_MISC2, misc2_inp );//Set RESP2
//printf("connect ECG leads\n");
wait(0.5);
regRead(REG_LOFF_STAT);//Read LOFF_STAT register
printf("REG_LOFF_STAT register read from ADS for ecg setup is= 0x%X\n",data1); 

}

void doHelp(void) 
{
    printf("=== spi test ===\n\r") ;
    printf("commands available\n\r") ;
    printf("help\n\r") ;
    printf("status\n\r") ;
    printf("freq freq_in_hz\n\r") ;
    printf("mode (0 | 1 | 2 | 3)\n\r") ;
    printf("bit (4 - 16)\n\r") ;
    printf("write value\n\r") ;
    printf("read\n\r") ;
    printf("loop number (set repeat number for read/write)\n\r") ;
}

void doStatus(void)
{
    printf("=== Status Report ===\n\r") ;
    printf("bits: %d\n\r", bits) ;
    printf("mode: %d\n\r", mode) ;
    printf("freq: %d Hz\n\r", freq) ;
    printf("loop: %d\n\r", loop) ;
}

void doFreq(void)
{
  //  int freq = 0 ;
   // scanf("%d", &freq) ;
    printf("setting frequency to %d\n\r", freq) ;
    mySpi.frequency(freq) ;
}

void doMode(void)
{
    //scanf("%d", &mode) ;
    printf("setting format(%d, %d)\n\r",bits, mode) ;
    mySpi.format(bits, mode) ;       
}

void doBit(void) 
{
   // scanf("%d", &bits) ;
    printf("setting format(%d, %d)\n\r",bits, mode) ;
    mySpi.format(bits, mode) ;
}

void doWrite(void) 
{    
       
     //DRDY_BAR1.disable_irq();
      
        CHIPSEL_BAR = 0;
       // int freq1 = 50000;
       // mySpi.frequency(freq1) ;
        value1 =  mySpi.write(0x00);
        value2 =  mySpi.write(0x00);
        value3 =  mySpi.write(0x00);
        value4 =  mySpi.write(0x00);
        value5 =  mySpi.write(0x00);
        value6 =  mySpi.write(0x00);
      
        CHIPSEL_BAR = 0;    
        //DRDY_BAR1.enable_irq();
}

void doRead(void) 
{
    int dummy = 0 ;
   
    while(!DRDY_BAR)
    ADS_START = 0;
    
        value = mySpi.write(dummy) ;
         
}

void doLoop(void)
{
   // scanf("%d", &loop) ;
    printf("repeat number has been set to %d\n\r", loop) ;
}

void cmdWrite(int data) 
{
         CHIPSEL_BAR = 0;
         mySpi.write(data) ;
         wait_ms(1);
         CHIPSEL_BAR = 1;  
}

void regWrite(int address, int data) 
{
    int data_to_send = CMD_WREG << 5;
    data_to_send = data_to_send | address;
         CHIPSEL_BAR = 0;
         mySpi.write(data_to_send);
         wait_ms(1);
         mySpi.write(0x00) ;
         wait_ms(1);
         mySpi.write(data) ;
         wait_ms(1);
         CHIPSEL_BAR = 1;  
}

void regRead(int address)
{
    int data_to_receive = CMD_RREG << 5;
    data_to_receive = data_to_receive | address;
         CHIPSEL_BAR = 0;
         mySpi.write(data_to_receive);
         wait_ms(1);
         mySpi.write(0x00) ;
         wait_ms(1);
         data1 = mySpi.write(0x00) ;
                  
         //printf("DEVICE ID register read from ADS is= 0x%X\n",data1);
         
         //wait_ms(1);
         CHIPSEL_BAR = 1;       
}



void freqset()
{
mySpi.frequency(freq) ;
    mySpi.format(bits, mode) ; 
    }
    
    
    
 void setupfunc()
 {   
    setup() ;  
    cmdWrite(CMD_RDATAC) ;
    ADS_START = 1;
  } 
  
uint8_t ecgsetupfunc()
{ 
  // uint8_t lead=0;
   ecgsetup();   // To set the ADS1291 registers for ECG signal generation
   cmdWrite(CMD_RDATAC) ;
   ADS_START = 1; 
   return data1;            // returns lead off reg value // 14/06
  }
  
    void ecgtestsetupfunc()
{ 
   testsetup();   // To set the ADS1291 registers for ECG signal generation
   cmdWrite(CMD_RDATAC) ;
   ADS_START = 1; 
  
  } 
uint32_t readvalue()
  {
      uint32_t concatenate_value;
      while(DRDY_BAR);
    doWrite() ;
    concatenate_value = ((value4<< 16)|(value5 <<8) |(value6));
    
  return  concatenate_value;
  }
  
  
  
  
  