#include "mbed.h"
#include "sdcard.h"
#include "struct.h"
#include "eeprom_pgm.h"
#include "main.h"
 
#define ACK 0x00                                /// changed //16/06 #define all the values removing structure 
#define START_OF_FILE       0x01
#define END_OF_FILE         0x02
#define DATA_TRFR           0x03
#define NACK                0xFF
#define SOS                 0xc0
#define EOS                 0xc0
#define NO_OF_SAMPLES       600                   //changed the buffer size from 150- 22/7/17- suhasini
#define CHKSUM              0x80 
#define STRUCTURE_LENGTH    26
 
BLEMsg_info *bt_file;
Point *myBleMsg;
 
Serial mc(USBTX,USBRX);                  // serial terminal
Serial blue(PTC4,PTC3);                 // communicating bluetooth through serial 
                 
static uint32_t total_samples=0;              // variable to hold total number of samples
Point b;                               // structure copy
BLEMsg_info bt_file1;                  // structure copy
static uint32_t total_file_size=0;        // to determine the size of the file 
static uint32_t total_file_size_sent=0; 
static uint32_t file_start=0;           // variable for 'for loop'
//static uint32_t j=0;
uint8_t count_send=0; 
static uint32_t file_pointer_position=0;
static uint32_t counter=0;
static  uint32_t v1[NO_OF_SAMPLES];  
uint8_t file=0;
static uint32_t bt_pid = 0; 
 
uint8_t bt_send(uint8_t state_tx)
{
   
    blue.baud(115200);                  // baud rate of bluetooth
    bt_file=&bt_file1;                      
    myBleMsg=&b; 
    int8_t check_sum=0;
    uint8_t state_rx =0;
 
  switch(state_tx)
          {
 
       case 1:    
                  state_tx =0; 
                  counter=0;
                  total_file_size_sent=0; 
                  file_start=0;           
                  count_send=0;  total_samples=0;  
                  file_pointer_position=0;
                  bt_pid = get_btpid()+1;                           //added on 22/09/2017 nikita
                 mc.printf("bt_pid = %d\n",get_btpid());
                if(get_filepid()>=bt_pid)                           //check for pid and bluetooth pid by reading from file// modified to send till the current pid, 3rd nov// 
                {
                    send_initial_string(); 
                    blue.printf("\n"); 
                    file=sd_open_read(bt_pid);                         // open the file for reading
                    total_file_size=file_size();                           // determined the file size 
                    state_rx = 1;  
                }
                         
                else 
                {
                    state_rx =0;                                        //no files to send
                    mc.printf("no file to send\n");  
                }       
                break;
                         
                   
       case 2:   total_samples=0; 
                 //file=sd_open_read(get_btpid());  
                // total_file_size=file_size() ;                           // determined the file size 
                 sd_read1(bt_file1);                                    // read the sd card file
                 mc.printf("sd file opened to read data in it\n");
                 myBleMsg->bt_msg=bt_file1;                              //copy the contents to the structure
                 send_structure();                                       // send the structure string
                 blue.printf("\n");   
                 mc.printf("sent initial string\n");                    
                 total_samples= myBleMsg->bt_msg.num_samples.num_sample_ppg_dummy+myBleMsg->bt_msg.num_samples.num_sample_ecg_OTtyp;
                 state_tx =0;
                 state_rx =2;
                 count_send=0;
                 total_file_size_sent=file_size1();
                 break;                 
 
 
        case 3:    
                counter=0;
                if(count_send<(total_samples/NO_OF_SAMPLES))
                {
                    sd_read(v1,NO_OF_SAMPLES);      
                    counter=NO_OF_SAMPLES;               //read 1500 samples
                    send_data_str1(); 
                    for(file_start=0;file_start<(NO_OF_SAMPLES);file_start++)
                    {     
                       
                        blue.printf("%08x", v1[file_start]);
                           
                    }
                          
                    check_sum=checksum_rawdata((uint8_t *)v1,counter);               // calculating checksum            // calculating checksum
                    state_tx =0;
                    state_rx =3;
                    send_data_str2(check_sum);            // send the remaining part of the string
                  
                }
               
                else 
                {
                    for(uint16_t l=0;l<NO_OF_SAMPLES;l++)
                    {    
                        v1[l]=NULL;
                    }
                            counter=(total_samples-( NO_OF_SAMPLES*count_send));
                            send_data_str1();
                            sd_read(v1,(total_samples-( NO_OF_SAMPLES*count_send)));
                       
                        for(file_start=0;file_start<(total_samples-( NO_OF_SAMPLES*count_send));file_start++)
                          {     
                             blue.printf("%08x", v1[file_start]);
                            
                           }
                                                                   
                          state_tx=0;
                          state_rx=4;
                          check_sum=checksum_rawdata((uint8_t *)v1,counter);               // calculating checksum
                          send_data_str2(check_sum);
                    }   
                     
                        total_file_size_sent=file_size1();
                        blue.printf("\n");  
                  break;        
               
         
        case 4:  // total_file_size_sent=file_size1();
                 if(total_file_size_sent==total_file_size)          // if the total file size is same as total file size
                     {                                         // then there is no more data to send in that particular file
                    
                        state_rx=5;
                        send_last_string();
                        blue.printf("\n"); 
                  
                     }
                else   
                       {
                        
                         total_samples=0;   
                         sd_read1(bt_file1);               // read the sd card file
                       //  mc.printf("sd file opened to read data in it\n");
                         myBleMsg->bt_msg=bt_file1;         //copy the contents to the structure
                         send_structure();                                // send the initial string
                         blue.printf("\n");   
                       //  mc.printf("sent initial string\n");                    
                         total_samples= myBleMsg->bt_msg.num_samples.num_sample_ppg_dummy+myBleMsg->bt_msg.num_samples.num_sample_ecg_OTtyp;
                         state_tx =0;
                         state_rx =2;
                         count_send=0;
                         total_file_size_sent=file_size1();
                                
                        }   
                       
   
 
 
         }
 
   return state_rx;     
        
  }           
 
 
 
 
uint8_t bt_receive (uint8_t state_rx)
{
       
unsigned char state_tx =1;                                                      //state for transmitting 
uint8_t string_length_rx=0;
char ack_rx[2];                                                                 // varibale to receive ack from the bluetooth 
char chksum_rx[3]; 
char btdata_received[17];
 
 
while (blue.readable()!= NULL)                                                    // reading string from bluetooth app
   {
       blue.scanf("%17s", btdata_received);
       mc.printf("%s\r\n", btdata_received);

    }                                 
   
        string_length_rx = strlen(btdata_received);                                // storing the length of the string received
        memcpy(ack_rx, btdata_received+1, 2);                                       // reading the ack received
        memcpy(chksum_rx, btdata_received+(string_length_rx-2), 3);                  // reading the checksum received
        mc.printf("%s\r\n",ack_rx);
        mc.printf("%s\r\n",chksum_rx);
    
     switch(state_rx)
         {
                
          case 1:                                                                   // wait for the ack
                      state_rx=0;
                      myBleMsg->proto=ACK;
                 if ((strcmp(ack_rx ,"00") == NULL ) && (strcmp(chksum_rx ,"80" ) == NULL))                             // check for ack and checksum
               
                     {
                       
                       state_tx=2;
                      }
                    
                    else 
                    
                      { 
                       
                        state_tx=1;
                        sd_close();
                      }
                   break;                 
 
         case 2:      state_rx =0;                        //wait for the ack
                  
                   if ((strcmp(ack_rx ,"00") == NULL ) && (strcmp(chksum_rx ,"80" ) == NULL))  
                        {
                
                          state_tx=3;
                          file_pointer_position=total_file_size_sent;
                        }
                    
                    else 
                    
                        { 
                      
                        state_tx=2;
                        setpos1(file_pointer_position);
                        //sd_close();                                                     //file closed which was opened earlier because it opens again in bt_send case 1
             
                        }
                    //blue.scanf("%02x%02x%08x%02x",&sos_rx,&ack_rx,&eos_rx,&chksum_rx);
                    break;
 
                
     case 3:       
                   state_rx =0;
                if ((strcmp(ack_rx ,"00") == NULL ) && (strcmp(chksum_rx ,"80" ) == NULL))  
                      {
                     
                         state_tx=3;
                         count_send=count_send+1;
                         file_pointer_position=total_file_size_sent;
                      }
                    
                  else 
                    
                      { 
                       
                        state_tx=3;
                        file_start=file_start- NO_OF_SAMPLES;
                        setpos1(file_pointer_position);
                      }
               
                   break;    
                                            
     case 4:       
                   state_rx =0;
               if ((strcmp(ack_rx ,"00") == NULL ) && (strcmp(chksum_rx ,"80" ) == NULL))  
                      {
                         state_tx=4;
                         count_send=count_send+1;
                         file_pointer_position=total_file_size_sent;
                      }
                    
                  else 
                    
                      { 
                       
                        state_tx=3;
                        file_start=file_start- NO_OF_SAMPLES;
                        setpos1(file_pointer_position);
                      } 
                   break;                
                 
 
      case 5:      state_rx = 0;
               if ((strcmp(ack_rx ,"00") == NULL ) && (strcmp(chksum_rx ,"80" ) == NULL))  
                {
                    sd_close();
                    increment_btpid();                // increment the bluetooth pid and write in the file
                    mc.printf("next file");   
                    mc.printf("bt_pid = %d\n",get_btpid());    
                    state_tx=1;
                          
                }
                       
                else 
                {
                    state_tx = 4;   
                       
                }           
                break;
 
  }
 
   return state_tx;          
  }           
   
 
 
 
 
 
             
void send_structure()                                 // function to send the structure to bluetooth
{
    myBleMsg->start_of_string=SOS;
    myBleMsg->length_file = STRUCTURE_LENGTH;
    myBleMsg->proto=DATA_TRFR;                      // data transfer mode
    blue.printf("%02x",myBleMsg->start_of_string); 
    blue.printf("%02x",myBleMsg->proto);
    blue.printf("%08x",myBleMsg->length_file);      //changed the sequence 
    blue.printf("%08x",myBleMsg->bt_msg.length); 
    blue.printf("%02x",myBleMsg->bt_msg.device_id); 
    blue.printf("%08x",myBleMsg->bt_msg.patient_id);    
    blue.printf("%02x",myBleMsg->bt_msg.date_time.date);     
    blue.printf("%02x",myBleMsg->bt_msg.date_time.month);  
    blue.printf("%02x",myBleMsg->bt_msg.date_time.year);  
    blue.printf("%02x",myBleMsg->bt_msg.date_time.hour);      
    blue.printf("%02x",myBleMsg->bt_msg.date_time.mins);  
    blue.printf("%02x",myBleMsg->bt_msg.date_time.sec);  
    blue.printf("%02x",myBleMsg->bt_msg.test_type);   
    blue.printf("%04x",myBleMsg->bt_msg.sampling_freq); 
    blue.printf("%04x",myBleMsg->bt_msg.num_samples. num_sample_ppg_dummy); 
    blue.printf("%04x",myBleMsg->bt_msg.num_samples.num_sample_ecg_OTtyp); 
    blue.printf("%04x",myBleMsg->bt_msg.cal_data.cal_sbp_dummy);   
    blue.printf("%04x",myBleMsg->bt_msg.cal_data.cal_dbp_OTtyp); 
    myBleMsg->end_of_string=EOS;  
    myBleMsg->chk_sum = checksum_struct((uint8_t *)myBleMsg, sizeof(Point));
    blue.printf("%02x",myBleMsg->end_of_string);
    blue.printf("%02x",myBleMsg->chk_sum);
               
    
    }
    
void send_initial_string()                // function to send the initial string at the start f communication to bluetooth
{              
 
    uint8_t sum_init=0  ;               
    myBleMsg->start_of_string=SOS;
    myBleMsg->length_file=0;
    myBleMsg->proto=START_OF_FILE;
    sum_init=checksum_init();
    myBleMsg->chk_sum=sum_init;
    blue.printf("%02x",myBleMsg->start_of_string);
    blue.printf("%02x",myBleMsg->proto); 
    blue.printf("%08x",myBleMsg->length_file);     // chnged
    myBleMsg->end_of_string=EOS;  
    blue.printf("%02x",myBleMsg->end_of_string);
    blue.printf("%02x",myBleMsg->chk_sum);
    
    }
  
   
uint8_t checksum_init()          // function to calculate the checksum for the initial string
 {
  
  uint32_t sum = 0;
  uint8_t chksum_init = 0;
  sum=SOS+EOS+START_OF_FILE; 
  chksum_init = sum & 0x000000FF;
  return chksum_init;
  }
 
uint8_t checksum_last()        // function to calculate the checksum for the last string
 {
  
  uint32_t sum = 0;
  uint8_t chksum_last = 0;
  sum=SOS+EOS+END_OF_FILE; // changed //16/06 #define all the values removing structure 
  chksum_last=sum & 0x000000FF;
  return chksum_last;
  }    
    
void send_last_string()                 // function to send the last string to the bluetooth // which determines the end of file
{
    uint8_t sum_last=0;
    myBleMsg->start_of_string = SOS;
    myBleMsg->length_file = 0;
    myBleMsg->proto=END_OF_FILE;
    sum_last=checksum_last();
    myBleMsg->chk_sum=sum_last;
    blue.printf("%02x",myBleMsg->start_of_string);
    blue.printf("%02x",myBleMsg->proto); 
    blue.printf("%08x",myBleMsg->length_file);     // chnged
    myBleMsg->end_of_string=EOS;  
    blue.printf("%02x",myBleMsg->end_of_string);
    blue.printf("%02x",myBleMsg->chk_sum);
                
}
       
void send_data_str1()       // function to send a part of the structure // after this raw data is sent//
{
    myBleMsg->start_of_string=SOS;
    myBleMsg->length_file=(counter*4);
    myBleMsg->proto=DATA_TRFR;
    blue.printf("%02x",myBleMsg->start_of_string); 
    blue.printf("%02x",myBleMsg->proto);                   // chnaged
    blue.printf("%08x",myBleMsg->length_file);
 
}
    
    
    
void send_data_str2(uint8_t check_sum)          // after raw data// this last part of structure is sent
{          
    myBleMsg->chk_sum=check_sum;
    myBleMsg->end_of_string=EOS;  
    blue.printf("%02x",myBleMsg->end_of_string);
    blue.printf("%02x",myBleMsg->chk_sum);
    
}
    
 
uint8_t checksum_struct(const uint8_t data[], uint16_t numBytes)         // calculating checksum for 
{
    uint32_t chksum_struct = 0;
    uint16_t index = 0;
    
    for (index=0U; index < (numBytes-1); index++)
    {
          chksum_struct += data[index];  
          //blue.printf("data=%02x\n",data[index]);
        
    }
  // blue.printf("%08x\n",chksum_struct);  
  return chksum_struct;
}
 
 
uint8_t checksum_rawdata(const uint8_t data[], uint32_t numBytes)          // this function to calculate the checksum for the raw data
{
 
    uint32_t sum=0;
    uint8_t  chksum_datatrfr=0;
    uint32_t index = 0;
    uint32_t index1 = 0;
    sum += SOS;
    sum += DATA_TRFR;  
    index1=(numBytes*4);
    sum +=(index1>>(8*0))&0xFF;
    sum +=(index1>>(8*1))&0xFF; 
 
    for (index=0U; index<(numBytes*4); index++)
    { 
    sum += data[index];
    }
 
    sum+=EOS;
 
    chksum_datatrfr = sum & 0x000000FF;
 //mc.printf("chksum_datatrfr=%02x\n",chksum_datatrfr);
    return chksum_datatrfr;
}
 
 