#include "mbed.h"
#include "eeprom.h"
#include "eeprom_pgm.h"

#include <stdio.h> 
Serial ec(USBTX, USBRX); // tx, rx
EEPROM rom(PTC11, PTC10, 0x00, EEPROM::T24C32);
 
 
 

void eprom_write(uint32_t address, int32_t data) 
{
    rom.write(address ,data);           // write data into the address
 
}

void eprom_write_8(uint32_t address, int8_t data) 
{
    rom.write(address ,data);           // write data into the address
 
}

void eprom_write_16(uint32_t address, int16_t data) 
{
    rom.write(address ,data);           // write data into the address
 
}


int32_t eprom_read(uint32_t address)       // readng the data from the specified address
{
    int32_t rdata;                     // changed to int32_t
    rom.read(address, rdata);        
   // ec.printf("Read back value=%d\n", rdata);  
    return rdata;
}

int8_t eprom_read_8(uint32_t address)       // readng the data from the specified address
{
    int8_t rdata;                     // changed to int32_t
    rom.read(address, rdata);        
    //ec.printf("Read back value=%d\n", rdata);  
    return rdata;
}

int16_t eprom_read_16(uint32_t address)       // readng the data from the specified address
{
    int16_t rdata;                     // changed to int32_t
    rom.read(address, rdata);        
    //ec.printf("Read back value=%d\n", rdata);  
    return rdata;
}