#include "mbed.h"
#include "display_modules.h"
#include "touch_modules.h"
#include "rtc.h"
#include "main.h"
#include "ILI9341.h"
//#include <ILI932x.h>
#include "Arial12x12.h"
#include "Arial24x23.h"
//#include "Terminal6x8.h"
//#include "Arial43x48_numb.h"


//BusOut dataBus( PTC12, PTC13, PTB10, PTC9, PTD4, PTD5, PTD6, PTD7 ); // 16 pins//POC DISPALY 240*320 pixels
//ILI9325_LCD lcd( PTC5, PTB9, PTC0, PTB0, &dataBus, NC, PTE31);

/*PinName buspins[8]={PTC12, PTC13, PTB10, PTC9, PTD4, PTD5, PTD6, PTD7 };
ILI932x TFT(BUS_8, buspins, PTC5, PTB9, PTC0, PTB0,PTE31,"SPFD5408_2.4") ; 
DigitalOut backlight(PTC9) ;*/

PinName buspins[8]={PTD2, PTC13, PTB10, PTC9, PTD4, PTD5, PTD6, PTD7 };          //new_display ili9341 
ILI9341 TFT(BUS_8, buspins, PTB0, PTB9, PTC0, PTB8,PTE31,"SPFD5408_2.4") ;
DigitalOut backlight(PTC9) ;

 void init_screen()     // initializing the screen
  {    
      //Configure the display driver    
    TFT.FastWindow(true) ;
    TFT.background(Black);
    TFT.foreground(White);
    wait(0.01) ;
    TFT.cls();
  }

 void screen_main()     //main screen
 {
    char buff1[32];
    time_t epoch_time;
    epoch_time=rtc_read();                           // read the time from rtc module
    strftime(buff1, 32, "%d-%m-%Y           %H:%M",localtime(&epoch_time));
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.cls() ;
    wait(0.1) ;
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.foreground(Red);
    TFT.locate(20,100) ;
    TFT.printf(buff1);
    TFT.set_font((unsigned char*) Arial24x23);  
    TFT.foreground(Black);
    TFT.locate(35,30) ;
    TFT.printf("SENSESEMI") ;
    TFT.locate(45,60) ;
    TFT.printf("Sense POC") ;
    TFT.background(Olive) ;
    TFT.fillrect( 60,130,180,200,Olive);
    TFT.locate(100,140) ;
    TFT.printf("SYS") ;    
    TFT.locate(65,170) ;
    TFT.printf("CONFIG") ;    
    TFT.fillrect( 60,230,180,300,Olive);
    TFT.locate(88,252) ;                //y :changed from 250 to 252 //x: changed from 90 to 88 //rashmi 22/7/17 //rashmi 22/7/17
    TFT.printf("TEST") ;          
    TFT.BusEnable(false) ;
    backlight = 1 ;
     
  }
     
    
    
   void screen_main_2(int32_t pid)     // test main screen
 {
    char buff2[10];     
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    sprintf(buff2 ,"%d", pid);
    TFT.fillrect(5,20,250,150,White ); 
   TFT.fillrect(5,20,250,250,White );              // added on 11/8/17 nikita 
   TFT.fillrect(60,130,180,200,White );  
   TFT.fillrect(60,230,180,300,White );      // changed from 300 to 320  //changed//8/8/17
   // TFT.fillrect(5,20,300,320,White ); 
   TFT.fillrect(5,230,240,320,White );       // added on 11/8/17 nikita
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.foreground(Black);
    TFT.locate(10,50) ;
    TFT.printf("PATIENTID") ;
    TFT.locate(180,50) ;
    TFT.printf(buff2) ;
    TFT.background(Orange) ;
    TFT.foreground(Black);
    TFT.fillrect( 10,130,100,200,Orange);
    TFT.locate(40,160) ;
    TFT.printf("BG") ;      
    TFT.fillrect( 130,130,220,200,Orange);
    TFT.locate(145,160) ;
    TFT.printf("ECG") ;    
    TFT.fillrect( 10,215,100,285,Orange);
    TFT.locate(40,245) ;        
    TFT.printf("BP") ;    
    TFT.fillrect(130,215,220,285,Orange);
    TFT.locate(130,245) ;        
    TFT.printf("HOME") ;    
    TFT.BusEnable(false) ;
    backlight = 1 ;
}         
                
                
                
    void screen_main_1()                                                             // System Configuration main screen
 {
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(GreenYellow) ;
    TFT.fillrect(5,127,230,320,White );  
    // wait(0.1) ;
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.foreground(Black);
    TFT.fillrect( 10,130,100,200,GreenYellow);
    TFT.locate(38,160) ;                                                              //changed from 30 to 38 //rashmi 24/7/17            //changed from 40 to 30 //rashmi 22/7/17     
    TFT.printf("BT") ; 
    TFT.fillrect( 130,130,220,200,GreenYellow); 
    TFT.locate(140,160) ;                               //changed from 135 to 145 //rashmi 22/7/17 //
    TFT.printf("P-Inf") ; 
   TFT.fillrect( 10,215,100,285,GreenYellow);
    TFT.locate(10,245) ;                                //changed from 26 to 22 //rashmi 24/7/17            //changed from 30 to 26 //rashmi 22/7/17
    TFT.printf("HOME") ;   
    
                                                                 ////changed from BLE to BT //rashmi 24/7/17
    if ((read_debug_status()== true) && get_timer_debug()<TIMER_ENABLE_DEBUG_MODE)     // checking for the debug status and timer 
    {
         TFT.fillrect(130,215,220,285,GreenYellow);
        TFT.locate(150,230) ;        
        TFT.printf("DE-") ; 
        TFT.locate(145,260) ;        
        TFT.printf("BUG") ;                                                        //changed from ERASE to DEL //rashmi 22/7/17
    }    
   
    TFT.BusEnable(false) ;
    backlight = 1 ;
 }                  
       
                
  void screen_ecg()    //ECG screen 1
{
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.fillrect(10,130,100,200,White);
    TFT.fillrect(130,130,220,200,White);
    TFT.fillrect(130,215,220,285,White);
    TFT.fillrect(10,215,100,285,White);
    TFT.fillrect(60,130,180,200,White);
     TFT.fillrect(5,5,115,20,White);
    TFT.background(Green) ;
    TFT.foreground(Black) ;  
    TFT.fillrect( 60,130,180,200,Green);
    TFT.locate(80,150) ;
    TFT.printf("START") ;    
    TFT.fillrect( 60,230,180,300,Green);
    TFT.locate(85,250) ;        
    TFT.printf("MAIN") ;          
    TFT.BusEnable(false) ;
    backlight = 1 ;       
} 
      
      
                
 void screen_ecg_2(uint16_t heart_rate)   // ECG screen 2
   {
    char buf[5];
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Green) ;
    sprintf (buf, "%d bpm",heart_rate);
    TFT.fillrect(5,90,230,150,White);  
    TFT.locate(3,100) ;  
    TFT.printf(" ECG Tst Done  ") ;   
    TFT.locate(3,150) ;  
    TFT.printf("   HeartRate   ") ;        
    TFT.locate(50,180);                            // changed from 30 
    TFT.printf(buf) ; 
    TFT.set_font((unsigned char*) Arial12x12);   // added on 11/8/17 nikita
    TFT.locate(5,291) ; 
    TFT.foreground(Navy) ;
    TFT.printf("Study Readings: Not for medical") ;           // added on 8/8/17 nikita
    TFT.locate(35,300) ;
    TFT.printf("diagnosis and treatment") ;
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.BusEnable(false) ;
    backlight = 1 ;
    }
    
    void screen_ecg_lead()   // ECG screen for displaying no lead proper lead contact
   {
     backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Red) ;
    //TFT.fillrect(5,90,230,150,White); 
    TFT.fillrect(5,90,230,200,White);  // added on 11/08/2017 //nikita 
    TFT.locate(50,100) ;  
    TFT.printf("Re-check") ;   
    TFT.locate(3,130) ;  
    TFT.printf("Lead Connection") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ;
}
 
 
   void screen_ecg_lead_bp_fingerdetect()   // ECG screen for displaying no lead proper lead contact
   {
     backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Red) ;
   // TFT.fillrect(5,90,230,150,White);  
    TFT.fillrect(5,90,230,200,White);     // added on 11/08/2017 //nikita 
    TFT.locate(20,100) ;  
    TFT.printf("Re-check Leads") ;   
    TFT.locate(50,130) ;  
    TFT.printf("& finger ") ; 
    TFT.locate(45,160) ;  
    TFT.printf("placement") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ;
}
 
  void screen_ecg_bp()            // added screen dispaly text //14/06
  { 
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(Green) ;
    TFT.fillrect(10,215,230,290,White);  
    //TFT.fillrect(60,230,180,300,Green); 
    //TFT.locate(100,250) ;  
    TFT.foreground(Black) ;
    // TFT.printf("RET") ; 
    TFT.fillrect( 10,215,100,285,Green);
    TFT.locate(20,245) ;                    //changed from 30 to 20  //rashmi 22/7/17
    TFT.printf("MAIN") ;    
    TFT.fillrect(130,215,220,285,Green);
    TFT.locate(155,235) ;           // changed // points // 13/06
    TFT.printf("RE-") ;  
    TFT.locate(140,255) ;              //chnaged from 145 to 140 //rashmi 22/7/17 
    TFT.printf("TEST") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ;
        
    }                
       
       
                
 void screen_bp()          // BP main screen
 {
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(Green) ;
    TFT.foreground(Black) ;
    TFT.fillrect(10,130,100,200,White);   
    TFT.fillrect(130,130,220,200,White);  
    TFT.fillrect(10,215,100,285,White);  
    TFT.fillrect(130,215,220,285,White);
     TFT.fillrect(5,5,115,20,White);  
    TFT.fillrect( 60,130,180,200,Green);
    TFT.locate(80,150) ;
    TFT.printf("START") ;    
    TFT.fillrect( 60,230,180,300,Green);
    TFT.locate(90,250) ;        //changed from 100 to 90 //rashmi 22/7/17
    TFT.printf("MAIN") ;          
    TFT.BusEnable(false) ;
    backlight = 1 ;     
 
    }
    

void screen_bp1(float SBP, float DBP)          // BP  screen 2
 {
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Green) ;
    char buf[10];  
    TFT.fillrect(3,130,200,200,White);
    TFT.fillrect(60,230,180,300,White);
    TFT.fillrect(60,110,180,250,White);
    TFT.locate(3,100) ;  
    TFT.printf(" BP Tst Done  ") ; 
   // sprintf (buf, "SBP: %.0f   ",SBP);          // changed to display 2 digits after decimal point, 2May'17 Changed to Integer
    sprintf (buf, "SBP: %d   ",(uint32_t)SBP);               //changed to integer 8/8/2017
    TFT.locate(5,140) ;                         // changed 100 to 150
    TFT.printf(buf) ; 
    sprintf (buf, "DBP: %d",(uint32_t)DBP);                //changed to integer 8/8/2017
   // sprintf (buf, "DBP: %.0f",DBP);           // changed to display 2 digits after decimal point, 2May'17, Changed to integer
    TFT.locate(5,170) ;                       // CHANGED from 150 to 170
    TFT.printf(buf) ;
    //TFT.fillrect(60,230,180,300,Green);
    //TFT.locate(85,250) ;  
 /*   TFT.foreground(Black) ;    // commented //16/06
    TFT.background(Green) ;
    //TFT.printf("RET") ;
    TFT.fillrect( 10,215,100,285,Green);
    TFT.locate(30,245) ;        
    TFT.printf("RET") ;    
    TFT.fillrect(130,215,220,285,Green);
    TFT.locate(155,235) ;           // changed // points // 13/06
    TFT.printf("RE-") ;  
    TFT.locate(145,255) ; 
      TFT.printf("TEST") ;  */
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.foreground(Navy) ;
    TFT.locate(5,291) ; 
    TFT.printf("Study Readings: Not for medical") ;               // added on 11/8/17 nikita
    TFT.locate(35,300) ;
    TFT.printf("diagnosis and treatment") ;
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.BusEnable(false) ;
    backlight = 1 ; 
}   
    
                   
                
  
 void screen_glc()     // glc main screen
 {
        
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(Green) ;
    TFT.foreground(Black) ;
    TFT.fillrect(10,130,100,200,White);
    TFT.fillrect(130,130,220,200,White);
    TFT.fillrect(10,215,100,285,White);
    TFT.fillrect(130,215,220,285,White);
     TFT.fillrect(5,5,115,20,White);
   // TFT.fillrect( 60,130,180,200,Green);
   // TFT.locate(80,150) ;
   // TFT.printf("START") ;   
    TFT.fillrect( 10,130,100,200,Green);
    TFT.locate(30,160) ;                           // changed to 30 from 40
    TFT.printf("FBS") ;      
    TFT.fillrect( 130,130,220,200,Green);
    TFT.locate(155,160) ;
    TFT.printf("PP") ;     
    TFT.fillrect( 10,215,100,285,Green);
    TFT.locate(23,245) ;                      //changed from 20 to 23 //rashmi 22/7/17
    TFT.printf("RAN") ;   
    TFT.fillrect(130,215,220,285,Green); 
    TFT.locate(145,245);                    //changed from 150 to 145  //rashmi 22/7/17
    TFT.printf("MAIN") ;
  //  TFT.fillrect( 60,230,180,300,Green);
  //  TFT.locate(100,250) ;        
  //  TFT.printf("RET") ;          
    TFT.BusEnable(false) ;
    backlight = 1 ; 
        
    }               


 void screen_bp2()    //BP screen 3
 {    
     
          /* lcd.FillRoundRect(3,130,200,200,COLOR_BLACK);
           lcd.FillRoundRect(60,230,180,300,COLOR_BLACK);
           lcd.FillRect(5,215,230,290,COLOR_BLACK);*/
           
}
            
     
void ecg_countdown()   // ECG measurement countdown 
 {    
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Green) ;
    char tim1[5];
    TFT.fillrect(3,80,240,300,White);   //changed on 11/8/17 nikita
    TFT.fillrect(60,230,180,300,White);
    TFT.fillrect(5,215,230,290,White);
    TFT.fillrect(5,230,240,320,White );  
    TFT.locate(25,100) ;        
    TFT.printf("ECG starts in") ; 
    for(int i=5;i>=0;i--)
         {
                wait(1);
                sprintf (tim1, "%d",i);
                TFT.locate(120,120) ;        
                TFT.printf(tim1) ; 
         }
    TFT.fillrect(5,80,240,200,White);    
    TFT.locate(35,110) ;        
    TFT.printf("ECG Tst in") ;                  // added on 11/8/17 nikita
    TFT.locate(50,140) ;        
    TFT.printf("progress") ;      
    TFT.BusEnable(false) ;
    backlight = 1 ; 
        
      
  }                   
  
   void bp_countdown()   // ECG measurement countdown 
 {    
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Green) ;
    char tim1[5];
    TFT.fillrect(3,130,200,200,White);
    TFT.fillrect(60,230,180,300,White);
    TFT.fillrect(1,80,240,290,White);           //changed the points// 13/06
    TFT.fillrect(5,230,240,320,White );    //added 11/8/17
    TFT.locate(25,100) ;        
    TFT.printf("BP starts in") ; 
    for(int i=5;i>=0;i--)
            {
                wait(1);
                sprintf (tim1, "%d",i);
                TFT.locate(120,120) ;        
                TFT.printf(tim1) ; 
            }
    TFT.fillrect(5,80,240,200,White);
    TFT.locate(35,110) ;        
    TFT.printf("BP Tst in") ;                        // added on 11/8/17 nikita
    TFT.locate(50,140) ;        
    TFT.printf("progress") ;   
            
     TFT.BusEnable(false) ;
     backlight = 1 ; 
} 
  
 void screen_again()    // screen to press 'yes' or 'no' to repeat the test 
 { 
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Black) ;
    TFT.fillrect(5,127,230,200,White);
    TFT.locate(50,130) ; 
    TFT.printf("Take test") ;
    TFT.locate(75,160) ; 
    TFT.printf("again?") ;
    TFT.background(Orange) ;
    TFT.locate(30,245) ;  
    TFT.printf("YES") ;
    TFT.locate(135,245) ;  
    TFT.printf(" NO ") ;
    backlight = 1 ; 
    TFT.BusEnable(false) ;
   
  }
  
  
  void screen_glc_2()   // GLC screen 3 after test 
   {
       
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Black) ;
   TFT.fillrect(10,215,230,290,White); 
    //TFT.fillrect(60,230,180,300,Green);
    //TFT.locate(85,250) ;  
    TFT.background(Green); 
    //TFT.printf("RET") ;  
    TFT.fillrect( 10,215,100,285,Green);
    TFT.locate(25,245) ;               // changed from 30 to 25 //rashmi 22/7/17
    TFT.printf("MAIN") ;    
    TFT.fillrect(130,215,220,285,Green);
    TFT.locate(155,235) ;           // changed // points // 13/06
    TFT.printf("RE-") ;  
    TFT.locate(140,255) ;           // changed from 145 to 140
    TFT.printf("TEST") ; 
    backlight = 1 ; 
    TFT.BusEnable(false) ;
   
          
          
    }  
  
  
  void glc_1()     // GLC screen 
  { 
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Magenta ) ;
    TFT.fillrect(3,130,200,200,White);
    TFT.fillrect(60,230,180,300,White);
    TFT.fillrect(5,215,230,290,White);
    TFT.fillrect( 130,130,220,200,White);
    TFT.fillrect( 5,95,220,200,White);    //added 11/8/17//45 to 5  nikita
    TFT.fillrect(5,230,240,320,White );  
    TFT.locate(5,130) ;  
    TFT.printf("Blood Glucose") ; 
    TFT.locate(5,160) ;  
    TFT.printf("Insert strip") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ; 
  
  
  
  }
  
   void glc_2()     // GLC screen 
  {
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.locate(5,160) ;  
    TFT.printf("Strip Detected") ; 
    TFT.locate(5,190) ;  
    TFT.printf("Insert Blood") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ; 
   }
   
 
  void glc_3()     // GLC screen 
  {
    backlight = 0 ;
    TFT.BusEnable(true) ; 
    TFT.locate(5,190) ;  
    TFT.printf("Blood Detected") ; 
    TFT.locate( 5,220) ;  
    TFT.printf("computing") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ; 
     }
   
  
  void glc_4(uint16_t mgdl)   // GLC screen to display blood glucose level on the LCD
   { 
    char buf[10];
    sprintf (buf, " BG %d mg/dl",mgdl);
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.fillrect(5,127,230,320,White);
    TFT.locate(3,100) ;  
    TFT.printf(" BG Tst Done  ") ;
    TFT.locate(5,130) ;  
    TFT.printf(buf) ; 
    TFT.locate(5,160) ;  
    TFT.printf("(Range 70-120 mg/dl)") ;   // added 16/06
       TFT.set_font((unsigned char*) Arial12x12);
    TFT.foreground(Navy) ;
     TFT.locate(5,291) ; 
    TFT.printf("Study Readings: Not for medical") ;                      // added on 11/8/17 nikita
    TFT.locate(35,300) ;
    TFT.printf("diagnosis and treatment") ;
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.BusEnable(false) ;
    backlight = 1 ; 
   }
  
  
  void battery_screen_nocharge()
   {
     
     
   backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(Red) ;
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.foreground(White);
     TFT.fillrect(5,5,115,20,White);
    TFT.fillrect(5,5,95,20,Red);   //added rect
    TFT.locate(10,8) ;
   TFT.printf("No Charge") ;
    TFT.set_font((unsigned char*) Arial24x23);  
   TFT.BusEnable(false) ;
    backlight = 1 ;
      
      
    }
    
 void battery_screen_charge()
   {
        
        backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(Green) ;
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.foreground(Black);
    TFT.fillrect(5,5,115,20,White);
    TFT.fillrect(5,5,115,20,Green);   //added rect
    TFT.locate(10,8) ;
   TFT.printf("Battery Charged") ;
    TFT.set_font((unsigned char*) Arial24x23);  
   TFT.BusEnable(false) ;
    backlight = 1 ;   
        
    }     
 
 
     
 void battery_critically_low_charge()
   {
        backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(Red) ;
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.foreground(White);
     TFT.fillrect(5,5,115,20,White);
    TFT.fillrect(5,5,95,20,Red);   //added rect
    TFT.locate(10,8) ;
   TFT.printf("Critically Low") ;
    TFT.set_font((unsigned char*) Arial24x23);  
   TFT.BusEnable(false) ;
    backlight = 1 ;  
        
    }     
   
   void battery_low_charge()
   {
         backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(Green) ;
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.foreground(Black);
     TFT.fillrect(5,5,115,20,White);
    TFT.fillrect(5,5,95,20,Green);   //added rect
    TFT.locate(10,8) ;
   TFT.printf("Low Battery") ;
    TFT.set_font((unsigned char*) Arial24x23);  
   TFT.BusEnable(false) ;
    backlight = 1 ;  
        
    } 
         
void screen_ecg_error()
 {  
     backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Red) ;
   TFT.fillrect(5,90,230,200,White); // added on 11/8/17 nikita
     
    TFT.locate(50,100) ;  
    TFT.printf("ERROR!") ;   
    TFT.locate(20,130) ;  
    TFT.printf("Take ReTest") ; 
    //TFT.locate(45,160) ;  
   // TFT.printf("") ; 
   TFT.BusEnable(false) ;
    backlight = 1 ;    
  } 
  
  void screen_bp_error()
 {  
     backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Red) ;
    TFT.fillrect(5,90,230,150,White);
       
    TFT.locate(50,100) ;  
    TFT.printf("ERROR!") ;   
    TFT.locate(20,130) ;  
    TFT.printf("Take ReTest") ; 
    //TFT.locate(45,160) ;  
   // TFT.printf("") ; 
   TFT.BusEnable(false) ;
    backlight = 1 ;    
  }  
  
  
void glc_error()                        //glc replace test strip
 {  
     backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Red) ;
    TFT.fillrect(5,90,230,300,White);
       
    TFT.locate(60,100) ;                //changed from 50 to 60 //rashmi 22/7/17
    TFT.printf("Replace") ;   
    TFT.locate(40,130) ;                //changed from 20 to 40 //rashmi 22/7/17
    TFT.printf("Test Strip") ; 
    //TFT.locate(45,160) ;  
   // TFT.printf("") ; 
   TFT.BusEnable(false) ;
    backlight = 1 ;    
  }  
  
  
void BT_connection()
 {  
     backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Blue) ;
    TFT.fillrect(5,90,230,300,White); 
     TFT.fillrect(5,5,115,20,White); 
    TFT.locate(40,140) ;  
    TFT.printf("Connected") ;   
    TFT.locate(20,170) ;  
    TFT.printf("Sending Files") ; 
    //TFT.locate(45,160) ;  
   // TFT.printf("") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ;    
  } 
  
   void BT_no_connection()
 {  
     backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Blue) ;
    TFT.fillrect(5,90,230,300,White); 
    TFT.fillrect(5,5,115,20,White); 
    TFT.locate(80,140) ;  
    TFT.printf("Not") ;   
    TFT.locate(40,160) ;  
    TFT.printf("Connected") ; 
    //TFT.locate(45,160) ;  
   // TFT.printf("") ; 
   TFT.BusEnable(false) ;
    backlight = 1 ;    
  }   
  
void BT_finished()
 { 
  backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Blue) ;
    TFT.fillrect(5,90,230,300,White);  
    
    TFT.locate(20,140) ;  
    TFT.printf("Files Tranfer") ;   
    TFT.locate(40,170) ;  
    TFT.printf("Completed") ; 
    //TFT.locate(45,160) ;  
   // TFT.printf("") ; 
   TFT.BusEnable(false) ;
    backlight = 1 ;    
  }
  
  
 void screen_BT_return()          // BT main screen
 {
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(Green) ;
    TFT.foreground(Black) ; 
   // TFT.fillrect(5,90,230,300,White);    
    
    TFT.fillrect( 60,230,180,300,Green);
    TFT.locate(80,250) ;        
    TFT.printf("MAIN") ;          
    TFT.BusEnable(false) ;
    backlight = 1 ;     
 
    }  
    
    
void screen_patient_info(uint32_t current_test_pid,uint32_t  bt_file_sent_pid)
{
    
    char buf[10];
    sprintf (buf, "Test pid:%d",current_test_pid);      //changed from 'current pid' to 'Test pid' //rashmi 24/7/17
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White);
    TFT.foreground(Blue);   
    TFT.fillrect(5,90,230,300,White);
    TFT.fillrect(5,5,115,20,White);
    TFT.locate(15,140) ;                               //changed from 20 to 15 //rashmi 24/7/17      
    TFT.printf(buf) ; 
    sprintf (buf,"BT pid :%d",bt_file_sent_pid);
    TFT.locate(15,170) ;                               //changed from 20 to 15 //rashmi 24/7/17  
    TFT.printf(buf) ;     
    TFT.background(Green) ;
    TFT.foreground(Black) ; 
    TFT.fillrect( 60,230,180,300,Green);
    TFT.locate(80,250) ;        
    TFT.printf("MAIN") ;           
    TFT.BusEnable(false) ;
    backlight = 1 ;   
    
}
void glc_error_test_strip_removed()                        //glc replace test strip// // added on 8/8/17 nikita
 {  
     backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
    TFT.foreground(Red) ;
    TFT.fillrect(5,90,230,300,White);  
    
    TFT.locate(50,130);            //changed from 50 to 60 //rashmi 22/7/17// changed from 100 to 130added on 10/8/17 nikita
    TFT.printf("Test Strip") ;   
    TFT.locate(50,160) ;                //changed from 20 to 40 //rashmi 22/7/17// changed from 130 to 160added on 10/8/17 nikita
    TFT.printf("Removed") ; 
    //TFT.locate(45,160) ;  
   // TFT.printf("") ; 
   TFT.BusEnable(false) ;
    backlight = 1 ;    
}

void screen_debug()
{
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(GreenYellow) ;
    TFT.fillrect(5,127,230,320,White );  
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.foreground(Black);
    TFT.fillrect( 10,130,100,200,GreenYellow);
    TFT.locate(45,140) ;                                //changed from 30 to 38 //rashmi 24/7/17            //changed from 40 to 30 //rashmi 22/7/17     
    TFT.printf("SD") ;                                  ////changed from BLE to BT //rashmi 24/7/17
    TFT.locate(30,170) ;                                //changed from 30 to 38 //rashmi 24/7/17            //changed from 40 to 30 //rashmi 22/7/17     
    TFT.printf("DEL") ;
    TFT.fillrect( 130,130,220,200,GreenYellow);
    TFT.locate(150,140) ;                               //changed from 135 to 145 //rashmi 22/7/17
    TFT.printf("SD") ;    
    TFT.locate(140,170) ;                               //changed from 135 to 145 //rashmi 22/7/17
    TFT.printf("READ") ;                              //changed from ERASE to DEL //rashmi 22/7/17
    TFT.fillrect( 10,215,100,285,GreenYellow);
    TFT.locate(22,245) ;                                //changed from 26 to 22 //rashmi 24/7/17            //changed from 30 to 26 //rashmi 22/7/17
    TFT.printf("*") ;    
    TFT.fillrect(130,215,220,285,GreenYellow);
    TFT.locate(130,245) ;        
    TFT.printf("BACK") ;    
    TFT.BusEnable(false) ;
    backlight = 1 ;
    
    
} 

void screen_sdcard_delete(void)
{
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.fillrect(10,130,100,200,White);   
    TFT.fillrect(130,130,220,200,White);  
    TFT.fillrect(10,215,100,285,White);  
    TFT.fillrect(130,215,220,285,White);
    TFT.fillrect(5,5,115,20,White); 
    TFT.background(White) ;  
    TFT.foreground(Red);
    TFT.locate(15,140) ;
    TFT.printf("SD card erased"); 
     
    TFT.fillrect( 60,230,180,300,Green);
    TFT.background(Green) ;
    TFT.foreground(Black) ;
    TFT.locate(80,250) ;        
    TFT.printf("MAIN") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ; 
}   

void screen_sdcard_read(void)
{
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.fillrect(10,130,100,200,White);   
    TFT.fillrect(130,130,220,200,White);  
    TFT.fillrect(10,215,100,285,White);  
    TFT.fillrect(130,215,220,285,White);
    TFT.fillrect(5,5,115,20,White); 
    TFT.background(White) ;  
    TFT.foreground(Red);
    TFT.locate(15,140) ;
    TFT.printf("SD file read"); 
    TFT.fillrect( 60,230,180,300,Green);
    TFT.background(Green) ;
    TFT.foreground(Black) ;
    TFT.locate(80,250) ;        
    TFT.printf("MAIN") ; 
    TFT.BusEnable(false) ;
    backlight = 1 ; 
}   