#include "mbed.h"
#include "battery.h"
#include "display_modules.h"

#define BATTERY_PIN                                      PTB1                                                   // Battery Pin
#define BATTERY_MAX_OPERATING_VOLTAGE                   (float)3.3                                              // Battery Max Operating Voltage
#define BATTERY_INTERMEDIATE_HIGH_VOLTAGE               (float)3.64                                             // Battery Full Voltage
#define BATTERY_MEDIUM_VOLTAGE                          (float)3.57                                             // battery Medium Voltage
#define BATTERY_LOW_VOLTAGE                             (float)3.53                                             // Battery LOW Voltage 

#define  BATTERY_SCREEN_CHARGE_CONDITION                                            0
#define  BATTERY_LOW_CHARGE_CONDITION                                               1
#define  BATTERY_CRITICALLY_LOW_CHARGE_CONDITION                                    2
#define  BATTERY_SCREEN_NO_CHARGE_CONDITION                                         3

static uint8_t battery_voltage_condition = 0;


AnalogIn A(BATTERY_PIN);
Serial battery(USBTX, USBRX);

/*  Function    : To Monitor Battery Voltage
    returns     : void

*/
 
 //uint8_t battery_condition=0;
void battery_monitor() 
{
    
    float b_voltage;
    b_voltage = A.read_u16()*(BATTERY_MAX_OPERATING_VOLTAGE/65535)*2;
    wait(0.001f);   
    battery.printf("voltage=%f",b_voltage);
    
    if (b_voltage >= BATTERY_INTERMEDIATE_HIGH_VOLTAGE )
         battery_voltage_condition = BATTERY_SCREEN_CHARGE_CONDITION;
    
    else if ((b_voltage <  BATTERY_INTERMEDIATE_HIGH_VOLTAGE ) && (b_voltage > BATTERY_MEDIUM_VOLTAGE))             // 15% to 10% Battery voltage
         battery_voltage_condition =  BATTERY_LOW_CHARGE_CONDITION ;
              
    else if ((b_voltage < BATTERY_MEDIUM_VOLTAGE) && (b_voltage > BATTERY_LOW_VOLTAGE))                             // 10% to 5% battery volage
        battery_voltage_condition =  BATTERY_CRITICALLY_LOW_CHARGE_CONDITION;
            
    else if (b_voltage < BATTERY_LOW_VOLTAGE)
         battery_voltage_condition = BATTERY_SCREEN_NO_CHARGE_CONDITION ;
                   
  
    
 
}

/*  Function: To Display Battery Status
    returns : void
*/

void battery_status_display()
{
    if (battery_voltage_condition == BATTERY_SCREEN_CHARGE_CONDITION)
        battery_screen_charge();
        
    else if (battery_voltage_condition == BATTERY_LOW_CHARGE_CONDITION)      
         battery_low_charge();
         
    else if (battery_voltage_condition == BATTERY_CRITICALLY_LOW_CHARGE_CONDITION)      
         battery_critically_low_charge();
  
    else if (battery_voltage_condition == BATTERY_SCREEN_NO_CHARGE_CONDITION) {
         do
            {     
                battery_screen_nocharge();
                wait_ms(500);
               } while(battery_voltage_condition == BATTERY_SCREEN_NO_CHARGE_CONDITION );
            
        }
}

/*  Function    : To get battery status depending battery voltage 
    returns     : battery_voltage_condition

*/

uint8_t get_battery_status()
{
    
    return battery_voltage_condition;    
} 