// changed the pid in all to int32_t;
//added bt

#include "mbed.h"
#include "display_modules.h"
#include "touch_modules.h"
#include "ecg_dec.h"
#include "touch_modules.h"
#include "glc.h"
#include "bp.h"
#include "sdcard.h"
#include "eeprom_pgm.h"
#include "struct.h"
#include "battery.h" 

Serial gc(USBTX, USBRX);
DigitalIn q1(PTB11);
DigitalIn q(PTC5);
DigitalIn q3(PTC12);
DigitalIn BT(PTA5);                     //bluetooth status pin
  
uint8_t touch(uint8_t state);           // touch state
uint8_t display(uint8_t state1);       //  display state
int32_t pid=0;                // patient ID
static uint8_t nstate=0;
static uint8_t nstate1=0;
static uint8_t flag=0;             //flag to indicate not to update pid as it is already done
static uint8_t ecg_flag=0;         // ecg_flag to indicate the ecg test is already done for the same pid
static uint8_t glc_flag=0;         // glc_flag to indicate the glc test is already done for the same pid
uint8_t state_r=0;                 // state to receive from bluetooth
uint8_t state_t=1;                 // state to transmit to bluetooth
uint16_t heart_rate=0;          


int main(){



  
   DisableTouch();
   gc.baud(115200);
  
   init_screen();    //initialize lcd
   screen_main(); // display of main screen 
   //state=10;
   flag=0;
   //nstate=state;
   EnableTouch();   // enable touch function
static uint8_t main_state=1;
static uint8_t state_display=0;
static uint8_t state_touch=1;
static uint8_t state_t=1;
static uint8_t state_r=0;
 float b_voltage=0;
 /*      b_voltage=battery_voltage();
       //gc.printf("%f \n",  b_voltage );
       if (b_voltage<3.5)
       {
          bat_screen_nocharge();
          DisableTouch();
        }
      
      
else
    {  
     // enable touch function
       bat_screen_charge();
       EnableTouch();*/
   while(1)
   {
     switch(main_state)                          // main state machine
     {
         case 1:  state_display=touch(state_touch);           // touch state 
                   if(state_display==12)
                      main_state=3;
                    
                  else 
                       main_state=2;
                  break;
    
         case 2:  state_touch=display(state_display);          //display state
           /*        if (b_voltage<3.5)
                     {
                         bat_screen_nocharge();
                         DisableTouch();
                     }
              else    {                        */
                    //    bat_screen_charge();
                       main_state=1;
                    //   }
                    break;
                
                
         case 3: DisableTouch();                             // bluetooth send 
                 if(BT==1)
                 {
                    state_r=bt_send(state_t);
                    main_state=4;
                 }
               else   
                 gc.printf("timeout");
                 break;
                 
         case 4:  
                 state_t=bt_receive(state_r);               // bluetooth receive
                 main_state=3;
                // gc.printf("statet=%d",state_t);
                 if(state_t ==0)
                 {
                    EnableTouch();
                    main_state=1;
                   } 
                 break;    
                
                
    }
}

}

//}


uint8_t touch(uint8_t state)
{
   static  uint8_t state1=0;
   detect_touch();     // determine the touch points
    
    switch(state)    // state for touch
  {
      case 1:   state1=touch_main();   // determining the touch for main screen 
                state=0;
                nstate1=state1;
                 break;
               
      case 2: 
                state1=touch_main_1();    // determining the touch for SYSTEM CONFIGURATION screen 
                state=0;
                nstate1=state1;
                break;
                
      case 3:  
               state1=touch_main_2();     //// determining the touch for TEST screen 
                                 
                state=0;
                nstate1=state1;
                break;
        
      case 4: 
                state1=touch_glc();     // determining the touch for GLC screen 
                state=0;
                nstate1=state1;
                break;       
        
      case 5: 
                state1=touch_ecg();     // determining the touch for ECG screen 
                state=0;
                nstate1=state1;
                 break;   
     case 6: 
                state1=touch_ret();     // determining the touch for returning back to the main screen 
               /* if (ecg_flag==1)
                     state1=8;
                else if (glc_flag==1)
                    state1=7; */     
                state=0;
                nstate1=state1;
                break;
                
     case 7: 
                state1=touch_again_ecg();     // determining the touch when readings are taken more than once screen 
                state=0;
                nstate1=state1;
                break;
                
     case 8:    
                state1=touch_bp();     // determining the touch for BP screen 
                state=0;
                nstate1=state1;
                break;           
                
     case 9:    state1=touch_again_glc();  
                state=0;
                nstate1=state1;
                break;            
                
     case 10 :  DisableTouch();
                 wait_ms(300);
                 EnableTouch();
                 state=nstate;
                  break;
                  
                  
      case 11:   state1=touch_again_bp();            
                 state=0;
                 nstate1=state1;
                 break;
      
      
     default :  DisableTouch();
                 wait_ms(300);
                 EnableTouch();
                 state=nstate;
                  break;          
                          
    }         
     
return state1;
  }
  
  
uint8_t display(uint8_t state1)
{
  static uint8_t state=0;
  
 switch(state1)    // state for display screens
  {

      
      case 1: DisableTouch();
                screen_main();        //  main screen 
                state1=0;
                state=1;
                nstate=state;
                flag=0;
                ecg_flag=0;             // ecg, glc flag to determine whether the readings are taken more than once
                glc_flag=0;
                EnableTouch();
                break;
      
      case 2: DisableTouch();
                 // bt();
                screen_main_1();     // System configration screen 
                state1=0;
                state=2;
                nstate=state;
                EnableTouch();
                break;
               
      case 3: DisableTouch();
              if (flag==0)
              {
                //pid=pid+1;
                pid=eprom_read(1);         // reading the patient id from eeprom
                gc.printf("pidinit=%d",pid);
                pid=pid+1;
                gc.printf("pid+1=%d",pid);
               eprom_write(1,pid);         // writing the patient id to eeprom
                screen_main_2(pid);
              /*  sd_open_GLCfilee(pid);     // only opening the glc,bp and ecg file
                 sd_close();
                 sd_open_ECGfilee(pid);
                 sd_close();
                 sd_open_BPfilee(pid);
                 sd_close();*/
                 flag=1;
                 }
               else
               {
               screen_main_2(pid);          // TEST screen 
               }
                 
                 state1=0;
                 state=3;
                 nstate=state;
                 EnableTouch();
                  break;
                
      case 4: DisableTouch();
               if (glc_flag==1)         // glc_flag=1 when already the reading has been taken 
               {
                  screen_again();    
                 state1=0;
                 state=9;
                 nstate=state;
                 }
            else
                { 
                 screen_glc();       // glc screen
                 state1=0;
                 state=4;
                 nstate=state;
                 }
                EnableTouch();
                
                break;
     
     
     case 5:     DisableTouch();
               if (ecg_flag==1)
               {
                  screen_again();
                  state1=0;
                   state=7;
                    nstate=state;
                    }
                    
                 else
                 {   
                  screen_ecg();       //ecg main screen 
                   state1=0;
                   state=5;
                    nstate=state;
                    }
                   EnableTouch();
                break;
     
     case 6:   DisableTouch();
               screen_bp();          // bp main screen
               //EnableTouch();
                state1=0;
                state=8;
                nstate=state;         ///////
                EnableTouch();        ///////
                break;
     
     
     
     
     
     case 7:    DisableTouch();     
                glc(pid);        // glc measurement
             //  bt();
                glc_flag=1;
                wait(5); 
                state1=0;
                screen_glc_2();
                 state=6;
                 eprom_write_8(30,0);
              //  gc.printf("%d", state);
              nstate=state;         //////////////
               EnableTouch();
                break;
    
    case 8:     DisableTouch();
                ecg_countdown();    // countdown before ecg capture
                heart_rate=ecg(pid);           // capturing ecg
                state1=0;
                if (heart_rate==0)
                    {
                       gc.printf("hi");
                       screen_ecg_lead();  
                     }
                     
                     else 
                     {
                        gc.printf("hif");
                         screen_ecg_2(heart_rate);
                         ecg_flag=1;
                         }   
                state=6;
                eprom_write_8(30,1);
                nstate=state;
                screen_ecg_bp();
                EnableTouch();
                break;
     
     
     /*case 9: 
                DisableTouch();
                screen_glc_2();
                state1=0;
                state=6;
                nstate=state;
                EnableTouch();
                 break;*/
        
    case 9: 
                DisableTouch();
                screen_bp2();      // bp main screen
                bp_countdown();    // countdown for bp 
                bp(pid);              // measuring bp   earlier bp() changed to bp(pid) 28/4/2017
                state1=0;
               // wait(1);
                state=6;
                eprom_write_8(30,2);
                nstate=state;
                EnableTouch();
                 break;
        
               
                 
        default :  
                  
                  state1=nstate1;
                   break;          
                            
            
    }            
    
           
                
         return state;       
                
}



