#include "mbed.h"
#include "millis.h"
/*working variables*/

#define threshold 0.003 // 1/330

AnalogIn temperature(p20);
PwmOut fanControl(p21);
//static BufferedSerial pc(USBTX, USBRX);

Ticker temperatureTicker;

int readTemperatureFlag=0;
unsigned long lastTime;
double Input, Output, Setpoint;
double errSum, lastErr;
double kp, ki, kd;
void Compute()
{
   /*How long since we last calculated*/
   unsigned long now = millis();
   double timeChange = (double)(now - lastTime);
  
   /*Compute all the working error variables*/
   double error = Setpoint - Input;
   errSum += (error * timeChange);
   double dErr = (error - lastErr) / timeChange;
  
   /*Compute PID Output*/
   Output = kp * error + ki * errSum + kd * dErr;
  
   /*Remember some variables for next time*/
   lastErr = error;
   lastTime = now;
}
  
void SetTunings(double Kp, double Ki, double Kd)
{
   kp = Kp;
   ki = Ki;
   kd = Kd;
}
void tickerFlagOn()
{
    //led2 = !led2;
    readTemperatureFlag=1;
}

int main()
{
    float oldTemperature = temperature.read();
    float newTemperature= oldTemperature;
    temperatureTicker.attach(&tickerFlagOn, 0.200); // the address of the function to be attached (tickerFlagOn) and the interval (0.2 seconds)
    
    while (1)
    {
        if (readTemperatureFlag)
        {
            readTemperatureFlag=0;
            newTemperature = temperature.read();
            if ((newTemperature < (oldTemperature-threshold)) || (newTemperature > (oldTemperature+threshold)))
            {
                oldTemperature = newTemperature; // These are for the threshold
                printf("AnalogIn=%f, Temperature= %.1f degrees\n\r", oldTemperature, 3.3*oldTemperature*100);
            }
        }
    
    Input=oldTemperature;
    Setpoint= 0.0757575757575758;
    SetTunings(1, 0, 0);
    Compute();
    fanControl.write(Output);
    printf("fanSpeed=%f \n \r", Output); 
    wait(1);   
    }
}
