#include "mbed.h"
#include "PID.h"
#define threshold 0.003 // 1/330

AnalogIn temperature(p20);
//static BufferedSerial pc(USBTX, USBRX);

Ticker temperatureTicker;

int readTemperatureFlag=0;

// ??? https://www.keil.com/pack/doc/CMSIS/DSP/html/group__PID.html
// ??? https://os.mbed.com/questions/1904/mbed-DSP-Library-PID-Controller/
// https://os.mbed.com/cookbook/PID
// http://brettbeauregard.com/blog/2011/04/improving-the-beginners-pid-introduction/
// PID library https://os.mbed.com/users/aberk/code/PID/docs/tip/classPID.html
// https://en.wikipedia.org/wiki/PID_controller

//static BufferedSerial pc(USBTX, USBRX);

Ticker PIDticker;

//PID controller(DEFAULT_Kp , DEFAULT_Ki , DEFAULT_Kd , 5);
#define INTERVAL 0.1  // seconds
#define INTERVAL_SAME 100ms

// Tip: Check error
#define  Kp 1.0
#define  Ki 0.0
#define  Kd 0.0 

PID controller(Kp, Ki, Kd, INTERVAL);

float co=0; // controller output
float movingAverage=0;
void computePID()
{
    //Update the process variable.
    controller.setProcessValue(movingAverage);  // Setpoint
    //Set the new output.
    co = controller.compute();
}

int main()
{
        float oldTemperature = temperature.read();
        float newTemperature= oldTemperature;
        temperatureTicker.attach(&tickerFlagOn, 2); // the address of the function to be attached (tickerFlagOn) and the interval (0.2 seconds)
        float movingAverageArray[10];
        int movingAverageIndex=0;
        for (int i=0; i < 10; i++)
            movingAverageArray[i]=newTemperature; // fill in the array
        movingAverage=newTemperature;
        
    
    PIDticker.attach(&computePID, INTERVAL_SAME); // the address of the function to be attached (computePID) and the interval
    
    //Analog input from 0.0 to 1.0
    controller.setInputLimits(0.0, 1.0);
    //Pwm output from 0.0 to 1.0
    controller.setOutputLimits(0.0, 1.0);
    //If there's a bias.
    //controller.setBias(0.3);
    // ??? controller.setMode(AUTO_MODE);
    //We want the process variable to be
    controller.setSetPoint(0.0757575757575758); // 25 degrees in 0-1 range is 0,0757575757575758

    while (1)
    {
        printf("Driver(PWM)=%.2f\n\r", co);
        
            if (readTemperatureFlag)
            {
                readTemperatureFlag=0;
                newTemperature = temperature.read();
                movingAverage-=movingAverageArray[movingAverageIndex]/10; // Remove the oldest value from the moving average
                movingAverageArray[movingAverageIndex]=newTemperature; // Add new value to the array, overwrite the oldest value
                movingAverage+=movingAverageArray[movingAverageIndex]/10; // Add the newest value to the moving average
                if (movingAverageIndex < 9)
                    movingAverageIndex++; // Increase the array index
                else
                    movingAverageIndex=0; // Rollover the array index
                if ((newTemperature < (oldTemperature-threshold)) || (newTemperature > (oldTemperature+threshold)))
                {
                    oldTemperature = newTemperature; // These are for the threshold
                    printf("AnalogIn=%f, Temperature= %.1f degrees, Average= %.1f degrees\n\r", oldTemperature, 3.3*oldTemperature*100, 3.3*movingAverage*100);
                }
            }
    }
}
