#include "mbed.h"
#include "EthernetInterface.h"
#include "gen_helper.h"
#include "FATFileSystem.h"
#include "ff.h"
#include "SDFileSystem.h"


#define INCREASE_PWM_VALUE                 0
#define DECREASE_PWM_VALUE                 1
#define DRAW_ON_SCREEN                     2
#define FADE_SCREEN_AND_TURN_OFF           3
#define INCREASE_SCREEN_BRIGHTNESS_TO_FULL 4
#define SET_UP_SCREEN                      5

/* Init connections */
void init();
void read_temperature();

Serial main_console(USBTX, USBRX);
SDFileSystem sd(P8_5, P8_6, P8_3, P8_4, "sd"); // SD card interface through SPI
SPI temp_sense(P4_6, P4_7, P4_4);
DigitalOut cs(P4_5);

EthernetInterface ethInf;
TCPSocketServer server;
TCPSocketConnection* sock_connection;
gen_helper *helper; // Helper instance

int main() 
{
    main_console.printf("START\n");
    helper = new gen_helper(P10_14, P10_15, P10_12, P10_13, P3_15, P3_14, USBTX, USBRX, P4_6);
    helper->init_console();
    helper->lcd_init();
    
    main_console.printf("Starting connecting in V2 \n");
    
    /* Init Eth on a static IP and gateway */
    ethInf.init(HOST_IP_ADDR, HOST_SUBNET, HOST_GATEWAY);
    main_console.printf("Init eth\n");
    
    ethInf.connect();
    main_console.printf("Connected eth\n");
    
    /* Init the TCP server after init Ethernet */
    init();
    
    return 0; //should never come here
}

/* Start the eth interface and listen for incoming connections */
void init()
{
    /* Bind this server to a specific port */
    main_console.printf("Binding\n");
    int bind_status = server.bind(HOST_PORT);
    main_console.printf("Bound on port %d with status %d\n", HOST_PORT, bind_status);
    
    /* Listen on the port for incoming connections */
    int listen_status = server.listen();
    main_console.printf("Listen status %d\n", listen_status);
    
    /* Accept incoming connections */
    sock_connection = new TCPSocketConnection();
    int conn_accept_status = server.accept(*sock_connection);
    main_console.printf("Connection accept status %d\n",conn_accept_status);
    
    char meta_data[1] = {'\0'}; // holds the command from the client
    
    while(1) 
    {
        sock_connection->receive(meta_data, sizeof(meta_data));

        switch((int)(meta_data[0] % 48)) {
            
            case INCREASE_PWM_VALUE:
                main_console.printf("Increasing screen brightness\n");
                helper->pwm = helper->pwm + 0.1;
                break;

            case DECREASE_PWM_VALUE:
                main_console.printf("Decreasing screen brightness\n");
                helper->pwm = helper->pwm - 0.1;
                break;

            case DRAW_ON_SCREEN:
                //Divide the screen in two sections and fill them with different colours
                /*helper->fill_rect(0, 0, 128, 120, BROWN);
                helper->fill_rect(0, 120, 128, 160, SKYBLUE);*/
                
                //Draw the pattern
                //helper->draw_pattern_helper();
                break;

            case FADE_SCREEN_AND_TURN_OFF:
                main_console.printf("Fading screen\n");
                
                for(float i = 0.0f; i < 1.0f; i+=0.1f)
                {
                    main_console.printf("i %f\n", i);
                    if(helper->pwm > 0.0f)
                    {
                        helper->pwm = helper->pwm - i;
                        wait(0.3);
                    }
                }
                
                break;

            case INCREASE_SCREEN_BRIGHTNESS_TO_FULL:
                
                main_console.printf("Increasing screen brightness to full\n");
                
                float cur_bright = helper->pwm;
                
                for(float i = 0.0f; i < (1.0f - cur_bright); i+=0.1f) 
                {
                    helper->pwm = helper->pwm + i;
                    wait(0.3);
                }
                
                break;

            case SET_UP_SCREEN:
                //helper->fill_rect(0, 0, 128, 160, WHITE); //Just fill the whole screen with a colour, in this case white.
                break;

            default:
                main_console.printf("Junk\n");
                break;
        }
    }
}


/* Testing the temp sensor in a continuous loop */
void read_temperature()
{
    temp_sense.format(8, 3); //set SPI to 8-bit data rate
    while(1) 
    {
        cs = 1;
        temp_sense.write(0x01);
        int temp = temp_sense.write(0x02);
        cs = 0;
        main_console.printf("Temp %d\n", temp);
        wait(0.5);
    }

}