#ifndef _GEN_HELPER_H_
#define _GEN_HELPER_H_

#include "mbed.h"
#include "SDFileSystem.h"

/* Helper class for drawing onto LCD over SPI*/

/*#defines for screen settings and color - based on Adafruit definitions*/
#define SW_RESET            0x01
#define AWAKE_SLEEPMODE     0x11
#define NORMAL_DISP_ON      0x13
#define INVOFF              0x20
#define DISPLAY_ON          0x29
#define COLUMN_ADDR_SET     0x2A
#define ROW_ADDR_SET        0x2B
#define WRITE_RAM           0x2C
#define COLOR_MODE          0x3A
#define ORIENTATION         0x36
#define FRAMERATE_NORMAL    0xB1
#define FRAMERATE_IDLE      0xB2
#define FRAMERATE_PARTIAL   0xB3
#define INVERTED_MODE_OFF   0xB4
#define POWER_CONTROL_1     0xC0
#define POWER_CONTROL_2     0xC1
#define POWER_CONTROL_3     0xC2
#define POWER_CONTROL_4     0xC3
#define POWER_CONTROL_5     0xC4
#define POWER_CONTROL_6     0xC5

//Screen dimensions
#define SCREEN_HEIGHT   160
#define SCREEN_WIDTH    120


// Color definitions
#define BLACK   0x0000
#define BLUE    0x001F
#define RED     0xF800
#define GREEN   0x07E0
#define CYAN    0x07FF
#define MAGENTA 0xF81F
#define YELLOW  0xFFE0
#define WHITE   0xFFFF
#define SKYBLUE 0x6AFFD8
#define BROWN   0x8B5436

//hardcoded definitions for testing
#define HOST_IP_ADDR "143.103.6.188"
#define HOST_GATEWAY "143.103.6.254"
#define HOST_SUBNET  "255.255.255.0"
#define HOST_PORT     80

class gen_helper
{
    
public:

    /* LCD function declarations */
    int spiwrite(uint8_t c);
    void write_spi_command(uint8_t c);
    void write_spi_data(uint8_t c);
    void draw_pixel(int16_t x, int16_t y, uint16_t color);
    void lcd_init();
    void fill_rect(int16_t x0, int16_t y0, int16_t x1, int16_t y1, uint32_t color);
    void write_rgb(uint32_t color, uint32_t repeat);
    void draw_vertical_line(int16_t x, int16_t y, int16_t h, uint16_t color);
    void draw_horizontal_line(int16_t x, int16_t y, int16_t w, uint16_t color);
    void set_screen_coor(uint8_t x0, uint8_t y0, uint8_t x1, uint8_t y1);
    void init_console();
    void rotate_line(float x1, float y1, float x2, float y2, uint16_t alpha, float *X, float *Y);
    void massaged_line(uint16_t x0, uint16_t y0, uint16_t x1, uint16_t y1, float lambda, uint16_t colour, uint16_t *X, uint16_t *Y);
    void drawLine(int16_t x0, int16_t y0,int16_t x1, int16_t y1,uint16_t color);
    void draw_pattern_helper();
    void draw_custom_pattern(int x0, int y0, int x1, int y1);
    void draw_pattern(int x1, int y1, int x2, int y2);

    /* SD card function declarations */
    uint8_t init_disk();
    uint8_t make_dir(char *path, uint32_t mode);
    FILE* open_file(char *path, char *mode);
    uint8_t close_file(FILE *fp);
    uint8_t init_SD();
    uint8_t remove_file(char *path);
    
    void decrease_screen_brightness(float);
    void increase_screen_brightness(float);

    /* CTOR ;  Use the list of pins supported at https://developer.mbed.org/teams/Renesas/wiki/GR-PEACH-rev_B-version-information*/
    gen_helper(PinName MOSI, PinName MISO, PinName SCK, PinName CS, PinName Reset, PinName RS, PinName _USBTX, PinName _USBRX, PwmOut pwm);
    
    PwmOut pwm; //Backlite pin. need to be a private member and have get/set functions
    
private:
    SPI lcd; /* SPI0 - MOSI, MISO, SCK  P10_14, P10_15, P10_12 */
    DigitalOut ssel; // Chip select P10_13
    DigitalOut reset; // Reset signal P3_15
    DigitalOut rs; // Register select P3_14; Problem with rs pin fixed.
    Serial console; //write to the console using serial comm
    SDFileSystem *sd_fs; //SD card file system instance
    
    uint8_t colstart;
    uint8_t rowstart;
    uint8_t _height; //height of the lcd display
    uint8_t _width; //width of the lcd display

};
#endif