#ifndef INC_TWELite
#define INC_TWELite
#include "mbed.h"
#include "string.h"

/** TWE-Lite DIP Remote Monitoring class
*
* This is the class for remote monitoring of TWE-Lite DIP.
*/
class TWELite:public Serial
{
private:
    int flg, flg1;
    int i;
    long stol16(const char *str);
    long nd5, nd8, nda, ndc, ndd, nde1, nde2, nde3, nde4, ndf, ndg;
    long lqi, time, volt, di1, di2, di3, di4, ad1, ad2, ad3, ad4, checksum;
    char data[60];
    char d5[3], d8[5], da[5], dc[3], dd[3], de1[3], de2[3], de3[3], de4[3], df[3], dg[3];
public:
    TWELite(PinName tx, PinName rx);
    void get_twelite();
    int read_flg();
    
    /** read LQI function
    */
    long read_lqi();
    
    /** read time stamp function
    *
    * 64 count per second.
    */
    long read_time();
    
    /** read Power-supply voltage function
    *
    * The unit is [mV].
    */
    long read_volt();
    
    /** read DigitalInput1 value function
    *
    * @retval 0 High
    * @retval 1 Low
    */
    int read_di1();
    
    /** read DigitalInput2 value function
    *
    * @retval 0 High
    * @retval 1 Low
    */
    int read_di2();
    
    /** read DigitalInput3 value function
    *
    * @retval 0 High
    * @retval 1 Low
    */
    int read_di3();
    
    /** read DigitalInput4 value function
    *
    * @retval 0 High
    * @retval 1 Low
    */
    int read_di4();
    
    /** read AnalogInput1 value function
    *
    * The unit is [mV].
    * Max 2000mV.
    */
    long read_ad1();
    
    /** read AnalogInput2 value function
    *
    * The unit is [mV].
    * Max 2000mV.
    */
    long read_ad2();
    
    /** read AnalogInput3 value function
    *
    * The unit is [mV].
    * Max 2000mV.
    */
    long read_ad3();
    
    /** read AnalogInput4 value function
    *
    * The unit is [mV].
    * Max 2000mV.
    */
    long read_ad4();
    
    /** read checksum function
    *
    * @retval 0 Success
    * @retval !0 Failure
    */
    int read_checksum();
};

#endif // INC_TWELite