#include "TWELite.h"
#include "mbed.h"
#include "string.h"

TWELite::TWELite(PinName tx, PinName rx):Serial(tx, rx)
{
    flg = 0, flg1 = 0;
    baud(115200);
    format(8, Serial::None, 1);
    attach(this, &TWELite::get_twelite, Serial::RxIrq);
}

long TWELite::stol16(const char *str)
{
    long value = strtol(str, NULL, 16);
    return value;
}

void TWELite::get_twelite()
{
    i = -1;
    if(getc() == ':') {
        do {
            i++;
            data[i] = getc();
        } while(data[i] != '\r');
        for(; i < 60; i++) data[i] = 0;
    }

    strncpy(d5, data + 8, 2);
    d5[2] = '\0';
    nd5 = stol16(d5);
    strncpy(d8, data + 20, 4);
    d8[4] = '\0';
    nd8 = stol16(d8);
    strncpy(da, data + 26, 4);
    da[4] = '\0';
    nda = stol16(da);
    strncpy(dc, data + 32, 2);
    dc[2] = '\0';
    ndc = stol16(dc);
    strncpy(dd, data + 34, 2);
    dd[2] = '\0';
    ndd = stol16(dd);
    strncpy(de1, data + 36, 2);
    de1[2] = '\0';
    nde1 = stol16(de1);
    strncpy(de2, data + 38, 2);
    de2[2] = '\0';
    nde2 = stol16(de2);
    strncpy(de3, data + 40, 2);
    de3[2] = '\0';
    nde3 = stol16(de3);
    strncpy(de4, data + 42, 2);
    de4[2] = '\0';
    nde4 = stol16(de4);
    strncpy(df, data + 44, 2);
    df[2] = '\0';
    ndf = stol16(df);
    strncpy(dg, data + 46, 2);
    dg[2] = '\0';
    ndg = stol16(dg);

    lqi = nd5;
    time = nd8;
    volt = nda;
    di1 = (ndc & 0x01) >> 0;
    di2 = (ndc & 0x02) >> 1;
    di3 = (ndc & 0x04) >> 2;
    di4 = (ndc & 0x08) >> 3;
    ad1 = ((nde1 * 4) + ((ndf >> 6) & 0x03)) * 4;
    ad2 = ((nde2 * 4) + ((ndf >> 4) & 0x03)) * 4;
    ad3 = ((nde3 * 4) + ((ndf >> 2) & 0x03)) * 4;
    ad4 = ((nde4 * 4) + ((ndf >> 0) & 0x03)) * 4;
    checksum = (ndc + ndd + nde1 + nde2 + nde3 + nde4 + ndf + ndg) & 0xff;
    checksum = (checksum + (~checksum + 1)) & 0xff;

    flg++;
}

int TWELite::read_flg()
{
    if(abs(flg - flg1) > 0) {
        flg1 = flg;
        flg = 0;
        return 1;
    } else {
        return 0;
    }
}

long TWELite::read_lqi()
{
    return lqi;
}

long TWELite::read_time()
{
    return time;
}

long TWELite::read_volt()
{
    return volt;
}

int TWELite::read_di1()
{
    return (int)di1;
}

int TWELite::read_di2()
{
    return (int)di2;
}
int TWELite::read_di3()
{
    return (int)di3;
}
int TWELite::read_di4()
{
    return (int)di4;
}

long TWELite::read_ad1()
{
    return ad1;
}

long TWELite::read_ad2()
{
    return ad2;
}

long TWELite::read_ad3()
{
    return ad3;
}

long TWELite::read_ad4()
{
    return ad4;
}

int TWELite::read_checksum()
{
    return checksum;
}