#include "mbed.h"
#include "USBSerial.h"
#include "USBMSD.h"

// Ring buffer for serial RX data - used by interrupt routines
#define SERIAL_RX_BUFF_LEN 2047
// might need to increase buffer size for high baud rates
char serial_rx_buffer[SERIAL_RX_BUFF_LEN+1];
// Ring buffer pointers
// volatile makes read-modify-write atomic 
volatile int serial_rx_in_inx=0;
volatile int serial_rx_out_inx=0;

// might need to increase buffer size for high baud rates
char vcp_rx_buffer[SERIAL_RX_BUFF_LEN+1];
// Ring buffer pointers
// volatile makes read-modify-write atomic 
volatile int vcp_rx_in_inx=0;
volatile int vcp_rx_out_inx=0;

USBSerial vcp2;
USBSerial vcp3;
USBSerial vcp;

RawSerial pc(SERIAL_TX, SERIAL_RX, 115200);

DigitalOut led1(LED1), led2(LED2), led3(LED3);

// Interupt Routine to read in data from serial port
void vcp_rx_isr_handler( void )
{
    led2 = !led2;
// Loop just in case more than one character is in UART's receive FIFO buffer
// Stop if buffer full
    while( vcp.readable() && ( (vcp_rx_in_inx + 1) % SERIAL_RX_BUFF_LEN != vcp_rx_out_inx ) )
    {
        vcp_rx_buffer[vcp_rx_in_inx] = vcp.getc();        
        vcp_rx_in_inx = (vcp_rx_in_inx + 1) % SERIAL_RX_BUFF_LEN;
    }
    return;
}

// Interupt Routine to read in data from serial port
void serial_rx_isr_handler( void )
{
    led3 = !led3;
// Loop just in case more than one character is in UART's receive FIFO buffer
// Stop if buffer full
    while( pc.readable() && ( (serial_rx_in_inx + 1) % SERIAL_RX_BUFF_LEN != serial_rx_out_inx ) )
    {
        serial_rx_buffer[serial_rx_in_inx] = pc.getc();        
        serial_rx_in_inx = (serial_rx_in_inx + 1) % SERIAL_RX_BUFF_LEN;
    }
    return;
}


int main(void)
{   
    pc.attach(&serial_rx_isr_handler, Serial::RxIrq);
    vcp.attach(&vcp_rx_isr_handler);
    pc.printf("\n\r\n\r\n\r========== USB Device Test ==========\n\r\n\r");    
    vcp.printf("\n\r\n\r\n\r========== USB Device Test ==========\n\r\n\r");
    while (1)
    {
        while( serial_rx_in_inx != serial_rx_out_inx )
        {
            vcp.putc(serial_rx_buffer[serial_rx_out_inx]);
            serial_rx_out_inx = (serial_rx_out_inx + 1) % SERIAL_RX_BUFF_LEN;
            led1 = !led1;
        }
        while( vcp_rx_in_inx != vcp_rx_out_inx )
        {
            pc.putc(vcp_rx_buffer[vcp_rx_out_inx]);
            vcp_rx_out_inx = (vcp_rx_out_inx + 1) % SERIAL_RX_BUFF_LEN;
            led1 = !led1;
        }
    }
}
