#include "SysConfig.h"

void SystemHalt(void)
{   
    uart_db.printf("\n\rOops! System halted! O_o\n\r");
    LedOffAll();
    while(1)
    {
        //Breath LED
        int i, j;
        led_mb = 0;
        while(1)
        {
            for(j=0;j<=100;j++)
            {            
                for(i=0;i<=100;i++)
                {
                    led_mb = 1;
                    wait_us(j);
                    led_mb = 0;
                    wait_us(100-j);
                }
            }
            for(j=100;j>=0;j--)
            {            
                for(i=0;i<=100;i++)
                {
                    led_mb = 1;
                    wait_us(j);
                    led_mb = 0;
                    wait_us(100-j);
                }
            }
            wait_ms(200);
        } 
    }
}

int PeLayerInit(void)
{
    int ret = 0;
    ret += BoardLibInit();
    return ret;
}

int AppLayerInit(void)
{
    return 0;
}

int main(void)
{
    if(PeLayerInit() != 0)   
        SystemHalt();
    
    if(AppLayerInit() != 0) 
        SystemHalt(); 
    
    uart_db.printf("System init done!\n\r");
    DebugCommander();  
    
    //Program should never go to here
    SystemHalt(); 
}
