#ifndef _PE_BD_LIB_
#define _PE_BD_LIB_

class SerialDummy
{
    public:
        void baud(int baudrate) {}
        int printf(const char *format, ...) {return 0;}        
        int readable() {return 0;}
        int writeable() {return 0;}
        int putc(int ch) {return 0;}
        int getc() {return 0;}        
};

//Number of on-board devices
extern const int LED_NUM_MAX;
extern const int MOT_NUM_MAX;
extern const int SRV_NUM_MAX;
extern const int VMON_NUM_MAX;
//The speed difference rate of left/right side motors when the vehicle turns head
extern const int MOT_TURN_RATE;
//Fixed PWM period of servos
extern const int SRV_PERIOD_US;

//LEDs on mother board and daughter board
extern DigitalOut led_mb;

//USART2 to PC for debug

extern Serial uart_pc;
extern SerialDummy uart_dummy;

//GPIO for L293DD motor direction control
//Forward = 2b'01, Backward = 2b'10, Stop = 2b'00
extern BusOut mot1_dir, mot2_dir, mot3_dir, mot4_dir;

//Analog inputs for power voltage monitoring
extern AnalogIn vin_bat;
extern AnalogIn vin_12v;
extern AnalogIn vin_5v;
extern AnalogIn vin_3v;

//TIM3 PWM channels
extern PwmOut mot1_pwm;
extern PwmOut mot2_pwm;
extern PwmOut mot3_pwm;
extern PwmOut mot4_pwm;

//TIM15 PWM channels
extern PwmOut servo1_pwm;
extern PwmOut servo2_pwm;
//TIM16 PWM channels
extern PwmOut servo3_pwm;
//TIM17 PWM channels
extern PwmOut servo4_pwm;

//Init functions
extern int BoardLibInit(void);

//DC motor functions
extern void Mot_Init(void);
extern void Mot_Ctrl(char dir, char turn, float speed);
extern void Mot_PwmSetup(int channel, int period, float duty);
extern void Mot_PwmWrite(int channel, float duty);
extern void Mot_SetDirection(int channel, char dir);

//Motor velocimetoer functions 
void Mot_StartVelocimeter(void);
void Mot_StopVelocimeter(void);
int Mot_GetSpeed(int channel);
void Mot_SpdPluseIntHandler1(void);
void Mot_SpdPluseIntHandler2(void);
void Mot_SpdPluseIntHandler3(void);
void Mot_SpdPluseIntHandler4(void);

//Servo functions
extern void Servo_Init(void);
extern void Servo_SetAngle(int channel, float angle);
extern void Servo_PwmSetup(int channel, int pulse_us);
extern void Servo_PwmWrite(int channel, int pulse_us);

//Voltage monitor functions 
extern float Vmon_ReadVolt(int channel);

//On-board LED functions
extern void LedOn(int ch);
extern void LedOff(int ch);
extern void LedToggle(int ch);
extern void LedOffAll(void);
extern void LedOnAll(void);

#endif
