#include "SysConfig.h"

#define SHT20_ADDR          (0x40<<1)   //SHT20 address
#define SHT20_CMD_TMP_NH    (0xF3)      //Non-hold temp trigger command
#define SHT20_CMD_RH_NH     (0xF5)      //Non-hold temp trigger command

#define i2c_sht20 i2c_sen
//#define uart_db uart_pc

int SHT20_Init(void)
{
    return 0;    
}

float SHT20_ReadTemp(void)
{
    char cmd = SHT20_CMD_TMP_NH, data[3]; 
    float temp;
    
    i2c_sht20.write(SHT20_ADDR, &cmd, 1, 1);
    wait_us(20);
    i2c_sht20.stop();
    
    wait_ms(100);
    i2c_sht20.read(SHT20_ADDR, data, 3);
    #if defined uart_db
    uart_db.printf("\n\rSHT20 return 0x%02X 0x%02X 0x%02X\n\r", data[0], data[1], data[2]);
    #endif
    temp = (256.0 * data[0] + data[1]) * 175.72 / (0x1 << 16) - 46.85;
    return temp;
}

float SHT20_ReadRh(void)
{
    char cmd = SHT20_CMD_RH_NH, data[3]; 
    float rh;
    
    i2c_sht20.write(SHT20_ADDR, &cmd, 1, 1);
    wait_us(20);
    i2c_sht20.stop();
    
    wait_ms(100);
    i2c_sht20.read(SHT20_ADDR, data, 3);
    #if defined uart_db
    uart_db.printf("\n\rSHT20 return 0x%02X 0x%02X 0x%02X\n\r", data[0], data[1], data[2]);
    #endif
    rh = (256.0 * data[0] + data[1]) * 125 / (0x1 << 16) - 6;
    return rh;    
}