#include "SysConfig.h"

#define BMP180_ADDR          (0x40<<1)   //BMP180 address
#define BMP180_CMD_TMP_NH    (0xF3)      //Non-hold temp trigger command
#define BMP180_CMD_RH_NH     (0xF5)      //Non-hold temp trigger command

#define i2c_bmp180 i2c_sen
//#define uart_db uart_pc

int BMP180_Init(void)
{
    return 0;    
}

float BMP180_ReadTemp(void)
{
    char cmd = BMP180_CMD_TMP_NH, data[3]; 
    float temp;
    
    i2c_bmp180.write(BMP180_ADDR, &cmd, 1, 1);
    wait_us(20);
    i2c_bmp180.stop();
    
    wait_ms(100);
    i2c_bmp180.read(BMP180_ADDR, data, 3);
    #if defined uart_db
    uart_db.printf("\n\rBMP180 return 0x%02X 0x%02X 0x%02X\n\r", data[0], data[1], data[2]);
    #endif
    temp = (256.0 * data[0] + data[1]) * 175.72 / (0x1 << 16) - 46.85;
    return temp;
}

float BMP180_ReadRh(void)
{
    char cmd = BMP180_CMD_RH_NH, data[3]; 
    float rh;
    
    i2c_bmp180.write(BMP180_ADDR, &cmd, 1, 1);
    wait_us(20);
    i2c_bmp180.stop();
    
    wait_ms(100);
    i2c_bmp180.read(BMP180_ADDR, data, 3);
    #if defined uart_db
    uart_db.printf("\n\rBMP180 return 0x%02X 0x%02X 0x%02X\n\r", data[0], data[1], data[2]);
    #endif
    rh = (256.0 * data[0] + data[1]) * 125 / (0x1 << 16) - 6;
    return rh;    
}