#ifndef _PE_BD_LIB_
#define _PE_BD_LIB_

//Max number of onboard LEDs
extern const int LED_NUM_MAX;

//I2C for SHT20 & BMP180
extern I2C i2c_sen;

//USART2 to PC, USART1 to sensors & WiFi module
extern Serial uart_pc;
extern Serial uart_sen;

//LEDs on mother board and daughter board
extern DigitalOut led_mb, led_db1_n, led_db2_n; 

//GPIO for CD4052 serial mux control
extern DigitalOut smux_a, smux_b, smux_oe_n;

//ADC for analog sensors
extern AnalogIn adc_ch10, adc_ch11;

//Init functions
extern int BoardLibInit(void);

//Serial mux functions
extern void SerialMuxSel(int ch);
extern void SerialMuxEnable(void);
extern void SerialMuxDisable(void);

//On-board LED functions
extern void LedOn(int ch);
extern void LedOff(int ch);
extern void LedToggle(int ch);
extern void LedOffAll(void);
extern void LedOnAll(void);

#endif