#include "SysConfig.h"

//On-board LED number
const int LED_NUM_MAX = 3;

//I2C for SHT20 & BMP180
I2C i2c_sen(PB_11, PB_10);

//USART2 to PC, USART1 to sensors & WiFi module
Serial uart_pc(SERIAL_TX, SERIAL_RX);
Serial uart_sen(PA_9, PA_10);

//LEDs on mother board and daughter board
DigitalOut led_mb(LED1, 0), led_db1_n(PB_1, 1), led_db2_n(PB_2, 1); 

//GPIO for CD4052 serial mux control
DigitalOut smux_a(PB_14, 0), smux_b(PB_13, 0), smux_oe_n(PB_15, 1);

AnalogIn adc_ch10(PC_0), adc_ch11(PC_1);


//Init board library
//--> Success return 0
int BoardLibInit(void)
{    
    //Init LED status
    LedOnAll();
        
    //Init debug & sensor UART
    uart_pc.baud(115200);
    uart_sen.baud(9600);
    
    //Init sensor I2C
    i2c_sen.frequency(100000);
    
    //Init serial mux chip
    SerialMuxDisable();
    SerialMuxSel(0);  
     
    //Return 0 if success
    return 0; 
}

void SerialMuxSel(int ch)
{
    switch(ch)
    {
        case 1:
            smux_a = 1;
            smux_b = 0;
            break;  
            
        case 2:
            smux_a = 0;
            smux_b = 1;
            break;  
            
        case 3:
            smux_a = 1;
            smux_b = 1;
            break;  
            
            
        case 0:
        default:
            smux_a = 0;
            smux_b = 0;
            break;    
    }    
}

void SerialMuxEnable(void)
{
    smux_oe_n = 0;       
}

void SerialMuxDisable(void)
{
    smux_oe_n = 0;       
}

void LedOn(int ch)
{
    switch(ch)
    {
        case 0:
            led_mb = 1;
            break;  
            
        case 1:
            led_db1_n = 0;
            break;  
            
        case 2:
            led_db2_n = 0;
            break;  
            
        default:
            break;   
    }           
}

void LedOff(int ch)
{
    switch(ch)
    {
        case 0:
            led_mb = 0;
            break;  
            
        case 1:
            led_db1_n = 1;
            break;  
            
        case 2:
            led_db2_n = 1;
            break;  
            
        default:
            break;   
    }           
}

void LedToggle(int ch)
{
    switch(ch)
    {
        case 0:
            if(led_mb)
                led_mb = 0;
            else
                led_mb = 1;
            break;  
            
        case 1:
            if(led_db1_n)
                led_db1_n = 0;
            else
                led_db1_n = 1;
            break;  
            
        case 2:
            if(led_db2_n)
                led_db2_n = 0;
            else
                led_db2_n = 1;
            break;  
            
        default:
            break;   
    }           
}

void LedOnAll(void)
{
    for(int ledNum = 0; ledNum < LED_NUM_MAX; ledNum++)
        LedOn(ledNum);    
}

void LedOffAll(void)
{
    for(int ledNum = 0; ledNum < LED_NUM_MAX; ledNum++)
        LedOff(ledNum);    
}
