#include "SysConfig.h"

#define UV_LV_MAX   11
#define UV_SMP_AVG  5
const int UvLvTable[] = {50, 227, 318, 408, 503, 606, 696, 795, 881, 976, 1079, 1170};

#define i2c_uv i2c_sen
//#define uart_db uart_pc

int UV_Init(void)
{
    return 0;    
}

float UV_ReadVolt(void)
{    
    return(adc_ch10.read() * 3300);
}

float UV_ReadLv(void)
{
    int i;
    float volt = 0, level;
    for(i=0; i<UV_SMP_AVG; i++)
        volt += UV_ReadVolt();
    volt = volt / UV_SMP_AVG ;
    
    if(volt < (float)UvLvTable[0])
    {
        level = 0;  
        return level;
    }
    
    if(volt > (float)UvLvTable[UV_LV_MAX])
    {
        level = 11;
        return level;
    }
    
    for(i=0; i<UV_LV_MAX; i++)
    {
        if(volt > (float)UvLvTable[i] && volt < (float)UvLvTable[i+1])
        {
            level = i + (volt - UvLvTable[i]) / (UvLvTable[i+1] - UvLvTable[i]);
            return level;
        }
    }
    
    return -1;
}