#include "SysConfig.h"

#define SMUX_MHZ19  0
#define SMUX_ZPH01  1
#define SMUX_ESP01  2
#define SMUX_ZE08   3

#define uart_db uart_pc

void LedFlasher(void)
{
    int ledNumOn;
    for(ledNumOn = 1; ledNumOn < LED_NUM_MAX; ledNumOn++)
    {
        LedOffAll();
        LedOn(ledNumOn);
        wait_ms(300);
    }
}

void DebugFunc_CO2(void)
{
    uart_db.printf("Reading MHZ19...");
    SerialMuxSel(SMUX_MHZ19);
    int co2Vol = MHZ19_ReadCO2();
    if(co2Vol < 0)
        uart_db.printf("CheckSum Error!\n\r");
    else
        uart_db.printf("OK!\n\rCO2 Vol = %dppm.\n\r\n\r", co2Vol);    
}

void DebugFunc_PM25(void)
{
    float pm25Vol = 0, pm25VolAvg = 0;
    int cnt = 0, cnt_max = 30;
    uart_db.printf("Reading ZPH01 (need %dsec)", cnt_max);
    SerialMuxSel(SMUX_ZPH01);
    
    while(cnt < cnt_max)
    {
        pm25Vol = ZPH01_ReadPM25();
        if(pm25Vol < 0)
        {
            uart_db.printf("CheckSum Error!\n\rRepeat reading");
        }
        else
        {
            pm25VolAvg += pm25Vol;
            uart_db.printf(".");
            //uart_db.printf("Single sample = %fug/m^3.\n\r", pm25Vol);
            cnt++;
        }
    }    
    pm25VolAvg = pm25VolAvg / cnt_max;
    uart_db.printf("OK!\n\rPM2.5 Vol = %fug/m^3.\n\r\n\r", pm25VolAvg);
}

void DebugFunc_CH2O(void)
{
    uart_db.printf("Reading ZE08...");
    SerialMuxSel(SMUX_ZE08);
    int ch2oVol = ZE08_ReadCH2O();
    if(ch2oVol < 0)
        uart_db.printf("CheckSum Error!\n\r");
    else
        uart_db.printf("OK!\n\rCH2O Vol = %dug/m^3.\n\r\n\r", ch2oVol);                              
}

void DebugFunc_TempRh(void)
{
    uart_db.printf("Reading SHT20...");
    float temp = SHT20_ReadTemp();
    float rh = SHT20_ReadRh();
    uart_db.printf("OK!\n\rTemperature = %.2f, Humidity = %2.f\n\r\n\r", temp, rh);                
}

void DebugFunc_AirPress(void)
{
    uart_db.printf("Air pressure test not implemented...\n\r");
}

void DebugFunc_UvLevel(void)
{
    uart_db.printf("UV level test not implemented...\n\r");
}

void DebugFunc_WiFi(void)
{
    uart_db.printf("WiFi test not implemented...\n\r");
}

void DebugFunc_SwitchSmux(void)
{
    uart_db.printf("Please type SMUX channel(0~3) with ENTER.\n\r");
    while(!uart_db.readable());
    uint8_t ch = uart_db.getc();
    SerialMuxSel(ch - '0');
    uart_db.printf("Switched to ch %c.\n\r", ch);    
}

void DebugCommander(void)
{   
    int quitFlag = 0, cmdPc;
    while(!quitFlag)
    {             
        uart_db.printf("\n\r\n\r============ AirBox Nucleo Adaptor Demo ============\n\r\n\r");
        uart_db.printf(" 0. All sensors auto Test.\n\r");        
        uart_db.printf(" 1. Test CO2 gas sensor.\n\r");
        uart_db.printf(" 2. Test PM2.5 dust sensor.\n\r");        
        uart_db.printf(" 3. Test CH2O gas sensor.\n\r");
        uart_db.printf(" 4. Test temperature & humidity sensor.\n\r");
        uart_db.printf(" 5. Test air pressure sensor.\n\r");
        uart_db.printf(" 6. Test UV light level.\n\r");
        uart_db.printf(" w. Test WiFi module.\n\r");
        uart_db.printf(" m. Manual switch SMUX channel.\n\r");        
        uart_db.printf(" q. Exit demo.\n\r\n\r");
        uart_db.printf(" Input:\n\r\n\r");
                              
        while(!uart_db.readable())
        {
            #if 0
            if(uart_sen.readable())
                uart_db.printf(" <0x%02X> ", uart_sen.getc());
            #endif
        }
        cmdPc = uart_db.getc();
        
        switch(cmdPc)
        {
            case 'q':
                quitFlag = 1;
                uart_db.printf("\n\rExiting demo...\n\r");
                break;  
                
            case 'm':
                DebugFunc_SwitchSmux();
                break;        
                      
            case 'w':
                DebugFunc_WiFi();
                break;         
                 
            case '0':
                DebugFunc_CO2();
                DebugFunc_CH2O();
                DebugFunc_PM25();                 
                DebugFunc_TempRh();
                DebugFunc_AirPress();
                DebugFunc_UvLevel();   
                break;
                
            case '1':
                DebugFunc_CO2();
                break;

            case '2':
                DebugFunc_PM25();
                break;
                
            case '3':                    
                DebugFunc_CH2O();
                break;
                
            case '4':
                DebugFunc_TempRh();
                break;
  
            case '5':
                DebugFunc_AirPress();
                break;
                
            case '6':
                DebugFunc_UvLevel();
                break;    
                
            case 'z':
                MHZ19_CalZero();
                break;    
                
                
            case 'f':
                MHZ19_CalFull();
                break;  
            
            default:
                uart_db.printf("Incorrect input!\n\r");
                break;
        }
    
        uart_db.printf("\n\rPress any key...\n\r");
                          
        while(!uart_db.readable());
        cmdPc = uart_db.getc();
        
    }    
    
}
 