#include "SysConfig.h"

#define uart_db uart_pc

void SystemHalt(void)
{   
    #if defined uart_db
    uart_db.printf("\n\rOops! System halted! O_o\n\r");
    #endif
    LedOffAll();
    while(1)
    {
        LedToggle(0);
        wait_ms(500);
    }
}

int PeLayerInit(void)
{
    int ret = 0;
    ret += BoardLibInit();
    ret += SHT20_Init();  
    
    SerialMuxEnable();
    SerialMuxSel(0);   
    ret += MHZ19_Init();
    
    SerialMuxSel(1);   
    ret += ZPH01_Init();
    
    SerialMuxSel(2); 
    //ret += ESP01_Init();
    
    SerialMuxSel(3);   
    ret += ZE08_Init();
    return ret;
}

int AppLayerInit(void)
{
    return 0;
}

int main(void)
{
    if(PeLayerInit() != 0)   
        SystemHalt();
    
    if(AppLayerInit() != 0) 
        SystemHalt(); 
            
    DebugCommander();  
    
    //Program should never go to here
    SystemHalt(); 
}
