#include "SysConfig.h"

#define ZE08_CMD_LEN   9
#define ZE08_DAT_LEN   9

#define uart_ze08 uart_sen
//#define uart_db uart_pc

const uint8_t ZE08_CmdManualMode[ZE08_CMD_LEN] = {0xFF, 0x01, 0x78, 0x41, 0x00, 0x00, 0x00, 0x00, 0x46};
const uint8_t ZE08_CmdReadCH2O[ZE08_CMD_LEN] = {0xFF, 0x01, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x79};

int ZE08_Init(void)
{
    //Change ZE08 to manual request & reply mode
    for(int i=0; i<ZE08_CMD_LEN; i++)
        uart_ze08.putc(ZE08_CmdManualMode[i]);
    
    return 0;    
}

int ZE08_ReadCH2O(void)
{
    int ch2oVol, i, sum = 0; 
    uint8_t data[ZE08_DAT_LEN];
           
    for(i=0; i<ZE08_CMD_LEN; i++)
        uart_ze08.putc(ZE08_CmdReadCH2O[i]);
        
    #if defined uart_db
    uart_db.printf("\n\rZE08 return ");
    #endif
        
    for(i=0; i<ZE08_DAT_LEN; i++)
    {
        while(!uart_ze08.readable());
        data[i] = uart_ze08.getc();
        #if defined uart_db
        uart_db.printf("0x%02X ", data[i]);
        #endif
    }    
    
    #if defined uart_db
    uart_db.printf(".\n\r");
    #endif
    
    sum = ZE08_CalCheckSum(data);
    if(data[ZE08_DAT_LEN - 1] == sum)
    {
        ch2oVol = data[2] *256 + data[3];
        return ch2oVol;
    }
    else
    {
        #if defined uart_db
        uart_db.printf("Incorrect checksum 0x%02X, expect 0x%02X.\n\r", sum, data[ZE08_DAT_LEN - 1]);
        #endif
        return -1;
    }
}

uint8_t ZE08_CalCheckSum(uint8_t *packet)
{
    uint8_t i, checksum = 0;
    for( i = 1; i < 8; i++)
    {
        checksum += packet[i];
    }
    checksum = 0xff - checksum;
    checksum += 1;
    return checksum;
}
