#include "SysConfig.h"

//ACK waiting time: 2000ms
#define ESP01_ACK_TIMEOUT    5000

#define uart_esp uart_sen
#define uart_db uart_pc

//For serial waiting timeout counting
Timer timer_esp;

string ESP01_CmdInitMixMode = "CWMODE=3";
string ESP01_CmdInitApInfo = "CWSAP=\"AirBoxProto01\",\"12345678\",6,3";
string ESP01_CmdReset = "AT+RST";
string ESP01_CmdMuxConnEn = "AT+CIPMUX=1";
string ESP01_CmdInitTcpSvr = "AT+CIPSERVER=1,2222";

int ESP01_Init(void)
{
    if(ESP01_InterfaceCheck() != 0)
    {
        #if defined uart_db
        uart_db.printf("ESP01_InterfaceCheck failed!\n\r");
        #endif
        return -1;   
    }
    
    ESP01_SendAtCmd(ESP01_CmdInitMixMode);
        
    ESP01_SendAtCmd(ESP01_CmdInitApInfo);
    
    ESP01_SendAtCmd(ESP01_CmdReset);
    
    wait_ms(8000);
    
    ESP01_SendAtCmd(ESP01_CmdMuxConnEn);
    
    ESP01_SendAtCmd(ESP01_CmdInitTcpSvr);
    
    return 0;   
}

int ESP01_AckCheck(void)
{   
    int timeStart;
    string data;
    timer_esp.start();
    timeStart = timer_esp.read_ms();
    
    while(timer_esp.read_ms() - timeStart < ESP01_ACK_TIMEOUT)
    {
        if(uart_esp.readable())
        {
            while(uart_esp.getc() == 'O')
            {
                if(uart_esp.getc() == 'K')
                    return 0;
            }     
        }  
    }
    
    timer_esp.stop();
    timer_esp.reset();
    uart_db.printf("ESP01_AckCheck timeout %dms!\n\r", ESP01_ACK_TIMEOUT); 
    return -2;
}

int ESP01_InterfaceCheck(void)
{
    uart_esp.printf("AT\r\n");
    return ESP01_AckCheck();
}

void ESP01_SendAtCmd(string strCmd)
{
    uart_esp.printf("AT+%s\r\n", strCmd.c_str());
}

