//#define __SERIAL_DEBUG__

#define NUM_OF_COLORS           4
#define LED_PWM_PERIOD          5 //msec
#define NORM_LIGHT_INTENS       (15*LED_PWM_PERIOD * 1000)/100 //in usec =  30% of LED_PWM_PERIOD
#define LOW_LIGHT_INTENS        (7*LED_PWM_PERIOD * 1000)/100 //in usec = 15% of LED_PWM_PERIOD
#define BUTTON_PRESS_THR        5
#define BUTTON_RELEASE_THR      10
#define VBAT_AVG_LEN            8
#define VBAT_THR                34000 //about 3.15V per cell
#define VBAT_HYST               1000
#define MPU_BUFFER_LEN          100 
#define MPU_DATA_STABLE         1000
#define MPU_AVG_LEN             16
#define ACCEL_THR               4000 //1g
#define YPR_THR                 450  //45 degrees

#define TRUE                    true
#define FALSE                   false

typedef enum {
  BLUE = 0,
  GREEN,
  PURPLE,
  RED
} color_type;


// function prototypes
bool motion_sensor_init();
bool motion_update_data(MPU_data_type * new_data);
void mpu_calc_avg(MPU_data_type * MPU_data,int mpu_pointer, MPU_data_type * MPU_avg_data, int avg_len);
void init_color(int *new_color, int pulsewidth);
void change_color(color_type new_color, int new_pulsewidth);
bool sound_player(const int sound_table[][6], int table_lines);
