#ifndef MAX31855_h
#define MAX31855_h

#include "mbed.h"

#define CHECK_BIT(variable ,position) ((variable) & (1<<(position)))

class max31855
{     
  public:
    typedef enum {
    THERMO_1,
    THERMO_2
    } THERMOCOUPLES;
      
    max31855(SPI& _spi, PinName _ncs1, PinName _ncs2);
    bool ready();
    float read_temp(THERMOCOUPLES thermo);
    void initialise(uint32_t interval);
    
  private:
    SPI& _spi;
    DigitalOut _CS_1, _CS_2;
    Timer _pollTimer;
    uint32_t _readInterval;
    int _units, _faultCode;
    float _error, _chipTemp;
    
    void select(THERMOCOUPLES thermo);
    void deselect(THERMOCOUPLES thermo);
};

#endif
