#include <mbed.h>
#include "max31855.h"

max31855::max31855(SPI& _spi, PinName ncs1, PinName ncs2) : _spi(_spi), _CS_1(ncs1), _CS_2(ncs2)
{

}

float max31855::read_temp(max31855::THERMOCOUPLES thermo)
{
    short value = 0;
    float temp = 0;
    //Variables to hold probe temperature
    uint8_t tempProbeHigh=0;
    uint8_t tempProbeLow=0;
    //Variables to hold chip temperature and device status
    uint8_t tempChipHigh=0;
    uint8_t tempChipLow=0;
    //Set CS to initiate transfer and stop conversion
    select(thermo);
    //Read in Probe tempeature
    tempProbeHigh = _spi.write(0);
    tempProbeLow = _spi.write(0);
    //Get the chip temperature and the fault data
    tempChipHigh = _spi.write(0);
    tempChipLow = _spi.write(0);
    //Set the chip temperature
    _chipTemp = (tempChipHigh<<4 | tempChipLow>>4)*0.0625;
    //Set CS to stop transfer and restart conversion
    deselect(thermo);
    if (CHECK_BIT(tempProbeLow, 0)) {
        //not connected error
        if(CHECK_BIT(tempChipLow, 0))return -2;
        //short to ground
        else if(CHECK_BIT(tempChipLow, 1))return -3;
        //short to VCC
        else if(CHECK_BIT(tempChipLow, 2))return -4;
        else return -5;
    } else {
        //Integer value of temperature
        value = (tempProbeHigh<< 6 | tempProbeLow>>2);
        //Get actual temperature (last 2 bits of integer are decimal 0.5 and 0.25)
        temp = (value*0.25); // Multiply the value by 0.25 to get temp in C or
        //  * (9.0/5.0)) + 32.0;   // Convert value to F (ensure proper floats!)
        return temp;
    }
}

void max31855::select(THERMOCOUPLES thermo)
{
    //Set CS low to start transmission (interrupts conversion)
    if(thermo == THERMO_1) _CS_1 = 0;
    else _CS_2 = 0;
}

void max31855::deselect(THERMOCOUPLES thermo)
{
    //Set CS high to stop transmission (restarts conversion)
    if(thermo == THERMO_1) _CS_1 = 1;
    else _CS_2 = 1;
    _pollTimer.reset();
}

void max31855::initialise(uint32_t interval)
{
    //Start the conversion timer
    _readInterval = interval;
    _pollTimer.start();
    _faultCode=0;
}

bool max31855::ready()
{
    //Check to see if conversion is complete
    if(_pollTimer.read_ms() > _readInterval ) return true;
    else return false;
}