#define APP_VERSION     0.6f
#define MQTT_VERSION    3
#define BROKER_NAME     "broker.hivemq.com"
#define BROKER_PORT     1883

#include "debounce_button.h"
#include "EthernetInterface.h"
#include "MQTTNetwork.h"
#include "MQTTmbed.h"
#include "MQTTClient.h"

/**
    TODO
    ----
    -   Check if the button has been pressed. If so, print the amount of clicks to a serial terminal.
    -   Make an MQTT-service which:
        -   starts up a network using EthernetInterface. Make sure the development board requests its address via DHCP.
        -   makes a client and connects it to the broker using a client ID and credentials (username & password).
        -   sends messages at the same topic as the smartphone app from PGO 2. Feel free to choose which Quality of Service
            you are going to use. Make a separate function which handles the sending procedure. Therefore, this function
            can be called each time we want to send a certain message.
    -   When the button is pressed once, we send an upvote. When pressed twice, a downvote is sent. By pressing 4 times,
        the program disconnects from the broker and terminates.
        
    Extra
    -----
    -   Subscribe to the topic on which the song data is published. Display this received message on the serial terminal.
    -   Test this controller in the complete system of PGO 2. Use these controllers instead of the smartphones.
    
    Tips & tricks
    -------------
    -   To generate an interrupt on the press of a button, use:
            InterruptIn button(USER_BUTTON);
            ...
            button.fall(callback(someFunction));
    -   Before implementing MQTT, test the multiclick feature first.
    -   Have a look at the MQTT-library for Mbed and the HelloMQTT-example.
    -   To have a uniform message sending procedure, use the following function usage:
            sendMessage(&client, topic, buf, qos, retained, duplicate)
*/

char* topic;
//char* buf;
InterruptIn button1(USER_BUTTON);

void sendMessage(MQTT::Client<MQTTNetwork, Countdown> &client, char* topic, char* msg, bool retained, bool dup) {
    char buf[100];
    sprintf(buf, msg);
    MQTT::Message message;
    message.qos = MQTT::QOS0;
    message.retained = retained;
    message.dup = dup;
    message.payload = (void*)buf;
    message.payloadlen = strlen(buf)+1;
    client.publish(topic, message);
}

int main(int argc, char* argv[])
{
    printf("Starting vote controller...\n\r");
    button1.fall(callback(button1_onpressed_cb));
    
    EthernetInterface eth;
    eth.connect();
    printf("Ethernet initialized: IP %s\n\r", eth.get_ip_address());
    
    MQTTNetwork mqtt(&eth);
    MQTT::Client<MQTTNetwork, Countdown> client(mqtt);
    int rc = mqtt.connect(BROKER_NAME, BROKER_PORT);
    if(rc != 0) {
        printf("MQTT connection failed!\r\n");
    }
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = MQTT_VERSION;
    data.clientID.cstring = "niels";
    data.username.cstring = "niels";
    data.password.cstring = "niels";
    rc = client.connect(data); 
    if(rc != 0) {
        printf("Client connection failed!\n\r");
    }
    
    topic = "niels";
        
    bool running = true;
    while(running) {
        if(multiclick_state != 0) {
            //printf("%d\n\r", multiclick_state);
            switch(multiclick_state) {
                case 1:
                    printf("Upvoting\n\r");
                    sendMessage(client, topic, "upvote", false, false);
                    break;
                case 2:
                    printf("Downvoting\n\r");
                    sendMessage(client, topic, "downvote", false, false);
                    break; 
                case 4:
                    printf("Terminating\n\r");
                    running = false;
                    mqtt.disconnect();
                    break;
                default:
                    break;   
            }
            multiclick_state = 0;
        }
    }

    return 0;
}
