#include "mbed.h"
#include "TS_DISCO_F469NI.h"
#include "LCD_DISCO_F469NI.h"
#include <stdio.h>
#include <stdlib.h>

enum {
    LEFT,
    RIGHT
};


LCD_DISCO_F469NI lcd;
TS_DISCO_F469NI ts;

int main()
{
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t direction, decisionCounter, countdown;
    uint8_t firstDecision;
    uint8_t text[30] = "";
    uint8_t status;
    uint8_t fingerPress;
    time_t t;
    Point points[4];

    /* Intializes random number generator */
    srand((unsigned) time(&t));

    BSP_LCD_SetFont(&Font24);
    
    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());

    home:
    decisionCounter = 1;
    firstDecision = 1;
    fingerPress = 0;
    if (status != TS_OK) {
        lcd.Clear(LCD_COLOR_RED);
        wait(0.1);//apparently we have to wait a bit after Clear
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
        goto end;
    } else {
        lcd.Clear(LCD_COLOR_DARKGREEN);
        wait(0.1);//apparently we have to wait a bit after Clear
        lcd.SetBackColor(LCD_COLOR_DARKGREEN);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        //lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"READY TO CHOSE YOUR LIFE", CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(8), (uint8_t *)"TOUCH TO DECIDE", CENTER_MODE);
    }

    lcd.SetBackColor(LCD_COLOR_LIGHTGRAY);
    lcd.SetTextColor(LCD_COLOR_BLACK);

    while(1) {
        ts.GetState(&TS_State);
        if (TS_State.touchDetected && fingerPress==0) {//finger lands
            fingerPress = 1;
            /* get landing poosition */
            x = TS_State.touchX[0];
            y = TS_State.touchY[0];
            /* countdown */
            if(firstDecision){
                firstDecision = 0;
                lcd.Clear(LCD_COLOR_LIGHTGRAY);
                wait(0.1);//apparently we have to wait a bit after Clear
                for(countdown=10 ; countdown>0 ; countdown--){
                    lcd.ClearStringLine(10);
                    sprintf((char*)text, "Downloading cosmos energy...");
                    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)&text, CENTER_MODE);
                    sprintf((char*)text, "%d", countdown);
                    lcd.DisplayStringAt(0, LINE(10), (uint8_t *)&text, CENTER_MODE);
                    wait(1.0);
                }
            }
            else{//finger lands, not the first decision
                if(x>lcd.GetXSize()-100 && y<100) goto home;
            }
            lcd.Clear(LCD_COLOR_LIGHTGRAY);
            wait(0.1);//apparently we have to wait a bit after Clear

            /* display return home button */
            lcd.SetTextColor(LCD_COLOR_DARKGREEN);
            lcd.FillRect(lcd.GetXSize()-100,0,100,100);
            lcd.SetBackColor(LCD_COLOR_DARKGREEN);
            lcd.SetTextColor(LCD_COLOR_WHITE);
            wait(0.01);
            sprintf((char*)text, "HOME");
            lcd.DisplayStringAt(10, LINE(1)+10, (uint8_t *)&text, RIGHT_MODE);

            /* other colors */
            lcd.SetBackColor(LCD_COLOR_LIGHTGRAY);
            lcd.SetTextColor(LCD_COLOR_BLACK);

            /* decision counter */
            sprintf((char*)text, "Decision#:%d", decisionCounter++);
            lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);

            /* decision of direction*/
            direction = rand()%2;
            switch(direction) {
                case LEFT:
                    sprintf((char*)text, "Masterchief");
                    /*
                    //horizontal bar
                    lcd.FillRect(250,300,300,20);
                    //top diagonal
                    points[0].X=250;
                    points[0].Y=300;
                    points[1].X=250+80;
                    points[1].Y=300-70;
                    points[2].X=250+20+80;
                    points[2].Y=300-70;
                    points[3].X=250+20;
                    points[3].Y=300;
                    lcd.FillPolygon(points, 4);
                    //bottom diagonal
                    points[0].X=250;
                    points[0].Y=300+20;
                    points[1].X=250+80;
                    points[1].Y=300+70+20;
                    points[2].X=250+20+80;
                    points[2].Y=300+70+20;
                    points[3].X=250+20;
                    points[3].Y=300+20;
                    lcd.FillPolygon(points, 4);
                    */
                    break;
                case RIGHT:
                    sprintf((char*)text, "The Office");
                    /*
                    //horizontal bar
                    lcd.FillRect(250,300,300,20);
                    //top diagonal
                    points[0].X=250+300-20;
                    points[0].Y=300;
                    points[1].X=250+300-20-80;
                    points[1].Y=300-70;
                    points[2].X=250+300-80;
                    points[2].Y=300-70;
                    points[3].X=250+300;
                    points[3].Y=300;
                    lcd.FillPolygon(points, 4);
                    //bottom diagonal
                    points[0].X=250+300-20;
                    points[0].Y=300+20;
                    points[1].X=250+300-20-80;
                    points[1].Y=300+70+20;
                    points[2].X=250+300-80;
                    points[2].Y=300+70+20;
                    points[3].X=250+300;
                    points[3].Y=300+20;
                    lcd.FillPolygon(points, 4);
                    */
                    break;
            }
            //display text of direction
            lcd.DisplayStringAt(0, LINE(6), (uint8_t *)&text, CENTER_MODE);
        }
        if(!TS_State.touchDetected && fingerPress==1) {//finger takes off
            fingerPress = 0;
        }
        if(!TS_State.touchDetected) {//finger is flying
        }
        if(TS_State.touchDetected) {//finger is on the ground
        }
    }
    end:
    {}
}
