/*
Nicolas Manceau
Polytech - DII4A
05/06/2018
*/

#include "mbed.h"
#include "BME280.h"

//Serial pc(USBTX, USBRX);
#if defined(TARGET_LPC1768)
BME280 sensor(p28, p27);
#else
BME280 sensor(I2C_SDA, I2C_SCL);
#endif

#define SIG_RX_CAN  0x01

DigitalOut led1(LED1);
DigitalOut led2(LED2);

Thread threadA;
Thread threadB;
Thread threadC;
  
CAN CanPort(p30, p29);
CANMessage  MessageRx; 
CANMessage  MessageTx;

unsigned int    Id;
signed char temperature;
unsigned char humidite;
unsigned short pression;
unsigned char pression_1;
unsigned char pression_2;

void canReader(void)
{
    if (CanPort.read(MessageRx))
    {
            led1 = !led1;
            threadA.signal_set(SIG_RX_CAN);
    }   
} 
 

void thA() 
{
    while(true)
    {
        Thread::signal_wait(SIG_RX_CAN);    
        led2 = !led2;
        printf("RX FRAME ID = %X\n",MessageRx.id);
    }
}
 
void thB() 
{
    while (true) 
    {
    led1 = !led1;   
    printf("CAPTEUR TEMPERATURE\n");
    MessageTx.id=Id;
    CanPort.write(MessageTx);
    wait(1);   
    }
}

void thC() 
{
    while (true) 
    {
            //Récupération de la température dans une variable signée char (1 octet)
            temperature = sensor.getTemperature();
            //Récupération de la presion atmosphérique dans une variable non signée short (2 octets)
            pression = sensor.getPressure();
            //Récupération de l'humidité dans une variable signée char (1 octet)
            humidite = sensor.getHumidity();
            
            //Affectation de la tempèrature dans le premier octet de donnée
            MessageTx.data[0] = temperature;
            
            //Séparation de la pression atmosphérique en 2 octets
            pression_1 = pression & 0b11111111;
            pression_2 = pression >> 8;
            
            //Affectation de la pression dans le deuxième et troisème octets de donnée
            MessageTx.data[1] = pression_2;
            MessageTx.data[2] = pression_1;
            
            //Affectation de l'humidité dans le quatrième octet de donnée
            MessageTx.data[3] = humidite; 
            
            wait(1);  
    }
}

int main() 
{
    CanPort.frequency(20000);
    
    //Définition de l'ID conformément au protocole applicatif définit
    Id = 0x002;
    //Définition du nombre d'octet de donnée
    MessageTx.len=4;
    
    //CAN Standard  
    MessageTx.format = CANStandard;
    //MessageTx.format = CANExtended;
    
    MessageTx.type = CANData;
    //MessageTx.type = CANRemote;
    
    CanPort.attach(canReader,CAN::RxIrq);
    
    //Création des threads    
    threadA.start(thA);
    threadB.start(thB);
    threadC.start(thC);
    
    led1 = 0;
    printf("Start OK\n");

    while (true) 
        {
        }
}

