//lO UNICO DIFERENTE AL CODIGO ES PwmOut motor_x(A3), motor_y(A1), motor_z(A0);
#include "mbed.h"
#include "stepmotor.h"

#define MEM_SIZE 5000
#define MEM_TYPE uint32_t
#define MAXPOS 50       // en milimetros
#define SS_TIME 100     // en microsegundos
#define POSDRAW 10   
#define periodo 20
#define CM_EJECUTAR 0xff
#define CM_GUARDAR 0xfe
#define CM_VERTEX2D 0xfd
#define CM_DRAW 0xfc
#define CM_NODRAW 0xfb
#define CM_STOP 0xfa
#define CM_END 0xf0
#define CM_SMOTOR 0xf9

MEM_TYPE arreglo2[MEM_SIZE];
Serial pc(USBTX, USBRX); 
PwmOut motor_x(PB_4), motor_y(PB_5), motor_z(PB_3);
stepmotor smotor1(D9,D10,D11,D12);
stepmotor smotor2 (PA_13,PA_14,PA_15,PB_7);
int mem_head = 0,i=0,z=0;
int mem_tail = 0;
uint8_t full = 0;
char b,verificar=0;
MEM_TYPE comando,px,py,condicionf;


int coord2us(float coord)
{
    if(0 <= coord <= MAXPOS)
        return int(750+coord*1900/50);// u6
    return 750;
 
}
 
void draw()
{
    z=coord2us(POSDRAW);
    motor_z.pulsewidth_us(z);
    wait(1);
}

void nodraw()
{  
    z=coord2us(MAXPOS);
    motor_z.pulsewidth_us(z);
    wait(1);
}

void vertex2d(float x, float y){
 
    int pulseX = coord2us(x);
    int pulseY = coord2us(y);
    
    motor_x.pulsewidth_us(pulseX);
    motor_y.pulsewidth_us(pulseY);
    wait_ms(SS_TIME);
 
}
///////////////////////////////////////////////////////
void ejecutar()
{
    MEM_TYPE bandera=0;
    if (mem_head==0) {pc.printf("no hay datos para ejecutar\r\n");}
    else
    { 
        pc.printf("se esta ejecutando el dibujo...\r\n");  
        for(i=0;i<mem_head-1;i++)
        {
            uint32_t speed=1500;
            smotor1.set_speed(speed); 
            bandera=arreglo2[i];
            switch (bandera)
            {
                case CM_DRAW: draw();break;
                case CM_NODRAW: nodraw(); break;
                default:
                    verificar = (uint8_t)(bandera>>16);
                    int x = (uint8_t)(bandera>>8);
                    int y = (uint8_t)(bandera);
                    if (verificar==CM_SMOTOR){smotor1.step((uint32_t)x,(bool)y);}
                    if (verificar==CM_VERTEX2D){vertex2d(x,y);}
                break;
            }
        }
    }
}
 uint32_t read_command()
{
   
    uint32_t val=0;
    uint8_t  cnt=0;
    
    char endc=pc.getc();
    
    while(endc != CM_END && cnt <4) {
    if(endc!=CM_END)   
        val=((val<<8) +endc);
     endc=pc.getc();
     cnt++;
    }   
    if(endc==CM_END)   
        return val;
    return 0;   //al retornar 0 indica que  no se recibe el comando  
}
/////////////////////////////////////////////////////////////
void guardar()
{
    pc.printf("se inicia el comado de guardar..\r\n");    
    mem_head=0;
            do
            {
                pc.printf("entro while llenar\n\r");
                arreglo2[mem_head]= read_command();
                b=arreglo2[mem_head];
                pc.printf("posicion %i se lleno con %x\r\n",mem_head,arreglo2[mem_head]);
                mem_head++;  
            }
            while(b!=CM_STOP);
    
 }
 ///////////////////////////////////////////////////////

 
int main() 
{
    // configuracion de  periodo
    motor_x.period_ms(periodo);
    motor_y.period_ms(periodo);
    motor_z.period_ms(periodo);
    motor_x.pulsewidth_us(750);
    motor_y.pulsewidth_us(750);
    motor_z.pulsewidth_us(2650);
    char caracter;
    while(1)
    {
        caracter=read_command();
        switch (caracter) 
        {
            case  CM_EJECUTAR: ejecutar(); break;
            case  CM_GUARDAR: guardar(); break;
            default: pc.printf("error de comando\r\n");break;      
        }
    }
}