#include "mbed.h"
#define MEM_SIZE 5000
#define MEM_TYPE uint32_t
#define MAXPOS 50       // en milimetros
#define SS_TIME 100     // en microsegundos
#define POSDRAW 10   
#define periodo 20
#define CM_EJECUTAR 0xff
#define CM_GUARDAR 0xfe
#define CM_VERTEX2D 0xfd
#define CM_DRAW 0xfc
#define CM_NODRAW 0xfb
#define CM_STOP 0xfa
#define CM_END 0xf0

MEM_TYPE arreglo2[MEM_SIZE];
Serial pc(USBTX, USBRX); 
PwmOut motor_x(A3), motor_y(A1), motor_z(A0);
int mem_head = 0,i;
int mem_tail = 0;
uint8_t full = 0;
char b;
MEM_TYPE comando,px,py,condicionf;



int coord2us(float coord);
void draw();
void nodraw();
void vertex2d(float x, float y);
///////////////////////////////////////////////////////
void ejecutar(){
    pc.printf("se esta ejecutando el dibujo...");    
    for(i=0;i<mem_head-1;i++)
    {   
        if (arreglo2[i]==CM_VERTEX2D)//FD F0
        {
            i++;
            px=arreglo2[i]
            
        }
    }

}
/////////////////////////////////////////////////////////////
void guardar(){
    pc.printf("se inicia el comado de guardar..");    
    mem_head=0;
            do
            {
                pc.printf("entro while llenar\n\r");
                arreglo2[mem_head]=pc.getc();
                b=arreglo2[mem_head];
                //pc.printf("posicion %i %c",mem_head,arreglo2[mem_head]);
                mem_head++;  
            }
            while(b!=CM_STOP);
    
 }
 
int main() {
     // configuracion de  periodo
    motor_x.period_ms(periodo);
    motor_y.period_ms(periodo);
    motor_z.period_ms(periodo);
    motor_x.pulsewidth_us(725);
    motor_y.pulsewidth_us(725);
    motor_z.pulsewidth_us(725);
    int posx=0;
    int posy=0;
    char caracter;
  while(1)
    {
        caracter=pc.getc();
        switch (caracter) {
            case  CM_EJECUTAR: ejecutar(); break;
            case  CM_GUARDAR: guardar(); break;
            default: pc.printf("error de comando\r\n");break ;      
        }
    }
}


int coord2us(float coord)
{
    if(0 <= coord <= MAXPOS)
        return int(750+coord*1900/50);// u6
    return 750;
 
}
 
void draw()
{
motor_z.pulsewidth_us(POSDRAW);
wait(1);
}
void nodraw()
{
motor_z.pulsewidth_us(MAXPOS);
wait(1);
}
void vertex2d(float x, float y){
 
    int pulseX = coord2us(x);
    int pulseY = coord2us(y);
    
    motor_x.pulsewidth_us(pulseX);
    motor_y.pulsewidth_us(pulseY);
    wait_ms(SS_TIME);
 
}
