#include "AD9837.h"
#include "mbed.h"

#define REG_FREQ1   0x8000
#define REG_FREQ0   0x4000
#define REG_PHASE0  0xC000
#define REG_PHASE1  0xE000

#define REG_B28     0x2000
#define REG_HLB     0x1000
#define REG_FSEL    0x0800
#define REG_PSEL    0x0400
#define REG_PINSW   0x0200
#define REG_RESET   0x0100
#define REG_SLEEP1  0x0080
#define REG_SLEEP12 0x0040
#define REG_OPBITEN 0x0020
#define REG_SIGNPIB 0x0010
#define REG_DIV2    0x0008
#define REG_MODE    0x0002

#define SIGN_OUTPUT_MASK (REG_OPBITEN | REG_SIGNPIB | REG_DIV2 | REG_MODE)

AD9837::AD9837(PinName mosi, PinName miso, PinName sclk, PinName cs) : _spi(mosi, miso, sclk), _cs(cs) {
    
    _spi.format(8, 2);
    _spi.frequency(1000000);
}

void AD9837::writeReg(uint16_t value)
{
    _cs=0;
    wait_us(10);
    _spi.write(value >> 8);
    _spi.write(value & 0xFF);
    wait_us(10);
    _cs=1;
}

void AD9837::setFrequencyWord(unsigned int reg, uint32_t frequency)
{
    writeReg((reg?REG_FREQ1:REG_FREQ0) | (frequency & 0x3FFF));
    writeReg((reg?REG_FREQ1:REG_FREQ0) | ((frequency >> 14) & 0x3FFF));
}

void AD9837::setPhaseWord(unsigned int reg, uint32_t phase)
{
    writeReg((reg?REG_PHASE1:REG_PHASE0) | (phase & 0x0FFF));
}

void AD9837::setSignOutput(SignOutput out)
{
    m_reg = (m_reg & ~SIGN_OUTPUT_MASK) | out;
    writeReg(m_reg);
}

void AD9837::setOutputMode(OutputMode out)
{
    if(out == OUTPUT_MODE_TRIANGLE) {
        m_reg = (m_reg & ~SIGN_OUTPUT_MASK) | out;
    } if(out == OUTPUT_MODE_SINE) {
        m_reg &= ~REG_MODE;
    }else {
        m_reg = 0x2A;
    }
    writeReg(m_reg);
}